/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.compat;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.level.storage.ExposureIdentifier;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ExposureCompatImpl {
    public static List<ItemStack> getPhotographsFromInventory(Player player) {
        ArrayList<ItemStack> photos = new ArrayList<ItemStack>();
        for (ItemStack stack : player.getInventory().items) {
            if (stack.isEmpty() || !(stack.getItem() instanceof PhotographItem)) continue;
            photos.add(stack.copy());
        }
        ItemStack offhand = player.getOffhandItem();
        if (!offhand.isEmpty() && offhand.getItem() instanceof PhotographItem) {
            photos.add(offhand.copy());
        }
        return photos;
    }

    public static String getPhotoId(ItemStack stack) {
        PhotographItem photographItem;
        Frame frame;
        if (stack.isEmpty()) {
            return null;
        }
        Item item = stack.getItem();
        if (item instanceof PhotographItem && (frame = (photographItem = (PhotographItem)item).getFrame(stack)) != null && frame != Frame.EMPTY && frame.identifier() != null) {
            try {
                ExposureIdentifier identifier = frame.identifier();
                if (identifier != null) {
                    String idStr = identifier.id();
                    return idStr != null && !idStr.isEmpty() ? idStr : null;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static ItemStack createPhotographFromId(String photoId) {
        if (photoId == null || photoId.isEmpty()) {
            return ItemStack.EMPTY;
        }
        try {
            ItemStack stack = new ItemStack((ItemLike)Exposure.Items.PHOTOGRAPH.get());
            Frame frame = Frame.EMPTY.toMutable().setIdentifier(ExposureIdentifier.id((String)photoId)).toImmutable();
            stack.set(Exposure.DataComponents.PHOTOGRAPH_FRAME, (Object)frame);
            return stack;
        }
        catch (Exception e) {
            WXMCWeatherAddon.LOGGER.warn("Failed to create photograph from ID {}: {}", (Object)photoId, (Object)e.getMessage());
            return ItemStack.EMPTY;
        }
    }

    public static Frame getFrame(ItemStack stack) {
        PhotographItem photographItem;
        Frame frame;
        if (stack.isEmpty()) {
            return null;
        }
        Item item = stack.getItem();
        if (item instanceof PhotographItem && (frame = (photographItem = (PhotographItem)item).getFrame(stack)) != null && frame != Frame.EMPTY) {
            return frame;
        }
        return null;
    }

    public static boolean renderPhotographInGui(GuiGraphics graphics, ItemStack stack, int x, int y, int size) {
        if (stack.isEmpty() || !(stack.getItem() instanceof PhotographItem)) {
            return false;
        }
        try {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableDepthTest();
            graphics.pose().pushPose();
            graphics.pose().translate((float)x, (float)y, 50.0f);
            graphics.pose().scale((float)size, (float)size, 1.0f);
            MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            boolean rendered = ExposureClient.photographRenderer().render(stack, true, false, graphics.pose(), (MultiBufferSource)bufferSource, 0xF000F0, 255, 255, 255, 255);
            bufferSource.endBatch();
            graphics.pose().popPose();
            RenderSystem.enableDepthTest();
            return rendered;
        }
        catch (Exception e) {
            WXMCWeatherAddon.LOGGER.warn("Failed to render photograph in GUI: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean savePhotoToPng(ItemStack stack, Path outputPath) {
        if (stack.isEmpty()) {
            return false;
        }
        try {
            Frame frame = ExposureCompatImpl.getFrame(stack);
            if (frame == null || frame.identifier() == null) {
                WXMCWeatherAddon.LOGGER.warn("Cannot save photo: no valid frame data");
                return false;
            }
            ExposureIdentifier identifier = frame.identifier();
            String photoId = identifier.id();
            if (photoId == null || photoId.isEmpty()) {
                return false;
            }
            NativeImage image = ExposureCompatImpl.getExposureImage(frame);
            if (image != null) {
                Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
                image.writeToFile(outputPath);
                WXMCWeatherAddon.LOGGER.debug("Saved photo to: {}", (Object)outputPath);
                return true;
            }
            WXMCWeatherAddon.LOGGER.warn("Could not get image data for photo: {}", (Object)photoId);
            return false;
        }
        catch (Exception e) {
            WXMCWeatherAddon.LOGGER.error("Failed to save photo to PNG", (Throwable)e);
            return false;
        }
    }

    private static NativeImage getExposureImage(Frame frame) {
        try {
            String photoId;
            block17: {
                StringBuilder methodList;
                Class<?> exposureClientClass;
                ExposureIdentifier identifier;
                block16: {
                    identifier = frame.identifier();
                    if (identifier == null) {
                        WXMCWeatherAddon.LOGGER.warn("Frame has no identifier");
                        return null;
                    }
                    photoId = identifier.id();
                    WXMCDebugLogger.debug("Attempting to extract image for photo: {}", photoId);
                    exposureClientClass = Class.forName("io.github.mortuusars.exposure.ExposureClient");
                    try {
                        Field renderedField = exposureClientClass.getDeclaredField("RENDERED_EXPOSURES");
                        renderedField.setAccessible(true);
                        Object renderedExposures = renderedField.get(null);
                        WXMCDebugLogger.debug("RENDERED_EXPOSURES found: {}", renderedExposures != null);
                        if (renderedExposures == null) break block16;
                        methodList = new StringBuilder();
                        for (Method m : renderedExposures.getClass().getMethods()) {
                            if (m.getDeclaringClass().equals(Object.class)) continue;
                            methodList.append(m.getName()).append("(").append(m.getParameterCount()).append("), ");
                        }
                        WXMCDebugLogger.debug("RenderedExposures methods: {}", methodList);
                        try {
                            Method getOrCreateMethod = renderedExposures.getClass().getMethod("getOrCreate", Frame.class);
                            Object rendered = getOrCreateMethod.invoke(renderedExposures, frame);
                            WXMCDebugLogger.debug("getOrCreate result: {} (type: {})", rendered, rendered != null ? rendered.getClass().getSimpleName() : "null");
                            if (rendered != null) {
                                NativeImage nativeImage = ExposureCompatImpl.extractNativeImage(rendered);
                                if (nativeImage != null && nativeImage.getWidth() > 1) {
                                    WXMCDebugLogger.debug("Extracted {}x{} NativeImage from Instance!", nativeImage.getWidth(), nativeImage.getHeight());
                                    return nativeImage;
                                }
                                WXMCDebugLogger.debug("Instance extraction failed or returned 1x1 image");
                            }
                        }
                        catch (NoSuchMethodException e) {
                            WXMCDebugLogger.debug("getOrCreate(Frame) not found");
                        }
                    }
                    catch (NoSuchFieldException e) {
                        WXMCDebugLogger.debug("RENDERED_EXPOSURES field not found");
                    }
                }
                try {
                    Field storeField = exposureClientClass.getDeclaredField("EXPOSURE_STORE");
                    storeField.setAccessible(true);
                    Object exposureStore = storeField.get(null);
                    WXMCDebugLogger.debug("EXPOSURE_STORE found: {}", exposureStore != null);
                    if (exposureStore == null) break block17;
                    methodList = new StringBuilder();
                    for (Method m : exposureStore.getClass().getMethods()) {
                        if (m.getDeclaringClass().equals(Object.class)) continue;
                        methodList.append(m.getName()).append("(").append(m.getParameterCount()).append("), ");
                    }
                    WXMCDebugLogger.debug("ExposureStore methods: {}", methodList);
                    for (Method method : exposureStore.getClass().getMethods()) {
                        if (!method.getName().contains("get") || method.getParameterCount() != 1) continue;
                        try {
                            Object exposureData = method.invoke(exposureStore, identifier);
                            if (exposureData == null) continue;
                            WXMCDebugLogger.debug("ExposureStore.{} returned: {}", method.getName(), exposureData.getClass().getName());
                            NativeImage nativeImage = ExposureCompatImpl.extractFromExposureData(exposureData);
                            if (nativeImage == null) continue;
                            return nativeImage;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                catch (NoSuchFieldException e) {
                    WXMCDebugLogger.debug("EXPOSURE_STORE field not found");
                }
            }
            WXMCDebugLogger.debug("No image data found for: {}", photoId);
        }
        catch (Exception e) {
            WXMCWeatherAddon.LOGGER.warn("Failed to get exposure image: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    private static NativeImage extractNativeImage(Object imageObj) {
        WXMCDebugLogger.debug("extractNativeImage called with: {}", imageObj.getClass().getName());
        try {
            StringBuilder methodList = new StringBuilder();
            for (Method method : imageObj.getClass().getMethods()) {
                if (method.getParameterCount() != 0 || method.getDeclaringClass().equals(Object.class)) continue;
                methodList.append(method.getName()).append("->").append(method.getReturnType().getSimpleName()).append(", ");
            }
            WXMCDebugLogger.debug("Image object methods: {}", methodList);
            for (Method method : imageObj.getClass().getMethods()) {
                if (method.getParameterCount() != 0 || method.getReturnType() != NativeImage.class) continue;
                WXMCDebugLogger.debug("Found NativeImage method: {}", method.getName());
                Object result = method.invoke(imageObj, new Object[0]);
                if (!(result instanceof NativeImage)) continue;
                NativeImage nativeImage = (NativeImage)result;
                return nativeImage;
            }
            try {
                Method widthMethod = imageObj.getClass().getMethod("width", new Class[0]);
                Method heightMethod = imageObj.getClass().getMethod("height", new Class[0]);
                int width = (Integer)widthMethod.invoke(imageObj, new Object[0]);
                int height = (Integer)heightMethod.invoke(imageObj, new Object[0]);
                WXMCDebugLogger.debug("Image dimensions: {}x{}", width, height);
                if (width > 0 && height > 0) {
                    Method getPixelMethod = ExposureCompatImpl.findPixelMethod(imageObj.getClass());
                    if (getPixelMethod != null) {
                        WXMCDebugLogger.debug("Found pixel method: {} - extracting {}x{} image", getPixelMethod.getName(), width, height);
                        NativeImage nativeImage = new NativeImage(width, height, false);
                        for (int y = 0; y < height; ++y) {
                            for (int x = 0; x < width; ++x) {
                                int pixel = (Integer)getPixelMethod.invoke(imageObj, x, y);
                                int a = pixel >> 24 & 0xFF;
                                int r = pixel >> 16 & 0xFF;
                                int g = pixel >> 8 & 0xFF;
                                int b = pixel & 0xFF;
                                int abgr = a << 24 | b << 16 | g << 8 | r;
                                nativeImage.setPixelRGBA(x, y, abgr);
                            }
                        }
                        WXMCDebugLogger.debug("Successfully created NativeImage!");
                        return nativeImage;
                    }
                    WXMCDebugLogger.debug("No pixel method found");
                }
            }
            catch (NoSuchMethodException e) {
                WXMCDebugLogger.debug("No width/height methods on image object");
            }
        }
        catch (Exception e) {
            WXMCDebugLogger.debug("extractNativeImage failed: {}", e.getMessage());
        }
        return null;
    }

    private static Method findPixelMethod(Class<?> clazz) {
        StringBuilder twoParamMethods = new StringBuilder();
        for (Method m : clazz.getMethods()) {
            if (m.getParameterCount() != 2) continue;
            Class<?>[] params = m.getParameterTypes();
            twoParamMethods.append(m.getName()).append("(").append(params[0].getSimpleName()).append(",").append(params[1].getSimpleName()).append("), ");
        }
        WXMCDebugLogger.debug("2-param methods on {}: {}", clazz.getSimpleName(), twoParamMethods);
        String[] methodNames = new String[]{"getPixelARGB", "getPixelABGR", "getPixel", "getPixelRGBA"};
        for (String name : methodNames) {
            try {
                return clazz.getMethod(name, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        for (Method m : clazz.getMethods()) {
            String name = m.getName().toLowerCase();
            if (!name.contains("pixel") && !name.contains("color") || m.getParameterCount() != 2) continue;
            WXMCDebugLogger.debug("Found potential pixel method: {} with params {}", m.getName(), m.getParameterTypes());
            return m;
        }
        return null;
    }

    private static NativeImage extractFromExposureData(Object exposureData) {
        try {
            Method[] methods;
            for (Method method : methods = exposureData.getClass().getMethods()) {
                NativeImage extracted;
                String name = method.getName();
                if (!name.equals("getImage") && !name.equals("image") || method.getParameterCount() != 0) continue;
                Object result = method.invoke(exposureData, new Object[0]);
                if (result instanceof NativeImage) {
                    NativeImage nativeImage = (NativeImage)result;
                    return nativeImage;
                }
                if (result == null || (extracted = ExposureCompatImpl.extractNativeImage(result)) == null) continue;
                return extracted;
            }
        }
        catch (Exception e) {
            WXMCWeatherAddon.LOGGER.debug("Could not extract from ExposureData: {}", (Object)e.getMessage());
        }
        return null;
    }
}

