/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.compat;

import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.compat.ExposureCompatImpl;
import io.netty.buffer.Unpooled;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;

public class ExposureCompat {
    private static Boolean exposureLoaded = null;

    public static boolean isExposureLoaded() {
        if (exposureLoaded == null && (exposureLoaded = Boolean.valueOf(ModList.get().isLoaded("exposure"))).booleanValue()) {
            WXMCWeatherAddon.LOGGER.info("Exposure mod detected - photo features enabled");
        }
        return exposureLoaded;
    }

    public static List<ItemStack> getPhotographsFromInventory(Player player) {
        if (!ExposureCompat.isExposureLoaded()) {
            return List.of();
        }
        try {
            return ExposureCompatImpl.getPhotographsFromInventory(player);
        }
        catch (Exception | NoClassDefFoundError e) {
            WXMCWeatherAddon.LOGGER.warn("Failed to get photographs from inventory: {}", (Object)e.getMessage());
            return List.of();
        }
    }

    public static String getPhotoId(ItemStack stack) {
        if (!ExposureCompat.isExposureLoaded() || stack.isEmpty()) {
            return null;
        }
        try {
            return ExposureCompatImpl.getPhotoId(stack);
        }
        catch (Exception | NoClassDefFoundError e) {
            WXMCWeatherAddon.LOGGER.warn("Failed to get photo ID: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static boolean isValidPhotograph(ItemStack stack) {
        return ExposureCompat.getPhotoId(stack) != null;
    }

    public static List<String> getPhotoIds(List<ItemStack> stacks) {
        ArrayList<String> ids = new ArrayList<String>();
        for (ItemStack stack : stacks) {
            String id = ExposureCompat.getPhotoId(stack);
            if (id == null) continue;
            ids.add(id);
        }
        return ids;
    }

    public static ItemStack createPhotographFromId(String photoId) {
        if (!ExposureCompat.isExposureLoaded() || photoId == null || photoId.isEmpty()) {
            return ItemStack.EMPTY;
        }
        try {
            return ExposureCompatImpl.createPhotographFromId(photoId);
        }
        catch (Exception | NoClassDefFoundError e) {
            WXMCWeatherAddon.LOGGER.warn("Failed to create photograph from ID: {}", (Object)e.getMessage());
            return ItemStack.EMPTY;
        }
    }

    public static boolean savePhotoToPng(ItemStack stack, Path outputPath) {
        if (!ExposureCompat.isExposureLoaded() || stack.isEmpty()) {
            return false;
        }
        try {
            return ExposureCompatImpl.savePhotoToPng(stack, outputPath);
        }
        catch (Exception | NoClassDefFoundError e) {
            WXMCWeatherAddon.LOGGER.warn("Failed to save photo to PNG: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean renderPhotographInGui(GuiGraphics graphics, ItemStack stack, int x, int y, int size) {
        if (!ExposureCompat.isExposureLoaded() || stack.isEmpty()) {
            return false;
        }
        try {
            return ExposureCompatImpl.renderPhotographInGui(graphics, stack, x, y, size);
        }
        catch (Exception | NoClassDefFoundError e) {
            WXMCWeatherAddon.LOGGER.warn("Failed to render photograph: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static byte[] serializeItemStack(ItemStack stack, RegistryAccess registryAccess) {
        if (stack.isEmpty()) {
            return new byte[0];
        }
        try {
            RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), registryAccess);
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)stack);
            byte[] data = new byte[buf.readableBytes()];
            buf.readBytes(data);
            buf.release();
            return data;
        }
        catch (Exception e) {
            WXMCWeatherAddon.LOGGER.warn("Failed to serialize ItemStack: {}", (Object)e.getMessage());
            return new byte[0];
        }
    }

    public static ItemStack deserializeItemStack(byte[] data, RegistryAccess registryAccess) {
        if (data == null || data.length == 0) {
            return ItemStack.EMPTY;
        }
        try {
            RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data), registryAccess);
            ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            buf.release();
            return stack;
        }
        catch (Exception e) {
            WXMCWeatherAddon.LOGGER.warn("Failed to deserialize ItemStack: {}", (Object)e.getMessage());
            return ItemStack.EMPTY;
        }
    }
}

