/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.compat;

import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class BukkitEventBridge {
    private static boolean bukkitAvailable = false;
    private static boolean initialized = false;
    private static Class<?> bukkitClass;
    private static Method getPlayerMethod;
    private static Method getWorldMethod;
    private static Method getPluginManagerMethod;
    private static Method callEventMethod;
    private static ClassLoader bridgePluginClassLoader;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            bukkitClass = Class.forName("org.bukkit.Bukkit");
            getPlayerMethod = bukkitClass.getMethod("getPlayer", UUID.class);
            getWorldMethod = bukkitClass.getMethod("getWorld", String.class);
            getPluginManagerMethod = bukkitClass.getMethod("getPluginManager", new Class[0]);
            Class<?> pluginManagerClass = Class.forName("org.bukkit.plugin.PluginManager");
            Class<?> eventClass = Class.forName("org.bukkit.event.Event");
            callEventMethod = pluginManagerClass.getMethod("callEvent", eventClass);
            bukkitAvailable = true;
            WXMCDebugLogger.info("[BetonQuest Bridge] Bukkit API detected - event bridge enabled");
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            bukkitAvailable = false;
        }
    }

    private static void findBridgePluginClassLoader() {
        try {
            Object[] plugins;
            Object pluginManager = getPluginManagerMethod.invoke(null, new Object[0]);
            Method getPluginMethod = pluginManager.getClass().getMethod("getPlugin", String.class);
            Object bridgePlugin = getPluginMethod.invoke(pluginManager, "WXMCBetonQuestBridge");
            if (bridgePlugin != null) {
                bridgePluginClassLoader = bridgePlugin.getClass().getClassLoader();
                WXMCDebugLogger.debug("[BetonQuest] Found bridge plugin classloader");
                return;
            }
            Method getPluginsMethod = pluginManager.getClass().getMethod("getPlugins", new Class[0]);
            for (Object plugin : plugins = (Object[])getPluginsMethod.invoke(pluginManager, new Object[0])) {
                ClassLoader pluginCL = plugin.getClass().getClassLoader();
                try {
                    Class.forName("dev.wxmc.betonquest.events.TornadoReportedEvent", false, pluginCL);
                    bridgePluginClassLoader = pluginCL;
                    WXMCDebugLogger.debug("[BetonQuest] Found bridge plugin via search");
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        catch (Exception e) {
            WXMCDebugLogger.debug("[BetonQuest] Bridge plugin not found: {}", e.getMessage());
        }
    }

    private static Class<?> findPluginClass(String className) {
        if (bridgePluginClassLoader == null) {
            BukkitEventBridge.findBridgePluginClassLoader();
        }
        if (bridgePluginClassLoader != null) {
            try {
                return Class.forName(className, true, bridgePluginClassLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
            if (contextCL != null) {
                return Class.forName(className, true, contextCL);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static boolean isBukkitAvailable() {
        if (!initialized) {
            BukkitEventBridge.init();
        }
        return bukkitAvailable;
    }

    public static void fireTornadoReported(ServerPlayer player, long tornadoId, int totalCount, double x, double z, int windspeed) {
        if (!BukkitEventBridge.isBukkitAvailable()) {
            return;
        }
        try {
            Object bukkitPlayer = getPlayerMethod.invoke(null, player.getUUID());
            if (bukkitPlayer == null) {
                return;
            }
            Class<?> eventClass = BukkitEventBridge.findPluginClass("dev.wxmc.betonquest.events.TornadoReportedEvent");
            if (eventClass == null) {
                return;
            }
            Class<?> playerClass = BukkitEventBridge.findPluginClass("org.bukkit.entity.Player");
            if (playerClass == null) {
                playerClass = Class.forName("org.bukkit.entity.Player");
            }
            Object event = eventClass.getConstructor(playerClass, Long.TYPE, Integer.TYPE, Double.TYPE, Double.TYPE, Integer.TYPE).newInstance(bukkitPlayer, tornadoId, totalCount, x, z, windspeed);
            Object pluginManager = getPluginManagerMethod.invoke(null, new Object[0]);
            callEventMethod.invoke(pluginManager, event);
            WXMCDebugLogger.debug("[BetonQuest] TornadoReportedEvent fired for {}", player.getName().getString());
        }
        catch (Exception e) {
            WXMCDebugLogger.debug("[BetonQuest] Failed to fire TornadoReportedEvent: {}", e.getMessage());
        }
    }

    public static void fireTornadoPhotographed(ServerPlayer player, long tornadoId, int windspeed, double x, double z) {
        if (!BukkitEventBridge.isBukkitAvailable()) {
            return;
        }
        try {
            Object bukkitPlayer = getPlayerMethod.invoke(null, player.getUUID());
            if (bukkitPlayer == null) {
                return;
            }
            Class<?> eventClass = BukkitEventBridge.findPluginClass("dev.wxmc.betonquest.events.TornadoPhotographedEvent");
            if (eventClass == null) {
                return;
            }
            Class<?> playerClass = BukkitEventBridge.findPluginClass("org.bukkit.entity.Player");
            if (playerClass == null) {
                playerClass = Class.forName("org.bukkit.entity.Player");
            }
            Object event = eventClass.getConstructor(playerClass, Long.TYPE, Integer.TYPE, Double.TYPE, Double.TYPE).newInstance(bukkitPlayer, tornadoId, windspeed, x, z);
            Object pluginManager = getPluginManagerMethod.invoke(null, new Object[0]);
            callEventMethod.invoke(pluginManager, event);
            WXMCDebugLogger.debug("[BetonQuest] TornadoPhotographedEvent fired for {}", player.getName().getString());
        }
        catch (Exception e) {
            WXMCDebugLogger.debug("[BetonQuest] Failed to fire TornadoPhotographedEvent: {}", e.getMessage());
        }
    }

    public static void fireTornadoAssessed(ServerPlayer player, UUID assessmentId, String rating, int ratingOrdinal, int photoCount, int x, int z) {
        if (!BukkitEventBridge.isBukkitAvailable()) {
            return;
        }
        try {
            Object bukkitPlayer = getPlayerMethod.invoke(null, player.getUUID());
            if (bukkitPlayer == null) {
                return;
            }
            Class<?> eventClass = BukkitEventBridge.findPluginClass("dev.wxmc.betonquest.events.TornadoAssessedEvent");
            if (eventClass == null) {
                return;
            }
            Class<?> playerClass = BukkitEventBridge.findPluginClass("org.bukkit.entity.Player");
            if (playerClass == null) {
                playerClass = Class.forName("org.bukkit.entity.Player");
            }
            Object event = eventClass.getConstructor(playerClass, UUID.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(bukkitPlayer, assessmentId, rating, ratingOrdinal, photoCount, x, z);
            Object pluginManager = getPluginManagerMethod.invoke(null, new Object[0]);
            callEventMethod.invoke(pluginManager, event);
            WXMCDebugLogger.debug("[BetonQuest] TornadoAssessedEvent fired for {}", player.getName().getString());
        }
        catch (Exception e) {
            WXMCDebugLogger.debug("[BetonQuest] Failed to fire TornadoAssessedEvent: {}", e.getMessage());
        }
    }

    public static void fireTornadoSpawned(Level level, long tornadoId, double x, double z, int maxWindspeed) {
        if (!BukkitEventBridge.isBukkitAvailable()) {
            return;
        }
        try {
            Object bukkitWorld = BukkitEventBridge.getBukkitWorld(level);
            if (bukkitWorld == null) {
                return;
            }
            Class<?> eventClass = BukkitEventBridge.findPluginClass("dev.wxmc.betonquest.events.TornadoSpawnedEvent");
            if (eventClass == null) {
                return;
            }
            Class<?> worldClass = BukkitEventBridge.findPluginClass("org.bukkit.World");
            if (worldClass == null) {
                worldClass = Class.forName("org.bukkit.World");
            }
            Object event = eventClass.getConstructor(Long.TYPE, worldClass, Double.TYPE, Double.TYPE, Integer.TYPE).newInstance(tornadoId, bukkitWorld, x, z, maxWindspeed);
            Object pluginManager = getPluginManagerMethod.invoke(null, new Object[0]);
            callEventMethod.invoke(pluginManager, event);
            WXMCDebugLogger.debug("[BetonQuest] TornadoSpawnedEvent fired for storm {}", tornadoId);
        }
        catch (Exception e) {
            WXMCDebugLogger.debug("[BetonQuest] Failed to fire TornadoSpawnedEvent: {}", e.getMessage());
        }
    }

    public static void fireTornadoDissipated(Level level, long tornadoId, int peakWindspeed, int durationTicks) {
        if (!BukkitEventBridge.isBukkitAvailable()) {
            return;
        }
        try {
            Object bukkitWorld = BukkitEventBridge.getBukkitWorld(level);
            if (bukkitWorld == null) {
                return;
            }
            Class<?> eventClass = BukkitEventBridge.findPluginClass("dev.wxmc.betonquest.events.TornadoDissipatedEvent");
            if (eventClass == null) {
                return;
            }
            Class<?> worldClass = BukkitEventBridge.findPluginClass("org.bukkit.World");
            if (worldClass == null) {
                worldClass = Class.forName("org.bukkit.World");
            }
            Object event = eventClass.getConstructor(Long.TYPE, worldClass, Integer.TYPE, Integer.TYPE).newInstance(tornadoId, bukkitWorld, peakWindspeed, durationTicks);
            Object pluginManager = getPluginManagerMethod.invoke(null, new Object[0]);
            callEventMethod.invoke(pluginManager, event);
            WXMCDebugLogger.debug("[BetonQuest] TornadoDissipatedEvent fired for storm {}", tornadoId);
        }
        catch (Exception e) {
            WXMCDebugLogger.debug("[BetonQuest] Failed to fire TornadoDissipatedEvent: {}", e.getMessage());
        }
    }

    public static void firePlayerEnteredWarning(ServerPlayer player, String warningType, long stormId) {
        if (!BukkitEventBridge.isBukkitAvailable()) {
            return;
        }
        try {
            Object bukkitPlayer = getPlayerMethod.invoke(null, player.getUUID());
            if (bukkitPlayer == null) {
                return;
            }
            Class<?> eventClass = BukkitEventBridge.findPluginClass("dev.wxmc.betonquest.events.PlayerEnteredWarningEvent");
            if (eventClass == null) {
                return;
            }
            Class<?> playerClass = BukkitEventBridge.findPluginClass("org.bukkit.entity.Player");
            if (playerClass == null) {
                playerClass = Class.forName("org.bukkit.entity.Player");
            }
            Object event = eventClass.getConstructor(playerClass, String.class, Long.TYPE).newInstance(bukkitPlayer, warningType, stormId);
            Object pluginManager = getPluginManagerMethod.invoke(null, new Object[0]);
            callEventMethod.invoke(pluginManager, event);
            WXMCDebugLogger.debug("[BetonQuest] PlayerEnteredWarningEvent fired for {}", player.getName().getString());
        }
        catch (Exception e) {
            WXMCDebugLogger.debug("[BetonQuest] Failed to fire PlayerEnteredWarningEvent: {}", e.getMessage());
        }
    }

    public static void fireWarningIssued(Level level, String warningType, long stormId, double centerX, double centerZ, double radius) {
        if (!BukkitEventBridge.isBukkitAvailable()) {
            return;
        }
        try {
            Object bukkitWorld = BukkitEventBridge.getBukkitWorld(level);
            if (bukkitWorld == null) {
                return;
            }
            Class<?> eventClass = BukkitEventBridge.findPluginClass("dev.wxmc.betonquest.events.WarningIssuedEvent");
            if (eventClass == null) {
                return;
            }
            Class<?> worldClass = BukkitEventBridge.findPluginClass("org.bukkit.World");
            if (worldClass == null) {
                worldClass = Class.forName("org.bukkit.World");
            }
            Object event = eventClass.getConstructor(worldClass, String.class, Long.TYPE, Double.TYPE, Double.TYPE, Double.TYPE).newInstance(bukkitWorld, warningType, stormId, centerX, centerZ, radius);
            Object pluginManager = getPluginManagerMethod.invoke(null, new Object[0]);
            callEventMethod.invoke(pluginManager, event);
            WXMCDebugLogger.debug("[BetonQuest] WarningIssuedEvent fired for storm {}", stormId);
        }
        catch (Exception e) {
            WXMCDebugLogger.debug("[BetonQuest] Failed to fire WarningIssuedEvent: {}", e.getMessage());
        }
    }

    public static void fireTornadoEntryAccepted(UUID submitterUUID, String submitterName, int acceptedCount, int ratingOrdinal, UUID entryId) {
        if (!BukkitEventBridge.isBukkitAvailable()) {
            return;
        }
        try {
            Object bukkitPlayer = getPlayerMethod.invoke(null, submitterUUID);
            Class<?> eventClass = BukkitEventBridge.findPluginClass("dev.wxmc.betonquest.events.TornadoEntryAcceptedEvent");
            if (eventClass == null) {
                return;
            }
            Class<?> playerClass = BukkitEventBridge.findPluginClass("org.bukkit.entity.Player");
            if (playerClass == null) {
                playerClass = Class.forName("org.bukkit.entity.Player");
            }
            Object event = eventClass.getConstructor(UUID.class, String.class, Integer.TYPE, Integer.TYPE, UUID.class, playerClass).newInstance(submitterUUID, submitterName, acceptedCount, ratingOrdinal, entryId, bukkitPlayer);
            Object pluginManager = getPluginManagerMethod.invoke(null, new Object[0]);
            callEventMethod.invoke(pluginManager, event);
            WXMCDebugLogger.debug("[BetonQuest] TornadoEntryAcceptedEvent fired for {} (count: {})", submitterName, acceptedCount);
        }
        catch (Exception e) {
            WXMCDebugLogger.debug("[BetonQuest] Failed to fire TornadoEntryAcceptedEvent: {}", e.getMessage());
        }
    }

    private static Object getBukkitWorld(Level level) {
        try {
            String worldName = level.dimension().location().getPath();
            if (worldName.equals("overworld")) {
                worldName = "world";
            } else if (worldName.equals("the_nether")) {
                worldName = "world_nether";
            } else if (worldName.equals("the_end")) {
                worldName = "world_the_end";
            }
            return getWorldMethod.invoke(null, worldName);
        }
        catch (Exception e) {
            return null;
        }
    }
}

