/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.wxmc.weatheraddon.data.TornadoDatabase;
import dev.wxmc.weatheraddon.data.TornadoEntry;
import dev.wxmc.weatheraddon.network.DamageAssessmentNetworkHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class TordbCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tordb").requires(source -> source.hasPermission(0))).executes(context -> TordbCommand.openDatabase((CommandContext<CommandSourceStack>)context)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tornadodb").requires(source -> source.hasPermission(0))).executes(context -> TordbCommand.openDatabase((CommandContext<CommandSourceStack>)context)));
    }

    private static int openDatabase(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!source.isPlayer()) {
            source.sendFailure((Component)Component.literal((String)"This command can only be used by players."));
            return 0;
        }
        ServerPlayer player = source.getPlayer();
        if (player == null) {
            source.sendFailure((Component)Component.literal((String)"Could not find player."));
            return 0;
        }
        List<TornadoEntry> entries = TornadoDatabase.getOrCreate(player.getServer()).getEntries();
        DamageAssessmentNetworkHandler.sendDatabaseEntries(player, new ArrayList<TornadoEntry>(entries));
        return 1;
    }
}

