/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.wxmc.weatheraddon.data.SubmissionReview;
import dev.wxmc.weatheraddon.data.TornadoDatabase;
import dev.wxmc.weatheraddon.data.TornadoEntry;
import dev.wxmc.weatheraddon.data.TornadoRating;
import dev.wxmc.weatheraddon.network.DamageAssessmentNetworkHandler;
import dev.wxmc.weatheraddon.util.PermissionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class TordbAdminCommand {
    public static final String ADMIN_PERMISSION = "wxmc.admin";
    private static final SuggestionProvider<CommandSourceStack> RATING_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.suggest((Iterable)Arrays.stream(TornadoRating.values()).map(Enum::name).collect(Collectors.toList()), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> EVENT_ID_SUGGESTIONS = (context, builder) -> {
        if (((CommandSourceStack)context.getSource()).getServer() != null) {
            List eventIds = TornadoDatabase.getOrCreate(((CommandSourceStack)context.getSource()).getServer()).getEntries().stream().map(TornadoEntry::eventId).distinct().collect(Collectors.toList());
            return SharedSuggestionProvider.suggest(eventIds, (SuggestionsBuilder)builder);
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tordbadmin").requires(source -> TordbAdminCommand.hasAdminPermission(source))).executes(context -> TordbAdminCommand.openAdminDatabase((CommandContext<CommandSourceStack>)context))).then(Commands.literal((String)"edit").then(Commands.argument((String)"eventId", (ArgumentType)StringArgumentType.string()).suggests(EVENT_ID_SUGGESTIONS).then(Commands.argument((String)"rating", (ArgumentType)StringArgumentType.word()).suggests(RATING_SUGGESTIONS).executes(context -> TordbAdminCommand.editRating((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"eventId"), StringArgumentType.getString((CommandContext)context, (String)"rating"))))))).then(Commands.literal((String)"delete").then(Commands.argument((String)"eventId", (ArgumentType)StringArgumentType.string()).suggests(EVENT_ID_SUGGESTIONS).executes(context -> TordbAdminCommand.deleteEntry((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"eventId")))))).then(Commands.literal((String)"deletereview").then(Commands.argument((String)"eventId", (ArgumentType)StringArgumentType.string()).suggests(EVENT_ID_SUGGESTIONS).then(Commands.argument((String)"reviewerName", (ArgumentType)StringArgumentType.string()).executes(context -> TordbAdminCommand.deleteReview((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"eventId"), StringArgumentType.getString((CommandContext)context, (String)"reviewerName"))))))).then(Commands.literal((String)"clear").then(Commands.literal((String)"confirm").executes(context -> TordbAdminCommand.clearAll((CommandContext<CommandSourceStack>)context)))));
    }

    private static boolean hasAdminPermission(CommandSourceStack source) {
        if (!source.isPlayer()) {
            return true;
        }
        ServerPlayer player = source.getPlayer();
        if (player == null) {
            return false;
        }
        if (player.hasPermissions(2)) {
            return true;
        }
        return PermissionHelper.hasPermission(player, ADMIN_PERMISSION);
    }

    private static int openAdminDatabase(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!source.isPlayer()) {
            source.sendFailure((Component)Component.literal((String)"This command must be used by a player. Use /tordbadmin list for console."));
            return 0;
        }
        ServerPlayer player = source.getPlayer();
        if (player == null) {
            return 0;
        }
        List<TornadoEntry> entries = TornadoDatabase.getOrCreate(player.getServer()).getEntries();
        DamageAssessmentNetworkHandler.sendDatabaseEntriesAdmin(player, new ArrayList<TornadoEntry>(entries));
        return 1;
    }

    private static int editRating(CommandContext<CommandSourceStack> context, String eventId, String ratingStr) {
        TornadoRating newRating;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            newRating = TornadoRating.valueOf(ratingStr.toUpperCase());
        }
        catch (IllegalArgumentException e2) {
            source.sendFailure((Component)Component.literal((String)("Invalid rating. Valid options: " + Arrays.stream(TornadoRating.values()).map(Enum::name).collect(Collectors.joining(", ")))));
            return 0;
        }
        TornadoDatabase db = TornadoDatabase.getOrCreate(source.getServer());
        Optional<TornadoEntry> entryOpt = db.getEntries().stream().filter(e -> e.eventId().equalsIgnoreCase(eventId)).findFirst();
        if (entryOpt.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)("Entry not found: " + eventId)));
            return 0;
        }
        TornadoEntry oldEntry = entryOpt.get();
        TornadoRating oldRating = oldEntry.rating();
        boolean success = db.updateEntryRating(oldEntry.entryId(), newRating);
        if (success) {
            source.sendSuccess(() -> Component.literal((String)String.format("Updated entry '%s' rating from %s to %s", eventId, oldRating.getDisplayName(), newRating.getDisplayName())), true);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)"Failed to update entry."));
        return 0;
    }

    private static int deleteEntry(CommandContext<CommandSourceStack> context, String eventId) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        TornadoDatabase db = TornadoDatabase.getOrCreate(source.getServer());
        Optional<TornadoEntry> entryOpt = db.getEntries().stream().filter(e -> e.eventId().equalsIgnoreCase(eventId)).findFirst();
        if (entryOpt.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)("Entry not found: " + eventId)));
            return 0;
        }
        TornadoEntry entry = entryOpt.get();
        boolean success = db.removeEntry(entry.entryId());
        if (success) {
            source.sendSuccess(() -> Component.literal((String)String.format("Deleted entry '%s' (%s) submitted by %s", eventId, entry.rating().getDisplayName(), entry.submitterName())), true);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)"Failed to delete entry."));
        return 0;
    }

    private static int deleteReview(CommandContext<CommandSourceStack> context, String eventId, String reviewerName) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        TornadoDatabase db = TornadoDatabase.getOrCreate(source.getServer());
        Optional<TornadoEntry> entryOpt = db.getEntries().stream().filter(e -> e.eventId().equalsIgnoreCase(eventId)).findFirst();
        if (entryOpt.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)("Entry not found: " + eventId)));
            return 0;
        }
        TornadoEntry entry = entryOpt.get();
        if (entry.reviews() == null || entry.reviews().isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"Entry has no reviews."));
            return 0;
        }
        Optional<SubmissionReview> reviewOpt = entry.reviews().stream().filter(r -> r.reviewerName().equalsIgnoreCase(reviewerName)).findFirst();
        if (reviewOpt.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)("Review by '" + reviewerName + "' not found.")));
            return 0;
        }
        boolean success = db.removeReviewFromEntry(entry.entryId(), reviewOpt.get().reviewId());
        if (success) {
            source.sendSuccess(() -> Component.literal((String)String.format("Deleted review by '%s' from entry '%s'", reviewerName, eventId)), true);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)"Failed to delete review."));
        return 0;
    }

    private static int clearAll(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        TornadoDatabase db = TornadoDatabase.getOrCreate(source.getServer());
        int count = db.getEntryCount();
        db.clearAll();
        source.sendSuccess(() -> Component.literal((String)String.format("Cleared all %d entries from the tornado database.", count)), true);
        return 1;
    }
}

