/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;

@EventBusSubscriber(modid="wxmcweatheraddon", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class WarningTooltipRenderer {
    public static final String WARNING_TOOLTIP_MARKER = "\u200b\u200c\u200b";
    private static final float TOOLTIP_SCALE = 0.65f;

    @SubscribeEvent
    public static void onRenderTooltipPre(RenderTooltipEvent.Pre event) {
        List components = event.getComponents();
        if (components.isEmpty()) {
            return;
        }
        ClientTooltipComponent first = (ClientTooltipComponent)components.get(0);
        String firstText = WarningTooltipRenderer.getComponentText(first);
        if (firstText != null && firstText.contains(WARNING_TOOLTIP_MARKER)) {
            event.setCanceled(true);
            WarningTooltipRenderer.renderScaledTooltip(event.getGraphics(), event.getFont(), components, event.getX(), event.getY());
        }
    }

    private static String getComponentText(ClientTooltipComponent component) {
        try {
            return component.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void renderScaledTooltip(GuiGraphics graphics, Font font, List<ClientTooltipComponent> components, int mouseX, int mouseY) {
        if (components.isEmpty()) {
            return;
        }
        PoseStack poseStack = graphics.pose();
        int tooltipWidth = 0;
        int tooltipHeight = 0;
        for (ClientTooltipComponent component : components) {
            tooltipWidth = Math.max(tooltipWidth, component.getWidth(font));
            tooltipHeight += component.getHeight();
        }
        int screenWidth = graphics.guiWidth();
        int screenHeight = graphics.guiHeight();
        int scaledWidth = (int)((float)(tooltipWidth += 8) * 0.65f);
        int scaledHeight = (int)((float)(tooltipHeight += 8) * 0.65f);
        int x = mouseX + 12;
        int y = mouseY - 12;
        if (x + scaledWidth > screenWidth) {
            x = mouseX - scaledWidth - 12;
        }
        if (y + scaledHeight > screenHeight) {
            y = screenHeight - scaledHeight;
        }
        if (y < 0) {
            y = 0;
        }
        if (x < 0) {
            x = 0;
        }
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, 400.0f);
        poseStack.scale(0.65f, 0.65f, 1.0f);
        int bgWidth = tooltipWidth;
        int bgHeight = tooltipHeight;
        int backgroundColor = -267386864;
        int borderColorStart = 0x505000FF;
        int borderColorEnd = 1344798847;
        graphics.fill(0, 0, bgWidth, bgHeight, backgroundColor);
        graphics.fill(0, 0, bgWidth, 1, borderColorStart);
        graphics.fill(0, bgHeight - 1, bgWidth, bgHeight, borderColorEnd);
        graphics.fill(0, 1, 1, bgHeight - 1, borderColorStart);
        graphics.fill(bgWidth - 1, 1, bgWidth, bgHeight - 1, borderColorEnd);
        int yOffset = 4;
        for (ClientTooltipComponent component : components) {
            component.renderText(font, 4, yOffset, poseStack.last().pose(), graphics.bufferSource());
            yOffset += component.getHeight();
        }
        graphics.flush();
        poseStack.popPose();
    }
}

