/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;

@EventBusSubscriber(modid="wxmcweatheraddon", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class WarningTooltipOverlay {
    private static final int BACKGROUND_COLOR = -267386864;
    private static final int BORDER_COLOR_TOP = 0x505000FF;
    private static final int BORDER_COLOR_BOTTOM = 1344798847;
    private static final int COLOR_STATEMENT = 16770229;
    private static final int COLOR_SVR = 16753920;
    private static final int COLOR_TORNADO = 0xFF0000;
    private static final float TEXT_SCALE = 0.65f;
    private static final int LINE_HEIGHT = 10;
    private static final int PADDING = 6;
    private static final long CACHE_EXPIRY_MS = 300000L;
    private static final Map<String, CachedWarning> warningCache = new HashMap<String, CachedWarning>();

    public static void setCurrentWarning(String warningId, String rawTemplate, int color) {
        WarningTooltipOverlay.setCurrentWarning(warningId, rawTemplate, color, WarningTooltipOverlay.getWarningTypeNameFromColor(color));
    }

    public static void setCurrentWarning(String warningId, String rawTemplate, int color, String warningTypeName) {
        if (warningId == null || warningId.isEmpty()) {
            return;
        }
        warningCache.put(warningId, new CachedWarning(warningId, rawTemplate, warningTypeName, color));
    }

    public static void updateWarningTemplate(String warningId, String newTemplate) {
        if (warningId == null || warningId.isEmpty()) {
            return;
        }
        CachedWarning warning = warningCache.get(warningId);
        if (warning != null && !warning.isExpired()) {
            warning.rawTemplate = newTemplate;
            warning.parsedLines = null;
        }
    }

    private static String getWarningTypeNameFromColor(int color) {
        if (color == 0xFF0000) {
            return "Tornado Warning";
        }
        if (color == 16753920) {
            return "Severe Thunderstorm Warning";
        }
        if (color == 16770229) {
            return "Special Weather Statement";
        }
        return "Weather Alert";
    }

    public static void checkExpiredWarnings() {
        for (CachedWarning warning : warningCache.values()) {
            if (!warning.isExpired() || warning.expiredNotified) continue;
            warning.expiredNotified = true;
        }
    }

    public static void clearAllWarnings() {
        warningCache.clear();
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        WarningTooltipOverlay.checkExpiredWarnings();
    }

    private static boolean isWarningColor(int color) {
        return color == 16770229 || color == 16753920 || color == 0xFF0000;
    }

    private static String getHoveredWarningId(Minecraft mc, double mouseX, double mouseY) {
        String value;
        if (mc.gui == null) {
            return null;
        }
        ChatComponent chat = mc.gui.getChat();
        if (chat == null) {
            return null;
        }
        Style style = chat.getClickedComponentStyleAt(mouseX, mouseY);
        if (style == null) {
            return null;
        }
        ClickEvent clickEvent = style.getClickEvent();
        if (clickEvent != null && clickEvent.getAction() == ClickEvent.Action.SUGGEST_COMMAND && (value = clickEvent.getValue()) != null && value.startsWith("wxmc:warning:")) {
            return value.substring("wxmc:warning:".length());
        }
        return null;
    }

    private static CachedWarning findWarningByColor(int color) {
        for (CachedWarning warning : warningCache.values()) {
            if (warning.color != color || warning.isExpired()) continue;
            return warning;
        }
        return null;
    }

    private static int getHoveredWarningColor(Minecraft mc, double mouseX, double mouseY) {
        if (mc.gui == null) {
            return -1;
        }
        ChatComponent chat = mc.gui.getChat();
        if (chat == null) {
            return -1;
        }
        Style style = chat.getClickedComponentStyleAt(mouseX, mouseY);
        if (style == null) {
            return -1;
        }
        TextColor textColor = style.getColor();
        if (textColor == null) {
            return -1;
        }
        int color = textColor.getValue();
        if (WarningTooltipOverlay.isWarningColor(color)) {
            return color;
        }
        return -1;
    }

    @SubscribeEvent
    public static void onScreenRender(ScreenEvent.Render.Post event) {
        if (!(event.getScreen() instanceof ChatScreen)) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        int mouseX = event.getMouseX();
        int mouseY = event.getMouseY();
        String hoveredWarningId = WarningTooltipOverlay.getHoveredWarningId(mc, mouseX, mouseY);
        CachedWarning warning = null;
        if (hoveredWarningId != null) {
            warning = warningCache.get(hoveredWarningId);
        }
        if (warning == null) {
            int hoveredColor = WarningTooltipOverlay.getHoveredWarningColor(mc, mouseX, mouseY);
            if (hoveredColor == -1) {
                return;
            }
            warning = WarningTooltipOverlay.findWarningByColor(hoveredColor);
        }
        if (warning == null) {
            return;
        }
        GuiGraphics graphics = event.getGuiGraphics();
        if (warning.isExpired()) {
            WarningTooltipOverlay.renderExpiredTooltip(graphics, mc, mouseX + 12, mouseY - 12, warning);
            return;
        }
        if (warning.parsedLines == null && warning.rawTemplate != null) {
            warning.parsedLines = WarningTooltipOverlay.parseTemplate(warning.rawTemplate);
        }
        if (warning.parsedLines == null || warning.parsedLines.isEmpty()) {
            return;
        }
        WarningTooltipOverlay.renderCustomTooltip(graphics, mc, mouseX + 12, mouseY - 12, warning);
    }

    private static void renderExpiredTooltip(GuiGraphics graphics, Minecraft mc, int x, int y, CachedWarning warning) {
        MutableComponent expiredText = Component.literal((String)(warning.warningTypeName + " - EXPIRED")).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x808080)));
        int textWidth = mc.font.width((FormattedText)expiredText);
        int contentWidth = (int)((float)textWidth * 0.65f);
        int contentHeight = 6;
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        if (x + contentWidth + 12 > screenWidth) {
            x = screenWidth - contentWidth - 12 - 5;
        }
        if (y + contentHeight + 12 > screenHeight) {
            y = screenHeight - contentHeight - 12 - 5;
        }
        if (x < 5) {
            x = 5;
        }
        if (y < 5) {
            y = 5;
        }
        int boxX = x;
        int boxY = y;
        int boxWidth = contentWidth + 12;
        int boxHeight = contentHeight + 12 + 4;
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 400.0f);
        WarningTooltipOverlay.renderTooltipBackground(graphics, boxX, boxY, boxWidth, boxHeight);
        graphics.fill(boxX + 1, boxY + 1, boxX + boxWidth - 1, boxY + 3, -8355712);
        int textX = boxX + 6;
        int textY = boxY + 6 + 4;
        poseStack.pushPose();
        poseStack.translate((float)textX, (float)textY, 0.0f);
        poseStack.scale(0.65f, 0.65f, 1.0f);
        graphics.drawString(mc.font, (Component)expiredText, 0, 0, 0xFFFFFF, true);
        poseStack.popPose();
        poseStack.popPose();
    }

    private static void renderCustomTooltip(GuiGraphics graphics, Minecraft mc, int x, int y, CachedWarning warning) {
        if (warning.parsedLines == null || warning.parsedLines.isEmpty()) {
            return;
        }
        int maxWidth = 0;
        for (Component line : warning.parsedLines) {
            int width = mc.font.width((FormattedText)line);
            maxWidth = Math.max(maxWidth, width);
        }
        int contentWidth = (int)((float)maxWidth * 0.65f);
        int contentHeight = (int)((float)(warning.parsedLines.size() * 10) * 0.65f);
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        if (x + contentWidth + 12 > screenWidth) {
            x = screenWidth - contentWidth - 12 - 5;
        }
        if (y + contentHeight + 12 > screenHeight) {
            y = screenHeight - contentHeight - 12 - 5;
        }
        if (x < 5) {
            x = 5;
        }
        if (y < 5) {
            y = 5;
        }
        int boxX = x;
        int boxY = y;
        int boxWidth = contentWidth + 12;
        int boxHeight = contentHeight + 12 + 4;
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 400.0f);
        WarningTooltipOverlay.renderTooltipBackground(graphics, boxX, boxY, boxWidth, boxHeight);
        graphics.fill(boxX + 1, boxY + 1, boxX + boxWidth - 1, boxY + 3, warning.color | 0xFF000000);
        int textX = boxX + 6;
        int textY = boxY + 6 + 4;
        poseStack.pushPose();
        poseStack.translate((float)textX, (float)textY, 0.0f);
        poseStack.scale(0.65f, 0.65f, 1.0f);
        int yOffset = 0;
        for (Component line : warning.parsedLines) {
            graphics.drawString(mc.font, line, 0, yOffset, 0xFFFFFF, true);
            yOffset += 10;
        }
        poseStack.popPose();
        poseStack.popPose();
    }

    private static void renderTooltipBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.fill(x + 1, y + 1, x + width - 1, y + height - 1, -267386864);
        graphics.fill(x + 1, y, x + width - 1, y + 1, -267386864);
        graphics.fill(x + 1, y + height - 1, x + width - 1, y + height, -267386864);
        graphics.fill(x, y + 1, x + 1, y + height - 1, -267386864);
        graphics.fill(x + width - 1, y + 1, x + width, y + height - 1, -267386864);
        graphics.fillGradient(x + 1, y + 2, x + 2, y + height - 2, 0x505000FF, 1344798847);
        graphics.fillGradient(x + width - 2, y + 2, x + width - 1, y + height - 2, 0x505000FF, 1344798847);
        graphics.fill(x + 2, y + 1, x + width - 2, y + 2, 0x505000FF);
        graphics.fill(x + 2, y + height - 2, x + width - 2, y + height - 1, 1344798847);
    }

    private static List<Component> parseTemplate(String template) {
        String[] rawLines;
        ArrayList<Component> lines = new ArrayList<Component>();
        for (String rawLine : rawLines = template.split("\n")) {
            lines.add(WarningTooltipOverlay.parseFormattedText(rawLine));
        }
        return lines;
    }

    private static Component parseFormattedText(String text) {
        MutableComponent result = Component.empty();
        Style currentStyle = Style.EMPTY;
        StringBuilder currentText = new StringBuilder();
        int i = 0;
        block26: while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '#' && i + 6 < text.length()) {
                if (currentText.length() > 0) {
                    result.append((Component)Component.literal((String)currentText.toString()).withStyle(currentStyle));
                    currentText = new StringBuilder();
                }
                String hexCode = text.substring(i + 1, i + 7);
                try {
                    int color = Integer.parseInt(hexCode, 16);
                    currentStyle = Style.EMPTY.withColor(TextColor.fromRgb((int)color));
                    i += 7;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (c == '&' && i + 1 < text.length()) {
                char code = text.charAt(i + 1);
                if (code == '&') {
                    currentText.append('&');
                    i += 2;
                    continue;
                }
                if (currentText.length() > 0) {
                    result.append((Component)Component.literal((String)currentText.toString()).withStyle(currentStyle));
                    currentText = new StringBuilder();
                }
                switch (code) {
                    case '0': {
                        currentStyle = currentStyle.withColor(ChatFormatting.BLACK);
                        break;
                    }
                    case '1': {
                        currentStyle = currentStyle.withColor(ChatFormatting.DARK_BLUE);
                        break;
                    }
                    case '2': {
                        currentStyle = currentStyle.withColor(ChatFormatting.DARK_GREEN);
                        break;
                    }
                    case '3': {
                        currentStyle = currentStyle.withColor(ChatFormatting.DARK_AQUA);
                        break;
                    }
                    case '4': {
                        currentStyle = currentStyle.withColor(ChatFormatting.DARK_RED);
                        break;
                    }
                    case '5': {
                        currentStyle = currentStyle.withColor(ChatFormatting.DARK_PURPLE);
                        break;
                    }
                    case '6': {
                        currentStyle = currentStyle.withColor(ChatFormatting.GOLD);
                        break;
                    }
                    case '7': {
                        currentStyle = currentStyle.withColor(ChatFormatting.GRAY);
                        break;
                    }
                    case '8': {
                        currentStyle = currentStyle.withColor(ChatFormatting.DARK_GRAY);
                        break;
                    }
                    case '9': {
                        currentStyle = currentStyle.withColor(ChatFormatting.BLUE);
                        break;
                    }
                    case 'a': {
                        currentStyle = currentStyle.withColor(ChatFormatting.GREEN);
                        break;
                    }
                    case 'b': {
                        currentStyle = currentStyle.withColor(ChatFormatting.AQUA);
                        break;
                    }
                    case 'c': {
                        currentStyle = currentStyle.withColor(ChatFormatting.RED);
                        break;
                    }
                    case 'd': {
                        currentStyle = currentStyle.withColor(ChatFormatting.LIGHT_PURPLE);
                        break;
                    }
                    case 'e': {
                        currentStyle = currentStyle.withColor(ChatFormatting.YELLOW);
                        break;
                    }
                    case 'f': {
                        currentStyle = currentStyle.withColor(ChatFormatting.WHITE);
                        break;
                    }
                    case 'l': {
                        currentStyle = currentStyle.withBold(Boolean.valueOf(true));
                        break;
                    }
                    case 'n': {
                        currentStyle = currentStyle.withUnderlined(Boolean.valueOf(true));
                        break;
                    }
                    case 'o': {
                        currentStyle = currentStyle.withItalic(Boolean.valueOf(true));
                        break;
                    }
                    case 'm': {
                        currentStyle = currentStyle.withStrikethrough(Boolean.valueOf(true));
                        break;
                    }
                    case 'k': {
                        currentStyle = currentStyle.withObfuscated(Boolean.valueOf(true));
                        break;
                    }
                    case 'r': {
                        currentStyle = Style.EMPTY;
                        break;
                    }
                    default: {
                        currentText.append(c);
                        ++i;
                        continue block26;
                    }
                }
                i += 2;
                continue;
            }
            currentText.append(c);
            ++i;
        }
        if (currentText.length() > 0) {
            result.append((Component)Component.literal((String)currentText.toString()).withStyle(currentStyle));
        }
        return result;
    }

    private static class CachedWarning {
        String rawTemplate;
        final String warningId;
        final String warningTypeName;
        final int color;
        final long cachedTime;
        List<Component> parsedLines = null;
        boolean expiredNotified = false;

        CachedWarning(String warningId, String rawTemplate, String warningTypeName, int color) {
            this.warningId = warningId;
            this.rawTemplate = rawTemplate;
            this.warningTypeName = warningTypeName;
            this.color = color;
            this.cachedTime = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.cachedTime > 300000L;
        }
    }
}

