/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class WarningDetailScreen
extends Screen {
    private static final float TEXT_SCALE = 0.65f;
    private static final int PADDING = 20;
    private static final int LINE_HEIGHT = 10;
    private final List<Component> warningLines;
    private final int warningColor;

    public WarningDetailScreen(Component warningContent, int color) {
        super((Component)Component.literal((String)"Weather Warning"));
        this.warningColor = color;
        this.warningLines = this.splitIntoLines(warningContent);
    }

    private List<Component> splitIntoLines(Component content) {
        String[] parts;
        ArrayList<Component> lines = new ArrayList<Component>();
        String text = content.getString();
        for (String part : parts = text.split("\n")) {
            lines.add((Component)Component.literal((String)part));
        }
        return lines;
    }

    protected void init() {
        int buttonWidth = 100;
        int buttonHeight = 20;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Close"), button -> this.onClose()).bounds((this.width - buttonWidth) / 2, this.height - 20 - buttonHeight, buttonWidth, buttonHeight).build());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        PoseStack poseStack = graphics.pose();
        int contentWidth = (int)((float)(this.width - 40) / 0.65f);
        int maxLineWidth = 0;
        int totalHeight = 0;
        for (Component line : this.warningLines) {
            int lineWidth = this.font.width((FormattedText)line);
            maxLineWidth = Math.max(maxLineWidth, lineWidth);
            totalHeight += 10;
        }
        int scaledMaxWidth = (int)((float)maxLineWidth * 0.65f);
        int scaledTotalHeight = (int)((float)totalHeight * 0.65f);
        int startX = (this.width - scaledMaxWidth) / 2;
        int startY = (this.height - scaledTotalHeight - 40) / 2;
        int panelPadding = 10;
        int bgX = startX - panelPadding;
        int bgY = startY - panelPadding;
        int bgWidth = scaledMaxWidth + panelPadding * 2;
        int bgHeight = scaledTotalHeight + panelPadding * 2;
        graphics.fill(bgX - 2, bgY - 2, bgX + bgWidth + 2, bgY + bgHeight + 2, this.warningColor | 0xFF000000);
        graphics.fill(bgX, bgY, bgX + bgWidth, bgY + bgHeight, -535818208);
        poseStack.pushPose();
        poseStack.translate((float)startX, (float)startY, 0.0f);
        poseStack.scale(0.65f, 0.65f, 1.0f);
        int yOffset = 0;
        for (Component line : this.warningLines) {
            graphics.drawString(this.font, line, 0, yOffset, 0xFFFFFF, false);
            yOffset += 10;
        }
        poseStack.popPose();
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1) {
            this.onClose();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

