/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.wxmc.weatheraddon.ClientConfig;
import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.block.WallRadarBlock;
import dev.wxmc.weatheraddon.block.WallRadarBlockEntity;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import dev.wxmc.weatheraddon.warnings.AlertPolygon;
import dev.wxmc.weatheraddon.warnings.AlertPolygonManager;
import dev.wxmc.weatheraddon.warnings.WarningConfig;
import dev.wxmc.weatheraddon.warnings.WarningLevel;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WallRadarRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    public static int RenderedRadars = 0;
    private static boolean initAttempted = false;
    private static boolean pmweatherAvailable = false;
    private static Class<?> stormClass = null;
    private static Class<?> vorticyClass = null;
    private static Method colorTablesGetReflectivity = null;
    private static Method colorTablesGetMixedReflectivity = null;
    private static Method colorTablesGetSnowReflectivity = null;
    private static Method colorTablesGetVelocity = null;
    private static Method colorTablesGetIR = null;
    private static Method colorTablesLerp = null;
    private static Field weatherHandlerField = null;
    private static Method cloudsGetCloudDensity = null;
    private static Method windEngineGetWind = null;
    private static Method thermodynamicSamplePoint = null;
    private static Field clientConfigRadarResolution = null;
    private static Field serverConfigStormSize = null;
    private static Field serverConfigRequireWSR88D = null;
    private static Method utilRotatePoint = null;
    private static Method utilMinimumDistance = null;
    private static Method utilNearestPoint = null;
    private static Method utilMulVec2 = null;
    private static Field pmweatherRandomField = null;
    private static Random pmweatherRandom = null;
    private static final Random FALLBACK_RANDOM = new Random();
    private static Class<?> wsr88dCoreClass = null;
    private static Method wsr88dIsComplete = null;
    private static boolean hasLoggedRender = false;
    private static boolean hasLoggedTransform = false;
    private static int debugTickCounter = 0;
    private static final float DISPLAY_OFFSET = 0.05f;
    private static final float BLOCK_THICKNESS = 0.125f;

    public WallRadarRenderer(BlockEntityRendererProvider.Context context) {
        WallRadarRenderer.initPMWeather();
    }

    private static synchronized void initPMWeather() {
        if (initAttempted) {
            return;
        }
        initAttempted = true;
        try {
            stormClass = Class.forName("dev.protomanly.pmweather.weather.Storm");
            vorticyClass = Class.forName("dev.protomanly.pmweather.weather.Vorticy");
            Class<?> colorTablesClass = Class.forName("dev.protomanly.pmweather.util.ColorTables");
            colorTablesGetReflectivity = colorTablesClass.getMethod("getReflectivity", Float.TYPE, Color.class);
            colorTablesGetMixedReflectivity = colorTablesClass.getMethod("getMixedReflectivity", Float.TYPE);
            colorTablesGetSnowReflectivity = colorTablesClass.getMethod("getSnowReflectivity", Float.TYPE);
            colorTablesGetVelocity = colorTablesClass.getMethod("getVelocity", Float.TYPE);
            colorTablesGetIR = colorTablesClass.getMethod("getIR", Float.TYPE);
            colorTablesLerp = colorTablesClass.getMethod("lerp", Float.TYPE, Color.class, Color.class);
            Class<?> clientEventsClass = Class.forName("dev.protomanly.pmweather.event.GameBusClientEvents");
            weatherHandlerField = clientEventsClass.getField("weatherHandler");
            Class<?> weatherHandlerClass = Class.forName("dev.protomanly.pmweather.weather.WeatherHandler");
            Class<?> cloudsClass = Class.forName("dev.protomanly.pmweather.weather.Clouds");
            cloudsGetCloudDensity = cloudsClass.getMethod("getCloudDensity", weatherHandlerClass, Vector2f.class, Float.TYPE);
            Class<?> windEngineClass = Class.forName("dev.protomanly.pmweather.weather.WindEngine");
            windEngineGetWind = windEngineClass.getMethod("getWind", Vec3.class, Level.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            Class<?> thermoClass = Class.forName("dev.protomanly.pmweather.weather.ThermodynamicEngine");
            for (Method m : thermoClass.getMethods()) {
                if (!m.getName().equals("samplePoint") || m.getParameterCount() != 5) continue;
                thermodynamicSamplePoint = m;
                break;
            }
            Class<?> clientConfigClass = Class.forName("dev.protomanly.pmweather.config.ClientConfig");
            clientConfigRadarResolution = clientConfigClass.getField("radarResolution");
            Class<?> serverConfigClass = Class.forName("dev.protomanly.pmweather.config.ServerConfig");
            serverConfigStormSize = serverConfigClass.getField("stormSize");
            serverConfigRequireWSR88D = serverConfigClass.getField("requireWSR88D");
            Class<?> utilClass = Class.forName("dev.protomanly.pmweather.util.Util");
            utilRotatePoint = utilClass.getMethod("rotatePoint", Vec3.class, Vec3.class, Double.TYPE);
            utilMinimumDistance = utilClass.getMethod("minimumDistance", Vec2.class, Vec2.class, Vec2.class);
            utilNearestPoint = utilClass.getMethod("nearestPoint", Vec2.class, Vec2.class, Vec2.class);
            utilMulVec2 = utilClass.getMethod("mulVec2", Vec2.class, Float.TYPE);
            Class<?> pmweatherClass = Class.forName("dev.protomanly.pmweather.PMWeather");
            pmweatherRandomField = pmweatherClass.getField("RANDOM");
            pmweatherRandom = (Random)pmweatherRandomField.get(null);
            try {
                wsr88dCoreClass = Class.forName("dev.protomanly.pmweather.multiblock.wsr88d.WSR88DCore");
                wsr88dIsComplete = wsr88dCoreClass.getMethod("isComplete", BlockState.class);
            }
            catch (Exception e) {
                wsr88dCoreClass = null;
                wsr88dIsComplete = null;
            }
            pmweatherAvailable = true;
            WXMCWeatherAddon.LOGGER.info("WallRadarRenderer: PMWeather integration initialized successfully");
            WXMCWeatherAddon.LOGGER.info("WallRadarRenderer: stormClass={}, colorTablesGetReflectivity={}", (Object)(stormClass != null ? 1 : 0), (Object)(colorTablesGetReflectivity != null ? 1 : 0));
        }
        catch (Exception e) {
            WXMCWeatherAddon.LOGGER.error("WallRadarRenderer: Failed to initialize PMWeather integration", (Throwable)e);
            pmweatherAvailable = false;
        }
    }

    private static Random getRandom() {
        return pmweatherRandom != null ? pmweatherRandom : FALLBACK_RANDOM;
    }

    private boolean checkCanRender(BlockPos pos, Level level) {
        if (!pmweatherAvailable || serverConfigRequireWSR88D == null) {
            return true;
        }
        try {
            boolean requireWSR88D = serverConfigRequireWSR88D.getBoolean(null);
            if (!requireWSR88D) {
                return true;
            }
            if (wsr88dCoreClass == null || wsr88dIsComplete == null) {
                return true;
            }
            int searchrange = 64;
            for (int x = -searchrange; x <= searchrange; ++x) {
                for (int y = -searchrange; y <= searchrange; ++y) {
                    for (int z = -searchrange * 2; z <= searchrange * 2; ++z) {
                        boolean isComplete;
                        BlockState state;
                        BlockPos checkPos = pos.offset(x, y, z);
                        if (!level.isLoaded(checkPos) || !wsr88dCoreClass.isInstance((state = level.getBlockState(checkPos)).getBlock()) || !(isComplete = ((Boolean)wsr88dIsComplete.invoke((Object)state.getBlock(), state)).booleanValue())) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static float FBM(SimplexNoise noise, Vec3 pos, int octaves, float lacunarity, float gain, float amplitude) {
        double y = 0.0;
        for (int i = 0; i < Math.max(octaves, 1); ++i) {
            y += (double)amplitude * noise.getValue(pos.x, pos.y, pos.z);
            pos = pos.multiply((double)lacunarity, (double)lacunarity, (double)lacunarity);
            amplitude *= gain;
        }
        return (float)y;
    }

    /*
     * WARNING - void declaration
     */
    public void render(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLightIn, int combinedOverlayIn) {
        if (!(blockEntity instanceof WallRadarBlockEntity)) {
            return;
        }
        WallRadarBlockEntity radarBlockEntity = (WallRadarBlockEntity)((Object)blockEntity);
        if (!hasLoggedRender) {
            hasLoggedRender = true;
            WXMCDebugLogger.debug("WallRadarRenderer.render() called - pmweatherAvailable={}", pmweatherAvailable);
        }
        if (Minecraft.getInstance().player == null) {
            return;
        }
        if (Minecraft.getInstance().player.position().distanceTo(blockEntity.getBlockPos().getCenter()) > 20.0) {
            return;
        }
        if (RenderedRadars > 2) {
            return;
        }
        ++RenderedRadars;
        Direction facing = (Direction)radarBlockEntity.getBlockState().getValue((Property)WallRadarBlock.FACING);
        BlockPos pos = radarBlockEntity.getBlockPos();
        if (++debugTickCounter % 200 == 1) {
            LocalPlayer player = Minecraft.getInstance().player;
            WXMCDebugLogger.debug("=== WALL RADAR DEBUG ===");
            WXMCDebugLogger.debug("Block pos: {}", pos);
            WXMCDebugLogger.debug("Facing direction: {} (screen faces this way)", facing);
            WXMCDebugLogger.debug("Player pos: ({}, {}, {})", String.format("%.1f", player.getX()), String.format("%.1f", player.getY()), String.format("%.1f", player.getZ()));
            WXMCDebugLogger.debug("Player relative to radar: X={}, Z={}", player.getX() > (double)pos.getX() + 0.5 ? "EAST of radar" : "WEST of radar", player.getZ() > (double)pos.getZ() + 0.5 ? "SOUTH of radar" : "NORTH of radar");
            WXMCDebugLogger.debug("--- Expected radar orientation ---");
            WXMCDebugLogger.debug("Radar NORTH (-Z world) should appear at: TOP of display");
            WXMCDebugLogger.debug("Radar SOUTH (+Z world) should appear at: BOTTOM of display");
            switch (facing) {
                case NORTH: {
                    WXMCDebugLogger.debug("NORTH facing: Player should stand NORTH (low Z) looking SOUTH");
                    WXMCDebugLogger.debug("  EAST (+X world) appears at: +X on display (player's LEFT when looking south)");
                    WXMCDebugLogger.debug("  WEST (-X world) appears at: -X on display (player's RIGHT when looking south)");
                    break;
                }
                case WEST: {
                    WXMCDebugLogger.debug("WEST facing: Player should stand WEST (low X) looking EAST");
                    WXMCDebugLogger.debug("  EAST (+X world) should appear at: +Z on display (player's RIGHT when looking east)");
                    WXMCDebugLogger.debug("  WEST (-X world) should appear at: -Z on display (player's LEFT when looking east)");
                    break;
                }
                default: {
                    WXMCDebugLogger.debug("Other facing: {}", facing);
                }
            }
            WXMCDebugLogger.debug("========================");
        }
        int resolution = 50;
        if (pmweatherAvailable && clientConfigRadarResolution != null) {
            try {
                resolution = clientConfigRadarResolution.getInt(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        float sizeRenderDiameter = 3.0f;
        float simSize = 2048.0f;
        if (radarBlockEntity.hasRangeUpgrade) {
            simSize *= 4.0f;
        }
        Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
        matrix4fStack.pushMatrix();
        matrix4fStack.mul((Matrix4fc)poseStack.last().pose());
        this.applyWallTransformation(matrix4fStack, facing);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.defaultBlendFunc();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        ArrayList<Object> storms = new ArrayList<Object>(radarBlockEntity.storms);
        boolean update = false;
        if (radarBlockEntity.lastUpdate < radarBlockEntity.tickCount) {
            radarBlockEntity.lastUpdate = radarBlockEntity.tickCount + 60;
            update = true;
        }
        boolean canRender = true;
        if (update) {
            canRender = this.checkCanRender(pos, blockEntity.getLevel());
        }
        Object weatherHandler = null;
        if (pmweatherAvailable && weatherHandlerField != null) {
            try {
                weatherHandler = weatherHandlerField.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        double configStormSize = 3200.0;
        if (pmweatherAvailable && serverConfigStormSize != null) {
            try {
                configStormSize = serverConfigStormSize.getDouble(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        float size = sizeRenderDiameter / (float)resolution;
        for (int x = -resolution; x <= resolution; ++x) {
            for (int z = -resolution; z <= resolution; ++z) {
                void var40_53;
                Holder<Biome> biome;
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                float a = 0.0f;
                long id = (long)(x + resolution + 1) + (long)(z + resolution + 1) * ((long)resolution * 2L + 1L);
                float dbz = radarBlockEntity.reflectivityMap.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
                float temp = radarBlockEntity.temperatureMap.getOrDefault(id, Float.valueOf(15.0f)).floatValue();
                float vel = radarBlockEntity.velocityMap.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
                Color dbg = radarBlockEntity.debugMap.getOrDefault(id, new Color(0, 0, 0));
                Vector3f pixelPos = new Vector3f((float)x, 0.0f, (float)z).mul(1.0f / (float)resolution).mul(sizeRenderDiameter / 2.0f);
                Vec3 worldPos = new Vec3((double)x, 0.0, (double)z).multiply((double)(1.0f / (float)resolution), 0.0, (double)(1.0f / (float)resolution)).multiply((double)simSize, 0.0, (double)simSize).add(pos.getCenter());
                if (update) {
                    float v;
                    float clouds = 0.0f;
                    if (pmweatherAvailable && cloudsGetCloudDensity != null && weatherHandler != null) {
                        try {
                            clouds = ((Float)cloudsGetCloudDensity.invoke(null, weatherHandler, new Vector2f((float)worldPos.x, (float)worldPos.z), Float.valueOf(0.0f))).floatValue();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    dbz = 0.0f;
                    temp = 0.0f;
                    Vec2 f = new Vec2((float)x, (float)z).normalized();
                    if (pmweatherAvailable && windEngineGetWind != null && blockEntity.getLevel() != null) {
                        try {
                            Vec3 wind = (Vec3)windEngineGetWind.invoke(null, new Vec3(worldPos.x, (double)(blockEntity.getLevel().getMaxBuildHeight() + 1), worldPos.z), blockEntity.getLevel(), false, false, false);
                            Vec2 vec2 = new Vec2((float)wind.x, (float)wind.z);
                            vel = f.dot(vec2);
                        }
                        catch (Exception e) {
                            vel = 0.0f;
                        }
                    }
                    if (pmweatherAvailable && stormClass != null) {
                        for (Object e : storms) {
                            try {
                                float localDBZ = this.processStorm(e, radarBlockEntity, worldPos, configStormSize);
                                dbz = Math.max(dbz, localDBZ);
                            }
                            catch (Exception localDBZ) {}
                        }
                    }
                    if ((v = Math.max(clouds - 0.15f, 0.0f) * 4.0f) > 0.4f) {
                        float f2 = (v - 0.4f) / 2.0f;
                        v -= f2;
                    }
                    dbz = Math.max(dbz, v);
                    Random random = WallRadarRenderer.getRandom();
                    dbz += (random.nextFloat() - 0.5f) * 5.0f / 60.0f;
                    vel += (random.nextFloat() - 0.5f) * 3.0f;
                    if (dbz > 1.0f) {
                        dbz = (dbz - 1.0f) / 3.0f + 1.0f;
                    }
                    if (!canRender) {
                        dbz = random.nextFloat() * 1.2f;
                        vel = (random.nextFloat() - 0.5f) * 300.0f;
                        temp = 15.0f;
                    } else if (pmweatherAvailable && thermodynamicSamplePoint != null && weatherHandler != null && blockEntity.getLevel() != null) {
                        try {
                            Object dataPoint = thermodynamicSamplePoint.invoke(null, weatherHandler, worldPos, blockEntity.getLevel(), null, 0);
                            if (dataPoint != null) {
                                Method tempMethod = dataPoint.getClass().getMethod("temperature", new Class[0]);
                                temp = ((Float)tempMethod.invoke(dataPoint, new Object[0])).floatValue();
                            }
                        }
                        catch (Exception e) {
                            temp = 15.0f;
                        }
                    }
                    radarBlockEntity.reflectivityMap.put(id, Float.valueOf(dbz));
                    radarBlockEntity.temperatureMap.put(id, Float.valueOf(temp));
                    radarBlockEntity.velocityMap.put(id, Float.valueOf(vel));
                }
                float rdbz = dbz * 60.0f;
                Color startColor = radarBlockEntity.terrainMap.getOrDefault(id, new Color(0, 0, 0));
                if (radarBlockEntity.init && update && (biome = radarBlockEntity.getNearestBiome(new BlockPos((int)worldPos.x, (int)worldPos.y, (int)worldPos.z))) != null) {
                    String string = biome.getRegisteredName().toLowerCase();
                    startColor = string.contains("ocean") || string.contains("river") ? new Color(((Biome)biome.value()).getWaterColor()) : (string.contains("beach") || string.contains("desert") ? new Color(227, 198, 150) : (string.contains("badlands") ? new Color(214, 111, 42) : new Color(((Biome)biome.value()).getGrassColor(worldPos.x, worldPos.z))));
                    if (pmweatherAvailable && colorTablesLerp != null) {
                        try {
                            startColor = (Color)colorTablesLerp.invoke(null, Float.valueOf(0.5f), startColor, new Color(0, 0, 0));
                        }
                        catch (Exception e) {
                            startColor = new Color(startColor.getRed() / 2, startColor.getGreen() / 2, startColor.getBlue() / 2);
                        }
                    } else {
                        startColor = new Color(startColor.getRed() / 2, startColor.getGreen() / 2, startColor.getBlue() / 2);
                    }
                    radarBlockEntity.terrainMap.put(id, startColor);
                }
                WallRadarBlock.Mode mode = (WallRadarBlock.Mode)((Object)radarBlockEntity.getBlockState().getValue(WallRadarBlock.RADAR_MODE));
                Color color = startColor;
                if (pmweatherAvailable && colorTablesGetReflectivity != null) {
                    try {
                        Color color2 = (Color)colorTablesGetReflectivity.invoke(null, Float.valueOf(rdbz), startColor);
                        if (mode == WallRadarBlock.Mode.REFLECTIVITY && rdbz > 5.0f && !radarBlockEntity.hasRangeUpgrade) {
                            if (temp < 3.0f && temp > -1.0f && colorTablesGetMixedReflectivity != null) {
                                Color color3 = (Color)colorTablesGetMixedReflectivity.invoke(null, Float.valueOf(rdbz));
                            } else if (temp <= -1.0f && colorTablesGetSnowReflectivity != null) {
                                Color color4 = (Color)colorTablesGetSnowReflectivity.invoke(null, Float.valueOf(rdbz));
                            }
                        }
                        if (mode == WallRadarBlock.Mode.VELOCITY && colorTablesGetVelocity != null && colorTablesLerp != null) {
                            Color color5 = new Color(0, 0, 0);
                            float velScaled = vel / 1.75f;
                            float lerpFactor = Mth.clamp((float)(Math.max(rdbz, (Mth.abs((float)velScaled) - 18.0f) / 0.65f) / 12.0f), (float)0.0f, (float)1.0f);
                            Color velocityColor = (Color)colorTablesGetVelocity.invoke(null, Float.valueOf(velScaled));
                            Color color6 = (Color)colorTablesLerp.invoke(null, Float.valueOf(lerpFactor), color5, velocityColor);
                        }
                        if (mode == WallRadarBlock.Mode.IR && colorTablesGetIR != null) {
                            float ir = rdbz * 10.0f;
                            if (rdbz > 10.0f) {
                                ir = 100.0f + (rdbz - 10.0f) * 2.5f;
                            }
                            if (rdbz > 50.0f) {
                                ir += (rdbz - 50.0f) * 5.0f;
                            }
                            Color color7 = (Color)colorTablesGetIR.invoke(null, Float.valueOf(ir));
                        }
                    }
                    catch (Exception e) {
                        Color color8 = this.getFallbackColor(rdbz, startColor);
                    }
                } else {
                    Color color9 = this.getFallbackColor(rdbz, startColor);
                }
                r = (float)var40_53.getRed() / 255.0f;
                g = (float)var40_53.getGreen() / 255.0f;
                b = (float)var40_53.getBlue() / 255.0f;
                a = (float)var40_53.getAlpha() / 255.0f * 0.75f + 0.25f;
                Vector3f topLeft = new Vector3f(-1.0f, 0.0f, -1.0f).mul(size / 4.0f).add((Vector3fc)pixelPos);
                Vector3f bottomLeft = new Vector3f(-1.0f, 0.0f, 1.0f).mul(size / 4.0f).add((Vector3fc)pixelPos);
                Vector3f bottomRight = new Vector3f(1.0f, 0.0f, 1.0f).mul(size / 4.0f).add((Vector3fc)pixelPos);
                Vector3f topRight = new Vector3f(1.0f, 0.0f, -1.0f).mul(size / 4.0f).add((Vector3fc)pixelPos);
                bufferBuilder.addVertex(topLeft).setColor(r, g, b, a).addVertex(bottomLeft).setColor(r, g, b, a).addVertex(bottomRight).setColor(r, g, b, a).addVertex(topRight).setColor(r, g, b, a);
            }
        }
        float mr = 1.0f;
        float mg = 0.0f;
        float mb = 0.0f;
        float ma = 1.0f;
        Vector3f tl = new Vector3f(-1.0f, 0.0f, -1.0f).mul(0.015f).add(0.0f, 0.01f, 0.0f);
        Vector3f bl = new Vector3f(-1.0f, 0.0f, 1.0f).mul(0.015f).add(0.0f, 0.01f, 0.0f);
        Vector3f br = new Vector3f(1.0f, 0.0f, 1.0f).mul(0.015f).add(0.0f, 0.01f, 0.0f);
        Vector3f tr = new Vector3f(1.0f, 0.0f, -1.0f).mul(0.015f).add(0.0f, 0.01f, 0.0f);
        bufferBuilder.addVertex(tl).setColor(mr, mg, mb, ma).addVertex(bl).setColor(mr, mg, mb, ma).addVertex(br).setColor(mr, mg, mb, ma).addVertex(tr).setColor(mr, mg, mb, ma);
        MeshData meshData = bufferBuilder.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
        if (((Boolean)WarningConfig.SHOW_RADAR_POLYGONS.get()).booleanValue()) {
            this.renderWarningPolygons(pos, sizeRenderDiameter);
        }
        matrix4fStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        this.renderDirectionLabels(poseStack, multiBufferSource, sizeRenderDiameter, facing, combinedLightIn);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    }

    private void renderWarningPolygons(BlockPos radarPos, float renderDiameter) {
        ArrayList<AlertPolygon> polys;
        Collection<AlertPolygon> originalPolys = AlertPolygonManager.getPolygonsAt(radarPos);
        if (originalPolys.isEmpty()) {
            return;
        }
        try {
            polys = new ArrayList<AlertPolygon>(originalPolys);
        }
        catch (Exception e) {
            return;
        }
        if (polys.isEmpty()) {
            return;
        }
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableCull();
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder buf = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        float lineWidth = ClientConfig.getPolygonLineWidth();
        float polygonAlpha = ClientConfig.getPolygonOpacity();
        for (AlertPolygon poly : polys) {
            try {
                WarningLevel level = poly.getWarningLevel();
                int color = this.getPolygonColor(level);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                float a = polygonAlpha;
                float centerX = ((float)poly.centerX - 0.5f) * renderDiameter;
                float centerZ = ((float)poly.centerZ - 0.5f) * renderDiameter;
                float halfW = Math.max(poly.halfWidth * renderDiameter, 0.02f);
                float halfH = Math.max(poly.halfHeight * renderDiameter, 0.02f);
                double radians = Math.toRadians(poly.rotationDeg);
                float cos = (float)Math.cos(radians);
                float sin = (float)Math.sin(radians);
                float y = 0.01f;
                Vector3f[] corners = new Vector3f[4];
                if (poly.stormType == 0) {
                    float trapezoidalFactor = 0.2f;
                    float narrowHW = halfW * (1.0f - trapezoidalFactor);
                    float wideHW = halfW * (1.0f + trapezoidalFactor);
                    corners[0] = new Vector3f(-narrowHW * cos - halfH * sin + centerX, y, -narrowHW * sin + halfH * cos + centerZ);
                    corners[1] = new Vector3f(narrowHW * cos - halfH * sin + centerX, y, narrowHW * sin + halfH * cos + centerZ);
                    corners[2] = new Vector3f(wideHW * cos - -halfH * sin + centerX, y, wideHW * sin + -halfH * cos + centerZ);
                    corners[3] = new Vector3f(-wideHW * cos - -halfH * sin + centerX, y, -wideHW * sin + -halfH * cos + centerZ);
                } else {
                    float correctedRotation = poly.rotationDeg + 90.0f;
                    double radians2 = Math.toRadians(correctedRotation);
                    float cos2 = (float)Math.cos(radians2);
                    float sin2 = (float)Math.sin(radians2);
                    corners[0] = new Vector3f(-halfW * cos2 - -halfH * sin2 + centerX, y, -halfW * sin2 + -halfH * cos2 + centerZ);
                    corners[1] = new Vector3f(halfW * cos2 - -halfH * sin2 + centerX, y, halfW * sin2 + -halfH * cos2 + centerZ);
                    corners[2] = new Vector3f(halfW * cos2 - halfH * sin2 + centerX, y, halfW * sin2 + halfH * cos2 + centerZ);
                    corners[3] = new Vector3f(-halfW * cos2 - halfH * sin2 + centerX, y, -halfW * sin2 + halfH * cos2 + centerZ);
                }
                for (int i = 0; i < 4; ++i) {
                    Vector3f start = corners[i];
                    Vector3f end = corners[(i + 1) % 4];
                    float dx = end.x - start.x;
                    float dz = end.z - start.z;
                    float length = (float)Math.sqrt(dx * dx + dz * dz);
                    if (length < 1.0E-5f) continue;
                    float invLength = 1.0f / length;
                    float dirX = dx * invLength;
                    float dirZ = dz * invLength;
                    float perpX = -dirZ * lineWidth;
                    float perpZ = dirX * lineWidth;
                    float extension = lineWidth * 0.5f;
                    Vector3f extStart = new Vector3f(start.x - dirX * extension, start.y, start.z - dirZ * extension);
                    Vector3f extEnd = new Vector3f(end.x + dirX * extension, end.y, end.z + dirZ * extension);
                    Vector3f topLeft = new Vector3f(extStart.x + perpX, extStart.y, extStart.z + perpZ);
                    Vector3f bottomLeft = new Vector3f(extStart.x - perpX, extStart.y, extStart.z - perpZ);
                    Vector3f bottomRight = new Vector3f(extEnd.x - perpX, extEnd.y, extEnd.z - perpZ);
                    Vector3f topRight = new Vector3f(extEnd.x + perpX, extEnd.y, extEnd.z + perpZ);
                    buf.addVertex(topLeft.x, topLeft.y, topLeft.z).setColor(r, g, b, a);
                    buf.addVertex(topRight.x, topRight.y, topRight.z).setColor(r, g, b, a);
                    buf.addVertex(bottomRight.x, bottomRight.y, bottomRight.z).setColor(r, g, b, a);
                    buf.addVertex(bottomLeft.x, bottomLeft.y, bottomLeft.z).setColor(r, g, b, a);
                    buf.addVertex(topLeft.x, topLeft.y, topLeft.z).setColor(r, g, b, a);
                    buf.addVertex(bottomLeft.x, bottomLeft.y, bottomLeft.z).setColor(r, g, b, a);
                    buf.addVertex(bottomRight.x, bottomRight.y, bottomRight.z).setColor(r, g, b, a);
                    buf.addVertex(topRight.x, topRight.y, topRight.z).setColor(r, g, b, a);
                }
            }
            catch (Exception exception) {
            }
        }
        MeshData polyMesh = buf.build();
        if (polyMesh != null) {
            BufferUploader.drawWithShader((MeshData)polyMesh);
        }
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
    }

    private int getPolygonColor(WarningLevel level) {
        return switch (level) {
            case WarningLevel.STATEMENT -> ClientConfig.getStatementColor();
            case WarningLevel.SVR_WARNING -> ClientConfig.getSvrWarningColor();
            case WarningLevel.SVR_PDS -> ClientConfig.getSvrPdsColor();
            case WarningLevel.SVR_DESTRUCTIVE -> ClientConfig.getSvrDestructiveColor();
            case WarningLevel.TOR_INDICATED -> ClientConfig.getTorIndicatedColor();
            case WarningLevel.TOR_CONFIRMED -> ClientConfig.getTorConfirmedColor();
            case WarningLevel.TOR_PDS -> ClientConfig.getTorPdsColor();
            case WarningLevel.TOR_EMERGENCY -> ClientConfig.getTorEmergencyColor();
            default -> level.getColor();
        };
    }

    private void renderDirectionLabels(PoseStack poseStack, MultiBufferSource bufferSource, float renderDiameter, Direction facing, int light) {
        String leftLabel;
        String bottomLabel;
        String topLabel;
        Font font = Minecraft.getInstance().font;
        if (font == null || bufferSource == null) {
            return;
        }
        poseStack.pushPose();
        this.applyWallTransformationToPoseStack(poseStack, facing);
        float labelDist = 1.35f;
        float frontOffset = 0.05f;
        float textScale = 0.025f;
        int textColor = -1;
        String rightLabel = switch (facing) {
            case Direction.NORTH -> {
                topLabel = "N";
                bottomLabel = "S";
                leftLabel = "W";
                yield "E";
            }
            case Direction.SOUTH -> {
                topLabel = "N";
                bottomLabel = "S";
                leftLabel = "W";
                yield "E";
            }
            case Direction.EAST -> {
                topLabel = "W";
                bottomLabel = "E";
                leftLabel = "N";
                yield "S";
            }
            case Direction.WEST -> {
                topLabel = "E";
                bottomLabel = "W";
                leftLabel = "S";
                yield "N";
            }
            default -> {
                topLabel = "N";
                bottomLabel = "S";
                leftLabel = "W";
                yield "E";
            }
        };
        if (facing == Direction.SOUTH) {
            this.renderLabelInRadarSpace(poseStack, bufferSource, font, topLabel, 0.0f, frontOffset, -labelDist, textScale, textColor, facing);
            this.renderLabelInRadarSpace(poseStack, bufferSource, font, bottomLabel, 0.0f, frontOffset, labelDist, textScale, textColor, facing);
            this.renderLabelInRadarSpace(poseStack, bufferSource, font, leftLabel, -labelDist, frontOffset, 0.0f, textScale, textColor, facing);
            this.renderLabelInRadarSpace(poseStack, bufferSource, font, rightLabel, labelDist, frontOffset, 0.0f, textScale, textColor, facing);
        } else if (facing == Direction.NORTH) {
            this.renderLabelInRadarSpace(poseStack, bufferSource, font, topLabel, 0.0f, frontOffset, -labelDist, textScale, textColor, facing);
            this.renderLabelInRadarSpace(poseStack, bufferSource, font, bottomLabel, 0.0f, frontOffset, labelDist, textScale, textColor, facing);
            this.renderLabelInRadarSpace(poseStack, bufferSource, font, leftLabel, -labelDist, frontOffset, 0.0f, textScale, textColor, facing);
            this.renderLabelInRadarSpace(poseStack, bufferSource, font, rightLabel, labelDist, frontOffset, 0.0f, textScale, textColor, facing);
        } else if (facing == Direction.EAST) {
            this.renderLabelInRadarSpace(poseStack, bufferSource, font, topLabel, -labelDist, frontOffset, 0.0f, textScale, textColor, facing);
            this.renderLabelInRadarSpace(poseStack, bufferSource, font, bottomLabel, labelDist, frontOffset, 0.0f, textScale, textColor, facing);
            this.renderLabelInRadarSpace(poseStack, bufferSource, font, leftLabel, 0.0f, frontOffset, -labelDist, textScale, textColor, facing);
            this.renderLabelInRadarSpace(poseStack, bufferSource, font, rightLabel, 0.0f, frontOffset, labelDist, textScale, textColor, facing);
        } else if (facing == Direction.WEST) {
            this.renderLabelInRadarSpace(poseStack, bufferSource, font, topLabel, labelDist, frontOffset, 0.0f, textScale, textColor, facing);
            this.renderLabelInRadarSpace(poseStack, bufferSource, font, bottomLabel, -labelDist, frontOffset, 0.0f, textScale, textColor, facing);
            this.renderLabelInRadarSpace(poseStack, bufferSource, font, leftLabel, 0.0f, frontOffset, labelDist, textScale, textColor, facing);
            this.renderLabelInRadarSpace(poseStack, bufferSource, font, rightLabel, 0.0f, frontOffset, -labelDist, textScale, textColor, facing);
        }
        poseStack.popPose();
    }

    private void applyWallTransformationToPoseStack(PoseStack poseStack, Direction facing) {
        switch (facing) {
            case NORTH: {
                float displayZ = 0.825f;
                poseStack.translate(0.5f, 0.5f, displayZ);
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                break;
            }
            case SOUTH: {
                float displayZ = 0.175f;
                poseStack.translate(0.5f, 0.5f, displayZ);
                poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                float displayX = 0.175f;
                poseStack.translate(displayX, 0.5f, 0.5f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                break;
            }
            case WEST: {
                float displayX = 0.825f;
                poseStack.translate(displayX, 0.5f, 0.5f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            }
        }
    }

    private void renderLabelInRadarSpace(PoseStack poseStack, MultiBufferSource bufferSource, Font font, String text, float x, float y, float z, float scale, int color, Direction facing) {
        poseStack.pushPose();
        poseStack.translate(x, y, z);
        switch (facing) {
            case SOUTH: {
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                break;
            }
            case NORTH: {
                poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            }
        }
        poseStack.scale(scale, -scale, scale);
        int textWidth = font.width(text);
        float textX = (float)(-textWidth) / 2.0f;
        Objects.requireNonNull(font);
        float textY = (float)(-9) / 2.0f;
        font.drawInBatch((Component)Component.literal((String)text), textX, textY, color, true, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.popPose();
    }

    private float processStorm(Object storm, WallRadarBlockEntity radarBlockEntity, Vec3 worldPos, double configStormSize) throws Exception {
        Field visualOnlyField = stormClass.getField("visualOnly");
        if (visualOnlyField.getBoolean(storm)) {
            return 0.0f;
        }
        Field positionField = stormClass.getField("position");
        Vec3 stormPos = (Vec3)positionField.get(storm);
        Field stormTypeField = stormClass.getField("stormType");
        int stormType = stormTypeField.getInt(storm);
        Field stageField = stormClass.getField("stage");
        int stage = stageField.getInt(storm);
        Field energyField = stormClass.getField("energy");
        int energy = energyField.getInt(storm);
        Field windspeedField = stormClass.getField("windspeed");
        int windspeed = windspeedField.getInt(storm);
        Field tickCountField = stormClass.getField("tickCount");
        int stormTickCount = tickCountField.getInt(storm);
        Field velocityField = stormClass.getField("velocity");
        Vec3 stormVelocity = (Vec3)velocityField.get(storm);
        double stormSize = configStormSize * 2.0;
        if (stormType == 0) {
            stormSize *= 1.5;
        }
        double scale = stormSize / 1200.0;
        if (stormType == 2) {
            Field maxWidthField = stormClass.getField("maxWidth");
            int maxWidth = maxWidthField.getInt(storm);
            scale = (float)maxWidth / 3000.0f;
            scale *= 0.5;
        }
        double shapeNoise = radarBlockEntity.noise.getValue((double)((float)radarBlockEntity.tickCount / 8000.0f), worldPos.x / (750.0 * scale), worldPos.z / (750.0 * scale));
        float fineShapeNoise = WallRadarRenderer.FBM(radarBlockEntity.noise, new Vec3((double)((float)radarBlockEntity.tickCount / 8000.0f), worldPos.x / (500.0 * scale), worldPos.z / (500.0 * scale)), 10, 2.0f, 0.75f, 1.0f);
        double shapeNoise2 = radarBlockEntity.noise.getValue((double)((float)radarBlockEntity.tickCount / 8000.0f), worldPos.z / (750.0 * scale), worldPos.x / (750.0 * scale));
        double shapeNoise3 = radarBlockEntity.noise.getValue((double)((float)radarBlockEntity.tickCount / 16000.0f), worldPos.x / (4000.0 * scale), worldPos.z / (4000.0 * scale));
        double shapeNoise4 = radarBlockEntity.noise.getValue((double)((float)radarBlockEntity.tickCount / 8000.0f), worldPos.z / (250.0 * scale), worldPos.x / (250.0 * scale));
        shapeNoise = shapeNoise * 0.5 + 0.5;
        shapeNoise2 = shapeNoise2 * 0.5 + 0.5;
        shapeNoise4 = shapeNoise4 * 0.5 + 0.5;
        float localDBZ = 0.0f;
        float smoothStage = (float)stage + (float)energy / 100.0f;
        if (stormType == 2) {
            localDBZ = this.processType2Storm(storm, radarBlockEntity, worldPos, stormPos, scale, shapeNoise, shapeNoise2, shapeNoise3, fineShapeNoise, windspeed, stormTickCount);
        } else if (stormType == 1) {
            localDBZ = this.processType1Storm(storm, radarBlockEntity, worldPos, stormPos, stormVelocity, scale, stormSize, shapeNoise, shapeNoise2, smoothStage, stage, energy);
        } else if (stormType == 0) {
            localDBZ = this.processType0Storm(storm, radarBlockEntity, worldPos, stormPos, scale, stormSize, shapeNoise, shapeNoise2, shapeNoise4, stage, energy, windspeed);
        }
        return localDBZ;
    }

    private float processType0Storm(Object storm, WallRadarBlockEntity radarBlockEntity, Vec3 worldPos, Vec3 stormPos, double scale, double stormSize, double shapeNoise, double shapeNoise2, double shapeNoise4, int stage, int energy, int windspeed) {
        double dist = worldPos.multiply(1.0, 0.0, 1.0).distanceTo(stormPos.multiply(1.0, 0.0, 1.0));
        if (dist > stormSize * 4.0) {
            return 0.0f;
        }
        float intensity = switch (stage) {
            case 1 -> 0.1f + (float)energy / 100.0f * 0.7f;
            case 2 -> 0.8f + (float)energy / 100.0f * 0.4f;
            case 3 -> 1.2f + (float)windspeed / 100.0f;
            default -> (float)Math.pow((float)energy / 100.0f, 2.0) * 0.1f;
        };
        if (intensity > 0.8f) {
            intensity = 0.8f + (intensity - 0.8f) / 4.0f;
        }
        float ws = switch (stage) {
            case 2 -> (float)energy / 100.0f * 40.0f;
            case 3 -> 40.0f + (float)windspeed;
            default -> 0.0f;
        };
        if (ws > 60.0f) {
            ws -= (ws - 60.0f) * 0.2f;
        }
        Vec3 torPos = stormPos.multiply(1.0, 0.0, 1.0);
        Vec3 corePos = torPos.add(100.0 * scale * 2.5 * (double)Math.clamp(intensity * 1.5f, 0.0f, 1.0f), 0.0, -350.0 * scale * 2.5 * (double)Math.clamp(intensity * 1.5f, 0.0f, 1.0f));
        float xM = 1.75f;
        if (worldPos.x > corePos.x) {
            xM = 1.0f;
        }
        double coreDist = Math.sqrt(Math.pow((worldPos.x - corePos.x) * (double)xM, 2.0) + Math.pow((worldPos.z - corePos.z) * 1.5, 2.0)) / scale;
        coreDist *= 0.9 + shapeNoise * 0.3;
        Vec3 relPos = torPos.subtract(worldPos).multiply(scale, 0.0, scale);
        double d = 150.0 + (dist /= scale) / 3.0;
        double d2 = 75.0 + dist / 3.0;
        double angle = Math.atan2(relPos.z, relPos.x) - dist / d;
        double angle2 = Math.atan2(relPos.z, relPos.x) - dist / d2;
        double angle3 = Math.atan2(relPos.z, relPos.x) - dist / d2 / 2.0;
        angle += Math.toRadians(180.0);
        angle2 += Math.toRadians(180.0);
        angle3 += Math.toRadians(180.0);
        double angleMod = Math.toRadians(40.0) * (1.0 - Math.clamp(Math.pow((double)ws / 100.0, 2.0), 0.0, 0.9));
        double noise = (shapeNoise4 - 0.5) * Math.toRadians(10.0);
        angle2 += angleMod + noise;
        angle3 += angleMod + noise;
        float localDBZ = 0.0f;
        double inflow = Math.sin((angle += angleMod + noise) - Math.toRadians(15.0));
        inflow = Math.pow(Math.abs(inflow), 0.5) * Math.sin(inflow);
        if ((inflow *= 1.0 - Math.clamp(dist / 2400.0, 0.0, 1.0)) < 0.0) {
            localDBZ += (float)(inflow * 2.0 * Math.pow(Math.clamp((double)(ws - 15.0f) / 50.0, 0.0, 1.0), 2.0));
        }
        double surge = Math.sin(angle2 - Math.toRadians(60.0));
        surge = Math.abs(surge) * Math.sin(surge);
        if ((surge *= (1.0 - Math.pow(Math.clamp(dist / 1200.0, 0.0, 1.0), 1.5)) * (1.0 - Math.clamp(dist / 200.0, 0.0, 0.3))) > 0.0) {
            double n = 0.8 * (1.0 - Math.clamp(Math.pow((double)ws / 80.0, 2.0), 0.0, 1.0));
            double m = 1.0 - shapeNoise4 * n;
            localDBZ += (float)(surge * 1.5 * Math.clamp(dist / 500.0, 0.0, 1.0) * Math.sqrt(Math.clamp((double)(ws - 20.0f) / 50.0, 0.0, 1.0)) * m);
        }
        double shield = Math.sin(angle3 - Math.toRadians(60.0));
        shield = Math.abs(shield) * Math.sin(shield);
        if ((shield *= 1.0 - Math.pow(Math.clamp(dist / 2400.0, 0.0, 1.0), 2.0)) > 0.0) {
            localDBZ -= (float)(shield * 2.0 * Math.clamp(dist / 1000.0, 0.0, 1.0) * Math.sqrt(Math.clamp((double)(ws - 30.0f) / 80.0, 0.0, 1.0)));
        }
        double coreIntensity = (1.0 - Math.clamp(coreDist / 1800.0, 0.0, 1.0)) * (1.5 - shapeNoise2 * 0.5) * Math.sqrt(Math.clamp((double)intensity / 2.0, 0.0, 1.0)) * Math.clamp(dist / 300.0, 0.5, 1.0) * 1.2;
        return localDBZ += (float)Math.pow(coreIntensity, 0.65);
    }

    private float processType1Storm(Object storm, WallRadarBlockEntity radarBlockEntity, Vec3 worldPos, Vec3 stormPos, Vec3 stormVelocity, double scale, double stormSize, double shapeNoise, double shapeNoise2, float smoothStage, int stage, int energy) {
        float p;
        Vec2 nearPoint;
        float dist;
        Vec2 off;
        Vec2 ri;
        Vec2 le;
        double rawDist = worldPos.multiply(1.0, 0.0, 1.0).distanceTo(stormPos.multiply(1.0, 0.0, 1.0));
        Vec2 v2fWorldPos = new Vec2((float)worldPos.x, (float)worldPos.z);
        Vec2 stormVel = new Vec2((float)stormVelocity.x, (float)stormVelocity.z);
        Vec2 v2fStormPos = new Vec2((float)stormPos.x, (float)stormPos.z);
        Vec2 right = new Vec2(stormVel.y, -stormVel.x).normalized();
        Vec2 fwd = stormVel.normalized();
        try {
            le = (Vec2)utilMulVec2.invoke(null, right, Float.valueOf(-3000.0f * (float)scale));
            ri = (Vec2)utilMulVec2.invoke(null, right, Float.valueOf(3000.0f * (float)scale));
            off = (Vec2)utilMulVec2.invoke(null, fwd, Float.valueOf(-((float)Math.pow(Mth.clamp((float)((float)(rawDist / (3000.0 * scale))), (float)0.0f, (float)1.0f), 2.0)) * (900.0f * (float)scale)));
        }
        catch (Exception e) {
            return 0.0f;
        }
        le = le.add(off);
        ri = ri.add(off);
        le = le.add(v2fStormPos);
        ri = ri.add(v2fStormPos);
        try {
            dist = ((Float)utilMinimumDistance.invoke(null, le, ri, v2fWorldPos)).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
        float intensity = switch (stage) {
            case 1 -> 0.1f + (float)energy / 100.0f * 0.7f;
            case 2 -> 0.8f + (float)energy / 100.0f * 0.4f;
            case 3 -> 1.2f + (float)energy / 100.0f;
            default -> (float)energy / 100.0f * 0.1f;
        };
        if (intensity > 0.8f) {
            intensity = 0.8f + (intensity - 0.8f) / 1.5f;
        }
        try {
            nearPoint = (Vec2)utilNearestPoint.invoke(null, le, ri, v2fWorldPos);
        }
        catch (Exception e) {
            return 0.0f;
        }
        Vec2 facing = v2fWorldPos.add(nearPoint.negated());
        float behind = -facing.dot(fwd);
        behind += (float)shapeNoise * 600.0f * (float)scale * 0.2f;
        float sze = 600.0f * (float)scale * 1.5f * 3.0f;
        float localDBZ = 0.0f;
        if (behind + (float)stormSize / 2.0f > 0.0f) {
            float start;
            behind += (float)stormSize / 2.0f;
            sze *= Mth.lerp((float)Mth.clamp((float)(smoothStage - 1.0f), (float)0.0f, (float)1.0f), (float)1.0f, (float)4.0f);
            p = Mth.clamp((float)(Math.abs(behind) / sze), (float)0.0f, (float)1.0f);
            if (p <= (start = 0.06f)) {
                localDBZ += (float)Math.pow(p / start, 2.0);
            } else {
                p = 1.0f - (p - start) / (1.0f - start);
                localDBZ += (float)Math.pow(p, 4.0);
            }
        }
        localDBZ *= Mth.sqrt((float)(1.0f - Mth.clamp((float)(dist / sze), (float)0.0f, (float)1.0f)));
        if (smoothStage > 3.0f) {
            p = Mth.clamp((float)((smoothStage - 3.0f) / 2.0f), (float)0.0f, (float)0.5f);
            localDBZ *= (float)(0.8 + shapeNoise2 * 0.4 * (1.0 - (double)p));
            localDBZ *= (float)(0.8 + shapeNoise * 0.4 * (1.0 - (double)p));
            localDBZ *= 1.0f + p * 0.25f;
        } else {
            localDBZ *= (float)(0.8 + shapeNoise2 * 0.4);
            localDBZ *= (float)(0.8 + shapeNoise * 0.4);
        }
        return localDBZ *= Mth.sqrt((float)intensity);
    }

    private float processType2Storm(Object storm, WallRadarBlockEntity radarBlockEntity, Vec3 worldPos, Vec3 stormPos, double scale, double shapeNoise, double shapeNoise2, double shapeNoise3, float fineShapeNoise, int windspeed, int stormTickCount) throws Exception {
        Vec3 wPos = worldPos;
        Vec3 cPos = stormPos.multiply(1.0, 0.0, 1.0);
        Field vorticesField = stormClass.getField("vorticies");
        List vorticies = (List)vorticesField.get(storm);
        Field maxWidthField = stormClass.getField("maxWidth");
        int maxWidth = maxWidthField.getInt(storm);
        for (Object vorticy : vorticies) {
            Method getPosMethod = vorticyClass.getMethod("getPosition", new Class[0]);
            Vec3 vPos = (Vec3)getPosMethod.invoke(vorticy, new Object[0]);
            Method getWidthMethod = vorticyClass.getMethod("getWidth", new Class[0]);
            float width = ((Float)getWidthMethod.invoke(vorticy, new Object[0])).floatValue() * 0.35f;
            Field windspeedMultField = vorticyClass.getField("windspeedMult");
            float windspeedMult = windspeedMultField.getFloat(vorticy);
            double d = wPos.multiply(1.0, 0.0, 1.0).distanceTo(vPos.multiply(1.0, 0.0, 1.0));
            if (!(d < (double)width)) continue;
            double angle3 = Math.pow(1.0 - Math.clamp(d / (double)width, 0.0, 1.0), 3.75);
            angle3 *= 0.3141592741012573;
            angle3 *= (double)Math.min(windspeedMult * (float)windspeed, 6.0f);
            try {
                wPos = (Vec3)utilRotatePoint.invoke(null, wPos, vPos, angle3);
            }
            catch (Exception exception) {}
        }
        double rawDist = wPos.multiply(1.0, 0.0, 1.0).distanceTo(stormPos.multiply(1.0, 0.0, 1.0));
        rawDist *= 1.0 + shapeNoise3 * 0.2;
        float intensity = (float)Math.pow(Math.clamp((float)windspeed / 65.0f, 0.0f, 1.0f), 0.25);
        Vec3 relPos = cPos.subtract(wPos).multiply(scale, 0.0, scale);
        double d = (float)maxWidth / (3.0f + (float)windspeed / 12.0f);
        double d2 = (float)maxWidth / (1.15f + (float)windspeed / 12.0f);
        double dE = (float)maxWidth * 0.65f / (1.75f + (float)windspeed / 12.0f);
        double fac = 1.0 + Math.max((rawDist - (double)((float)maxWidth * 0.2f)) / (double)maxWidth, 0.0) * 2.0;
        double angle = Math.atan2(relPos.z, relPos.x) - rawDist / (d *= fac);
        double angle2 = Math.atan2(relPos.z, relPos.x) - rawDist / (d2 *= fac);
        double angleE = Math.atan2(relPos.z, relPos.x) - rawDist / dE;
        float weak = 0.0f;
        float strong = 0.0f;
        float intense = 0.0f;
        float staticBands = (float)Math.sin(angle - 1.5707963267948966);
        staticBands *= (float)Math.pow(Math.clamp(rawDist / (double)((float)maxWidth * 0.25f), 0.0, 1.0), 0.1);
        if ((staticBands *= 1.25f * (float)Math.pow(intensity, 0.75)) < 0.0f) {
            weak += Math.abs(staticBands);
        } else {
            weak += Math.abs(staticBands) * (float)Math.pow(1.0 - Math.clamp(rawDist / (double)((float)maxWidth * 0.65f), 0.0, 1.0), 0.5);
            weak *= Math.clamp(((float)windspeed - 70.0f) / 40.0f, 0.0f, 1.0f);
        }
        float rotatingBands = (float)Math.sin((angle2 + Math.toRadians((float)stormTickCount / 8.0f)) * 6.0);
        rotatingBands *= (float)Math.pow(Math.clamp(rawDist / (double)((float)maxWidth * 0.25f), 0.0, 1.0), 0.1);
        strong += Mth.lerp((float)0.45f, (float)(Math.abs(rotatingBands *= 1.25f * (float)Math.pow(intensity, 0.75)) * 0.3f + 0.7f), (float)weak);
        intense += Mth.lerp((float)0.3f, (float)(Math.abs(rotatingBands) * 0.2f + 0.8f), (float)weak);
        weak = (Math.abs(rotatingBands) * 0.3f + 0.6f) * weak;
        float localDBZ = Mth.lerp((float)Math.clamp(((float)windspeed - 120.0f) / 60.0f, 0.0f, 1.0f), (float)Mth.lerp((float)Math.clamp(((float)windspeed - 40.0f) / 90.0f, 0.0f, 1.0f), (float)weak, (float)strong), (float)intense);
        float eye = (float)Math.sin((angleE + Math.toRadians((float)stormTickCount / 4.0f)) * 2.0);
        float efc = Mth.lerp((float)Math.clamp(((float)windspeed - 100.0f) / 50.0f, 0.0f, 1.0f), (float)0.15f, (float)0.4f);
        localDBZ = Math.max((float)Math.pow(1.0 - Math.clamp(rawDist / (double)((float)maxWidth * efc), 0.0, 1.0), 0.5) * (Math.abs(eye * 0.1f) + 0.9f) * 1.35f * intensity, localDBZ);
        localDBZ *= (float)Math.pow(1.0 - Math.clamp(rawDist / (double)maxWidth, 0.0, 1.0), 0.5);
        localDBZ *= Mth.lerp((float)(0.5f + Math.clamp(((float)windspeed - 65.0f) / 40.0f, 0.0f, 1.0f) * 0.5f), (float)1.0f, (float)((float)Math.pow(Math.clamp(rawDist / (double)((float)maxWidth * 0.1f), 0.0, 1.0), 2.0)));
        localDBZ *= Mth.lerp((float)Math.clamp(((float)windspeed - 75.0f) / 50.0f, 0.0f, 1.0f), (float)((float)(0.8 + shapeNoise2 * 0.4)), (float)1.0f);
        localDBZ *= (float)(0.8 + shapeNoise * 0.4);
        localDBZ *= 1.0f + fineShapeNoise * Mth.lerp((float)((float)Math.pow(Math.clamp(rawDist / (double)maxWidth, 0.0, 1.0), 1.5)), (float)0.05f, (float)0.15f);
        localDBZ = (float)Math.pow(localDBZ, 1.75);
        if (localDBZ > 0.8f) {
            float dif = (localDBZ - 0.8f) / 1.25f;
            localDBZ -= dif;
        }
        return localDBZ;
    }

    private void applyWallTransformation(Matrix4fStack matrix, Direction facing) {
        if (!hasLoggedTransform) {
            hasLoggedTransform = true;
            WXMCDebugLogger.debug("=== WALL RADAR VIEWER-RELATIVE ORIENTATION ===");
            WXMCDebugLogger.debug("Radar shows direction relative to how you VIEW it:");
            WXMCDebugLogger.debug("  TOP = direction you're looking (forward)");
            WXMCDebugLogger.debug("  BOTTOM = direction behind you");
            WXMCDebugLogger.debug("  LEFT/RIGHT = your left/right when viewing");
            WXMCDebugLogger.debug("================================================");
        }
        switch (facing) {
            case NORTH: {
                float displayZ = 0.825f;
                matrix.translate(0.5f, 0.5f, displayZ);
                matrix.rotateX((float)Math.toRadians(-90.0));
                break;
            }
            case SOUTH: {
                float displayZ = 0.175f;
                matrix.translate(0.5f, 0.5f, displayZ);
                matrix.rotateX((float)Math.toRadians(90.0));
                break;
            }
            case EAST: {
                float displayX = 0.175f;
                matrix.translate(displayX, 0.5f, 0.5f);
                matrix.rotateZ((float)Math.toRadians(-90.0));
                break;
            }
            case WEST: {
                float displayX = 0.825f;
                matrix.translate(displayX, 0.5f, 0.5f);
                matrix.rotateZ((float)Math.toRadians(90.0));
                break;
            }
            default: {
                matrix.translate(0.5f, 1.05f, 0.5f);
            }
        }
    }

    private void reverseWallTransformation(Matrix4fStack matrix, Direction facing) {
        switch (facing) {
            case NORTH: {
                float displayZ = 0.825f;
                matrix.rotateX((float)Math.toRadians(-90.0));
                matrix.translate(-0.5f, -0.5f, -displayZ);
                break;
            }
            case SOUTH: {
                float displayZ = 0.175f;
                matrix.rotateX((float)Math.toRadians(-90.0));
                matrix.rotateY((float)Math.toRadians(-180.0));
                matrix.translate(-0.5f, -0.5f, -displayZ);
                break;
            }
            case EAST: {
                float displayX = 0.175f;
                matrix.rotateX((float)Math.toRadians(-90.0));
                matrix.rotateY((float)Math.toRadians(-90.0));
                matrix.translate(-displayX, -0.5f, -0.5f);
                break;
            }
            case WEST: {
                float displayX = 0.825f;
                matrix.translate(-displayX, -0.5f, -0.5f);
                break;
            }
            default: {
                matrix.translate(-0.5f, -1.05f, -0.5f);
            }
        }
    }

    private Color getFallbackColor(float dbz, Color startColor) {
        if (dbz < 5.0f) {
            return startColor;
        }
        if (dbz < 20.0f) {
            return new Color(0, 200, 0);
        }
        if (dbz < 35.0f) {
            return new Color(255, 255, 0);
        }
        if (dbz < 50.0f) {
            return new Color(255, 0, 0);
        }
        if (dbz < 65.0f) {
            return new Color(255, 0, 255);
        }
        return new Color(255, 255, 255);
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }

    public int getViewDistance() {
        return 64;
    }

    public static void resetRenderedRadars() {
        RenderedRadars = 0;
    }
}

