/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.client;

import dev.wxmc.weatheraddon.data.SubmissionReview;
import dev.wxmc.weatheraddon.data.TornadoEntry;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ViewReviewsScreen
extends Screen {
    private static final int TITLE_COLOR = 0xFFFFFF;
    private static final int HEADER_COLOR = 0xFFFF55;
    private static final int LABEL_COLOR = 0xAAAAAA;
    private static final int ROW_HEIGHT = 45;
    private static final int REVIEWS_PER_PAGE = 4;
    private final TornadoEntry entry;
    private final Screen parentScreen;
    private final List<SubmissionReview> reviews;
    private int currentPage = 0;
    private Button prevButton;
    private Button nextButton;

    public ViewReviewsScreen(TornadoEntry entry, Screen parentScreen) {
        super((Component)Component.literal((String)"Reviews"));
        this.entry = entry;
        this.parentScreen = parentScreen;
        this.reviews = entry.reviews() != null ? entry.reviews() : List.of();
    }

    protected void init() {
        int centerX = this.width / 2;
        int buttonY = this.height - 35;
        int buttonWidth = 80;
        this.prevButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"< Previous"), button -> {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.updateButtons();
            }
        }).bounds(centerX - buttonWidth - 50, buttonY, buttonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"< Back"), button -> Minecraft.getInstance().setScreen(this.parentScreen)).bounds(centerX - 40, buttonY, 80, 20).build());
        this.nextButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Next >"), button -> {
            if ((this.currentPage + 1) * 4 < this.reviews.size()) {
                ++this.currentPage;
                this.updateButtons();
            }
        }).bounds(centerX + 50, buttonY, buttonWidth, 20).build());
        this.updateButtons();
    }

    private void updateButtons() {
        this.prevButton.active = this.currentPage > 0;
        this.nextButton.active = (this.currentPage + 1) * 4 < this.reviews.size();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        int centerX = this.width / 2;
        int y = 15;
        graphics.drawCenteredString(this.font, this.title, centerX, y, 0xFFFFFF);
        String entryInfo = "Entry: " + this.entry.eventId() + " - " + this.entry.rating().getDisplayName() + " by " + this.entry.submitterName();
        graphics.drawCenteredString(this.font, entryInfo, centerX, y += 15, 0xAAAAAA);
        int upvotes = this.entry.upvoteCount();
        int downvotes = this.entry.downvoteCount();
        String summary = "\u00a7a\u2191 " + upvotes + " Upvotes   \u00a7c\u2193 " + downvotes + " Downvotes   \u00a77Total: " + this.reviews.size();
        graphics.drawCenteredString(this.font, summary, centerX, y += 18, 0xFFFFFF);
        graphics.fill(30, y += 20, this.width - 30, y + 1, -11184811);
        y += 10;
        if (this.reviews.isEmpty()) {
            graphics.drawCenteredString(this.font, "No reviews yet", centerX, y + 40, 0x888888);
            return;
        }
        int totalPages = Math.max(1, (this.reviews.size() + 4 - 1) / 4);
        String pageInfo = "Page " + (this.currentPage + 1) + " of " + totalPages;
        graphics.drawCenteredString(this.font, pageInfo, centerX, this.height - 55, 0x888888);
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm");
        int startIndex = this.currentPage * 4;
        int endIndex = Math.min(startIndex + 4, this.reviews.size());
        int cardMargin = 40;
        int cardWidth = this.width - cardMargin * 2;
        for (int i = startIndex; i < endIndex; ++i) {
            SubmissionReview review = this.reviews.get(i);
            this.renderReviewCard(graphics, review, cardMargin, y, cardWidth, dateFormat, i - startIndex);
            y += 50;
        }
    }

    private void renderReviewCard(GuiGraphics graphics, SubmissionReview review, int x, int y, int width, SimpleDateFormat dateFormat, int index) {
        int voteColor;
        String voteIcon;
        int bgColor = index % 2 == 0 ? 0x40000000 : 0x30000000;
        graphics.fill(x, y, x + width, y + 45, bgColor);
        graphics.renderOutline(x, y, width, 45, -12303292);
        int padding = 8;
        int innerX = x + padding;
        int innerY = y + padding;
        if (review.agreement() == SubmissionReview.ReviewAgreement.AGREE) {
            voteIcon = "\u2191";
            voteColor = 0x55FF55;
        } else {
            voteIcon = "\u2193";
            voteColor = 0xFF5555;
        }
        graphics.drawString(this.font, voteIcon, innerX, innerY, voteColor);
        String reviewerText = review.reviewerName();
        graphics.drawString(this.font, reviewerText, innerX + 15, innerY, 0xFFFFFF);
        String voteText = review.agreement() == SubmissionReview.ReviewAgreement.AGREE ? "(Upvote)" : "(Downvote)";
        int nameWidth = this.font.width(reviewerText);
        graphics.drawString(this.font, voteText, innerX + 15 + nameWidth + 5, innerY, voteColor);
        String dateText = dateFormat.format(new Date(review.timestamp()));
        int dateWidth = this.font.width(dateText);
        graphics.drawString(this.font, dateText, x + width - padding - dateWidth, innerY, 0xAAAAAA);
        innerY += 14;
        Object notes = review.notes();
        if (notes == null || ((String)notes).isEmpty()) {
            notes = "(No comments)";
            graphics.drawString(this.font, (String)notes, innerX + 15, innerY, 0x666666);
        } else {
            int maxNotesWidth = width - padding * 2 - 15;
            if (this.font.width((String)notes) > maxNotesWidth) {
                while (this.font.width((String)notes + "...") > maxNotesWidth && ((String)notes).length() > 0) {
                    notes = ((String)notes).substring(0, ((String)notes).length() - 1);
                }
                notes = (String)notes + "...";
            }
            graphics.drawString(this.font, (String)notes, innerX + 15, innerY, 0xCCCCCC);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

