/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.client;

import dev.wxmc.weatheraddon.client.EntryDetailScreen;
import dev.wxmc.weatheraddon.data.TornadoEntry;
import dev.wxmc.weatheraddon.data.TornadoRating;
import dev.wxmc.weatheraddon.network.DamageAssessmentNetworkHandler;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class TornadoDatabaseScreen
extends Screen {
    private static final int ENTRIES_PER_PAGE = 8;
    private static final int ROW_HEIGHT = 18;
    private static final int TITLE_COLOR = 0xFFFFFF;
    private static final int HEADER_COLOR = 0xFFFF55;
    private static final int SEPARATOR_COLOR = -11184811;
    private List<TornadoEntry> entries;
    private final boolean isAdmin;
    private int currentPage = 0;
    private Button prevButton;
    private Button nextButton;
    private int rowStartY;
    private int rowStartX;
    private int rowEndX;
    private int col1;
    private int col2;
    private int col3;
    private int col4;
    private int col5;
    private int col6;
    private int col7;
    private int col8;
    private int deleteButtonX;
    private int acceptButtonX;
    private int actionButtonWidth = 35;

    public TornadoDatabaseScreen(List<TornadoEntry> entries) {
        this(entries, false);
    }

    public TornadoDatabaseScreen(List<TornadoEntry> entries, boolean isAdmin) {
        super((Component)Component.literal((String)(isAdmin ? "Tornado Database (Admin)" : "Tornado Database")));
        this.entries = new ArrayList<TornadoEntry>(entries);
        this.isAdmin = isAdmin;
    }

    protected void init() {
        int startX;
        int buttonWidth = 80;
        int buttonY = this.height - 35;
        this.prevButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"< Previous"), button -> {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.updateButtons();
            }
        }).bounds(this.width / 2 - buttonWidth - 50, buttonY, buttonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Close"), button -> this.onClose()).bounds(this.width / 2 - 40, buttonY, 80, 20).build());
        this.nextButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Next >"), button -> {
            if ((this.currentPage + 1) * 8 < this.entries.size()) {
                ++this.currentPage;
                this.updateButtons();
            }
        }).bounds(this.width / 2 + 50, buttonY, buttonWidth, 20).build());
        this.updateButtons();
        this.rowStartX = 10;
        this.rowEndX = this.width - 10;
        this.rowStartY = 57;
        this.col1 = startX = 10;
        this.col2 = startX + 65;
        this.col3 = startX + 115;
        this.col4 = startX + 170;
        this.col5 = startX + 235;
        this.col6 = startX + 275;
        this.col7 = startX + 345;
        this.col8 = startX + 430;
        if (this.isAdmin) {
            this.deleteButtonX = this.col8;
            this.acceptButtonX = this.col8 + this.actionButtonWidth + 5;
        }
    }

    private void updateButtons() {
        this.prevButton.active = this.currentPage > 0;
        this.nextButton.active = (this.currentPage + 1) * 8 < this.entries.size();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 12, 0xFFFFFF);
        int totalPages = Math.max(1, (this.entries.size() + 8 - 1) / 8);
        String pageInfo = String.format("Entries: %d | Page %d of %d", this.entries.size(), this.currentPage + 1, totalPages);
        graphics.drawCenteredString(this.font, pageInfo, this.width / 2, 25, 0xAAAAAA);
        if (this.entries.isEmpty()) {
            graphics.drawCenteredString(this.font, "No entries in database", this.width / 2, 80, 0x888888);
            return;
        }
        int headerY = 42;
        graphics.drawString(this.font, "Event ID", this.col1, headerY, 0xFFFF55);
        graphics.drawString(this.font, "Rating", this.col2, headerY, 0xFFFF55);
        graphics.drawString(this.font, "Wind", this.col3, headerY, 0xFFFF55);
        graphics.drawString(this.font, "Coords", this.col4, headerY, 0xFFFF55);
        graphics.drawString(this.font, "Photos", this.col5, headerY, 0xFFFF55);
        graphics.drawString(this.font, "Submitter", this.col6, headerY, 0xFFFF55);
        graphics.drawString(this.font, "Date", this.col7, headerY, 0xFFFF55);
        graphics.drawString(this.font, this.isAdmin ? "Options" : "Evaluation", this.col8, headerY, 0xFFFF55);
        graphics.fill(10, headerY + 10, this.width - 10, headerY + 11, -11184811);
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd HH:mm");
        int startIndex = this.currentPage * 8;
        int endIndex = Math.min(startIndex + 8, this.entries.size());
        int y = headerY + 15;
        for (int i = startIndex; i < endIndex; ++i) {
            boolean hovered;
            TornadoEntry entry = this.entries.get(i);
            boolean overActionButtons = this.isAdmin && mouseX >= this.deleteButtonX && mouseX <= this.acceptButtonX + this.actionButtonWidth;
            boolean bl = hovered = mouseX >= this.rowStartX && mouseX <= this.rowEndX && mouseY >= y - 2 && mouseY < y + 18 - 2 && !overActionButtons;
            if (hovered) {
                graphics.fill(this.rowStartX, y - 2, this.col8 - 5, y + 18 - 2, 0x40FFFFFF);
            }
            int rowColor = hovered ? 0xFFFFFF : (i % 2 == 0 ? 0xFFFFFF : 0xDDDDDD);
            String eventId = this.truncate(entry.eventId(), 8);
            String submitter = this.truncate(entry.submitterName(), 9);
            String coords = entry.coordX() + "," + entry.coordZ();
            int photoCount = entry.photoCount();
            graphics.drawString(this.font, eventId, this.col1, y, rowColor);
            graphics.drawString(this.font, entry.rating().getDisplayName(), this.col2, y, this.getRatingColor(entry.rating()));
            graphics.drawString(this.font, this.truncate(entry.windspeedEst(), 7), this.col3, y, rowColor);
            graphics.drawString(this.font, this.truncate(coords, 9), this.col4, y, rowColor);
            int photoColor = photoCount >= 3 ? 0x55FF55 : (photoCount > 0 ? 0xFFFF55 : 0x555555);
            graphics.drawString(this.font, String.valueOf(photoCount), this.col5, y, photoColor);
            graphics.drawString(this.font, submitter, this.col6, y, rowColor);
            graphics.drawString(this.font, dateFormat.format(new Date(entry.timestamp())), this.col7, y, 0xAAAAAA);
            if (this.isAdmin) {
                boolean overDelete = mouseX >= this.deleteButtonX && mouseX < this.deleteButtonX + this.actionButtonWidth && mouseY >= y - 2 && mouseY < y + 18 - 2;
                boolean overAccept = mouseX >= this.acceptButtonX && mouseX < this.acceptButtonX + this.actionButtonWidth && mouseY >= y - 2 && mouseY < y + 18 - 2;
                int deleteColor = overDelete ? 0xFFAAAA : 0xFF5555;
                graphics.drawString(this.font, "[Del]", this.deleteButtonX, y, deleteColor);
                if (entry.accepted()) {
                    graphics.drawString(this.font, "Done", this.acceptButtonX, y, 0x55FF55);
                } else {
                    int acceptColor = overAccept ? 0xAAFFAA : 0x55FF55;
                    graphics.drawString(this.font, "[OK]", this.acceptButtonX, y, acceptColor);
                }
            } else if (entry.accepted()) {
                graphics.drawString(this.font, "Accepted", this.col8, y, 0x55FF55);
            } else {
                int upvotes = entry.upvoteCount();
                int downvotes = entry.downvoteCount();
                String evalText = "\u00a7a\u2191" + upvotes + " \u00a7c\u2193" + downvotes;
                graphics.drawString(this.font, evalText, this.col8, y, 0xFFFFFF);
            }
            y += 18;
        }
        String hintText = this.isAdmin ? "Click entry to view details | [Del] to delete | [OK] to accept" : "Click an entry to view details and photos";
        graphics.drawCenteredString(this.font, hintText, this.width / 2, this.height - 55, 0x888888);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && !this.entries.isEmpty()) {
            int startIndex = this.currentPage * 8;
            int endIndex = Math.min(startIndex + 8, this.entries.size());
            int y = this.rowStartY;
            for (int i = startIndex; i < endIndex; ++i) {
                if (mouseY >= (double)(y - 2) && mouseY < (double)(y + 18 - 2)) {
                    TornadoEntry entry = this.entries.get(i);
                    if (this.isAdmin) {
                        if (mouseX >= (double)this.deleteButtonX && mouseX < (double)(this.deleteButtonX + this.actionButtonWidth)) {
                            PacketDistributor.sendToServer((CustomPacketPayload)new DamageAssessmentNetworkHandler.AdminActionPacket(entry.entryId(), DamageAssessmentNetworkHandler.AdminActionPacket.Action.DELETE), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            this.entries.remove(i);
                            return true;
                        }
                        if (mouseX >= (double)this.acceptButtonX && mouseX < (double)(this.acceptButtonX + this.actionButtonWidth) && !entry.accepted()) {
                            PacketDistributor.sendToServer((CustomPacketPayload)new DamageAssessmentNetworkHandler.AdminActionPacket(entry.entryId(), DamageAssessmentNetworkHandler.AdminActionPacket.Action.ACCEPT), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            this.entries.set(i, entry.withAccepted(true));
                            return true;
                        }
                    }
                    if (mouseX >= (double)this.rowStartX && mouseX < (double)(this.col8 - 5)) {
                        Minecraft.getInstance().setScreen((Screen)new EntryDetailScreen(entry, this, this.isAdmin));
                        return true;
                    }
                }
                y += 18;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private String truncate(String text, int maxLength) {
        if (text == null) {
            return "";
        }
        if (text.length() <= maxLength) {
            return text;
        }
        return text.substring(0, maxLength - 2) + "..";
    }

    private int getRatingColor(TornadoRating rating) {
        return rating.getColor();
    }

    public boolean isPauseScreen() {
        return false;
    }
}

