/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TooltipWarningScreen
extends Screen {
    private static final int BACKGROUND_COLOR = -267386864;
    private static final int BORDER_COLOR_TOP = 0x505000FF;
    private static final int BORDER_COLOR_BOTTOM = 1344798847;
    private static final float TEXT_SCALE = 0.65f;
    private static final int LINE_HEIGHT = 10;
    private static final int PADDING = 8;
    private static final int BORDER_WIDTH = 1;
    private static final int MAX_TEXT_WIDTH = 350;
    private final String rawTemplate;
    private final int warningColor;
    private List<FormattedLine> formattedLines;
    private int contentWidth;
    private int contentHeight;

    public TooltipWarningScreen(String rawTemplate, int warningColor) {
        super((Component)Component.literal((String)"Weather Warning"));
        this.rawTemplate = rawTemplate;
        this.warningColor = warningColor;
    }

    public TooltipWarningScreen(Component content, int warningColor) {
        super((Component)Component.literal((String)"Weather Warning"));
        this.rawTemplate = null;
        this.warningColor = warningColor;
        this.formattedLines = this.splitComponentIntoLines(content);
    }

    protected void init() {
        if (this.rawTemplate != null && this.formattedLines == null) {
            this.formattedLines = this.parseTemplate(this.rawTemplate);
        } else if (this.formattedLines == null) {
            this.formattedLines = new ArrayList<FormattedLine>();
        }
        this.contentWidth = 0;
        for (FormattedLine line : this.formattedLines) {
            this.contentWidth = Math.max(this.contentWidth, line.width);
        }
        this.contentWidth = Math.min(this.contentWidth, 350);
        this.contentHeight = this.formattedLines.size() * 10;
        int buttonWidth = 80;
        int buttonHeight = 20;
        int buttonY = (this.height + (int)((float)this.contentHeight * 0.65f)) / 2 + 8 + 10;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Close").withStyle(ChatFormatting.WHITE), button -> this.onClose()).bounds((this.width - buttonWidth) / 2, Math.min(buttonY, this.height - buttonHeight - 10), buttonWidth, buttonHeight).build());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.fill(0, 0, this.width, this.height, Integer.MIN_VALUE);
        if (this.formattedLines == null || this.formattedLines.isEmpty()) {
            super.render(graphics, mouseX, mouseY, partialTick);
            return;
        }
        PoseStack poseStack = graphics.pose();
        int scaledWidth = (int)((float)this.contentWidth * 0.65f);
        int scaledHeight = (int)((float)this.contentHeight * 0.65f);
        int boxX = (this.width - scaledWidth) / 2 - 8;
        int boxY = (this.height - scaledHeight) / 2 - 8 - 20;
        int boxWidth = scaledWidth + 16;
        int boxHeight = scaledHeight + 16;
        boxY = Math.max(10, boxY);
        this.renderTooltipBackground(graphics, boxX, boxY, boxWidth, boxHeight);
        graphics.fill(boxX + 1, boxY + 1, boxX + boxWidth - 1, boxY + 3, this.warningColor | 0xFF000000);
        int textX = boxX + 8;
        int textY = boxY + 8 + 4;
        poseStack.pushPose();
        poseStack.translate((float)textX, (float)textY, 0.0f);
        poseStack.scale(0.65f, 0.65f, 1.0f);
        int yOffset = 0;
        for (FormattedLine line : this.formattedLines) {
            graphics.drawString(this.font, line.component, 0, yOffset, 0xFFFFFF, true);
            yOffset += 10;
        }
        poseStack.popPose();
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    private void renderTooltipBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        int z = 400;
        graphics.fill(x + 1, y + 1, x + width - 1, y + height - 1, -267386864);
        graphics.fill(x + 1, y, x + width - 1, y + 1, -267386864);
        graphics.fill(x + 1, y + height - 1, x + width - 1, y + height, -267386864);
        graphics.fill(x, y + 1, x + 1, y + height - 1, -267386864);
        graphics.fill(x + width - 1, y + 1, x + width, y + height - 1, -267386864);
        graphics.fillGradient(x + 1, y + 2, x + 2, y + height - 2, 0x505000FF, 1344798847);
        graphics.fillGradient(x + width - 2, y + 2, x + width - 1, y + height - 2, 0x505000FF, 1344798847);
        graphics.fill(x + 2, y + 1, x + width - 2, y + 2, 0x505000FF);
        graphics.fill(x + 2, y + height - 2, x + width - 2, y + height - 1, 1344798847);
    }

    private List<FormattedLine> parseTemplate(String template) {
        String[] rawLines;
        ArrayList<FormattedLine> lines = new ArrayList<FormattedLine>();
        for (String rawLine : rawLines = template.split("\n")) {
            Component parsed = TooltipWarningScreen.parseFormattedText(rawLine);
            int width = this.font.width((FormattedText)parsed);
            if (width > 350) {
                List wrapped = this.font.split((FormattedText)parsed, 350);
                for (FormattedCharSequence seq : wrapped) {
                    StringBuilder sb = new StringBuilder();
                    seq.accept((index, style, codePoint) -> {
                        sb.appendCodePoint(codePoint);
                        return true;
                    });
                    MutableComponent lineComp = Component.literal((String)sb.toString());
                    lines.add(new FormattedLine((Component)lineComp, this.font.width(seq)));
                }
                continue;
            }
            lines.add(new FormattedLine(parsed, width));
        }
        return lines;
    }

    private List<FormattedLine> splitComponentIntoLines(Component content) {
        String[] parts;
        ArrayList<FormattedLine> lines = new ArrayList<FormattedLine>();
        String text = content.getString();
        for (String part : parts = text.split("\n")) {
            Component parsed = TooltipWarningScreen.parseFormattedText(part);
            int width = this.font != null ? this.font.width((FormattedText)parsed) : part.length() * 6;
            lines.add(new FormattedLine(parsed, width));
        }
        return lines;
    }

    private static Component parseFormattedText(String text) {
        MutableComponent result = Component.empty();
        Style currentStyle = Style.EMPTY;
        StringBuilder currentText = new StringBuilder();
        int i = 0;
        block26: while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '#' && i + 6 < text.length()) {
                if (currentText.length() > 0) {
                    result.append((Component)Component.literal((String)currentText.toString()).withStyle(currentStyle));
                    currentText = new StringBuilder();
                }
                String hexCode = text.substring(i + 1, i + 7);
                try {
                    int color = Integer.parseInt(hexCode, 16);
                    currentStyle = Style.EMPTY.withColor(TextColor.fromRgb((int)color));
                    i += 7;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (c == '&' && i + 1 < text.length()) {
                char code = text.charAt(i + 1);
                if (code == '&') {
                    currentText.append('&');
                    i += 2;
                    continue;
                }
                if (currentText.length() > 0) {
                    result.append((Component)Component.literal((String)currentText.toString()).withStyle(currentStyle));
                    currentText = new StringBuilder();
                }
                switch (code) {
                    case '0': {
                        currentStyle = currentStyle.withColor(ChatFormatting.BLACK);
                        break;
                    }
                    case '1': {
                        currentStyle = currentStyle.withColor(ChatFormatting.DARK_BLUE);
                        break;
                    }
                    case '2': {
                        currentStyle = currentStyle.withColor(ChatFormatting.DARK_GREEN);
                        break;
                    }
                    case '3': {
                        currentStyle = currentStyle.withColor(ChatFormatting.DARK_AQUA);
                        break;
                    }
                    case '4': {
                        currentStyle = currentStyle.withColor(ChatFormatting.DARK_RED);
                        break;
                    }
                    case '5': {
                        currentStyle = currentStyle.withColor(ChatFormatting.DARK_PURPLE);
                        break;
                    }
                    case '6': {
                        currentStyle = currentStyle.withColor(ChatFormatting.GOLD);
                        break;
                    }
                    case '7': {
                        currentStyle = currentStyle.withColor(ChatFormatting.GRAY);
                        break;
                    }
                    case '8': {
                        currentStyle = currentStyle.withColor(ChatFormatting.DARK_GRAY);
                        break;
                    }
                    case '9': {
                        currentStyle = currentStyle.withColor(ChatFormatting.BLUE);
                        break;
                    }
                    case 'a': {
                        currentStyle = currentStyle.withColor(ChatFormatting.GREEN);
                        break;
                    }
                    case 'b': {
                        currentStyle = currentStyle.withColor(ChatFormatting.AQUA);
                        break;
                    }
                    case 'c': {
                        currentStyle = currentStyle.withColor(ChatFormatting.RED);
                        break;
                    }
                    case 'd': {
                        currentStyle = currentStyle.withColor(ChatFormatting.LIGHT_PURPLE);
                        break;
                    }
                    case 'e': {
                        currentStyle = currentStyle.withColor(ChatFormatting.YELLOW);
                        break;
                    }
                    case 'f': {
                        currentStyle = currentStyle.withColor(ChatFormatting.WHITE);
                        break;
                    }
                    case 'l': {
                        currentStyle = currentStyle.withBold(Boolean.valueOf(true));
                        break;
                    }
                    case 'n': {
                        currentStyle = currentStyle.withUnderlined(Boolean.valueOf(true));
                        break;
                    }
                    case 'o': {
                        currentStyle = currentStyle.withItalic(Boolean.valueOf(true));
                        break;
                    }
                    case 'm': {
                        currentStyle = currentStyle.withStrikethrough(Boolean.valueOf(true));
                        break;
                    }
                    case 'k': {
                        currentStyle = currentStyle.withObfuscated(Boolean.valueOf(true));
                        break;
                    }
                    case 'r': {
                        currentStyle = Style.EMPTY;
                        break;
                    }
                    default: {
                        currentText.append(c);
                        ++i;
                        continue block26;
                    }
                }
                i += 2;
                continue;
            }
            currentText.append(c);
            ++i;
        }
        if (currentText.length() > 0) {
            result.append((Component)Component.literal((String)currentText.toString()).withStyle(currentStyle));
        }
        return result;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 1) {
            this.onClose();
            return true;
        }
        return false;
    }

    private static class FormattedLine {
        final Component component;
        final int width;

        FormattedLine(Component component, int width) {
            this.component = component;
            this.width = width;
        }
    }
}

