/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.client;

import dev.wxmc.weatheraddon.ClientConfig;
import dev.wxmc.weatheraddon.ModSounds;
import dev.wxmc.weatheraddon.block.TornadoSirenBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TickableSirenSound
extends AbstractTickableSoundInstance {
    private final BlockPos sirenPos;
    private final Vec3 sirenPosVec;
    private boolean stopping = false;
    private float calculatedVolume = 1.0f;
    private static final int SIREN_DURATION_TICKS = 580;
    private int ticksPlayed = 0;

    public TickableSirenSound(BlockPos sirenPos, int frequencyOrdinal) {
        super(TickableSirenSound.getSoundEvent(frequencyOrdinal), SoundSource.BLOCKS, SoundInstance.createUnseededRandom());
        this.sirenPos = sirenPos;
        this.sirenPosVec = new Vec3((double)sirenPos.getX() + 0.5, (double)sirenPos.getY() + 0.5, (double)sirenPos.getZ() + 0.5);
        this.x = this.sirenPosVec.x;
        this.y = this.sirenPosVec.y;
        this.z = this.sirenPosVec.z;
        this.attenuation = SoundInstance.Attenuation.NONE;
        this.looping = false;
        this.updateVolumeBasedOnDistance();
    }

    private static SoundEvent getSoundEvent(int frequencyOrdinal) {
        return frequencyOrdinal == TornadoSirenBlockEntity.SirenFrequency.HZ_659.ordinal() ? (SoundEvent)ModSounds.SIREN_FULL_659HZ.get() : (SoundEvent)ModSounds.SIREN_FULL_523HZ.get();
    }

    public void tick() {
        ++this.ticksPlayed;
        if (this.stopping || this.ticksPlayed >= 580) {
            this.stop();
            return;
        }
        this.updateVolumeBasedOnDistance();
    }

    private void updateVolumeBasedOnDistance() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            this.calculatedVolume = 0.0f;
            return;
        }
        double distance = player.position().distanceTo(this.sirenPosVec);
        this.calculatedVolume = ClientConfig.getEffectiveVolume(distance);
    }

    public float getVolume() {
        return this.calculatedVolume;
    }

    public void markStopping() {
        this.stopping = true;
    }

    public BlockPos getSirenPos() {
        return this.sirenPos;
    }

    public boolean canStartSilent() {
        return true;
    }

    public boolean canPlaySound() {
        return ClientConfig.areSirensEnabled();
    }
}

