/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.client;

import dev.wxmc.weatheraddon.data.SubmissionReview;
import dev.wxmc.weatheraddon.data.TornadoEntry;
import dev.wxmc.weatheraddon.data.TornadoRating;
import dev.wxmc.weatheraddon.network.DamageAssessmentNetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class SubmissionRatingScreen
extends Screen {
    private static final int FIELD_WIDTH = 220;
    private static final int FIELD_HEIGHT = 20;
    private static final int ROW_SPACING = 28;
    private static final int TITLE_COLOR = 0xFFFFFF;
    private static final int LABEL_COLOR = 0xAAAAAA;
    private final TornadoEntry entry;
    private final Screen parentScreen;
    private final boolean isAdmin;
    private Button agreeButton;
    private Button disagreeButton;
    private EditBox notesField;
    private Button submitButton;
    private Button cancelButton;
    private SubmissionReview.ReviewAgreement selectedAgreement = null;

    public SubmissionRatingScreen(TornadoEntry entry, Screen parentScreen) {
        this(entry, parentScreen, false);
    }

    public SubmissionRatingScreen(TornadoEntry entry, Screen parentScreen, boolean isAdmin) {
        super((Component)Component.literal((String)"Rate Submission"));
        this.entry = entry;
        this.parentScreen = parentScreen;
        this.isAdmin = isAdmin;
    }

    protected void init() {
        int startY;
        int centerX = this.width / 2;
        int currentY = startY = 60;
        int buttonWidth = 90;
        int buttonSpacing = 10;
        int totalWidth = buttonWidth * 2 + buttonSpacing;
        int buttonStartX = centerX - totalWidth / 2;
        this.agreeButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2191 Upvote").withStyle(style -> style.withColor(0x55FF55)), button -> this.selectAgreement(SubmissionReview.ReviewAgreement.AGREE)).bounds(buttonStartX, currentY, buttonWidth, 20).build());
        this.disagreeButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2193 Downvote").withStyle(style -> style.withColor(0xFF5555)), button -> this.selectAgreement(SubmissionReview.ReviewAgreement.DISAGREE)).bounds(buttonStartX + buttonWidth + buttonSpacing, currentY, buttonWidth, 20).build());
        this.notesField = new EditBox(this.font, centerX - 110, currentY += 38, 220, 40, (Component)Component.literal((String)"Notes"));
        this.notesField.setMaxLength(512);
        this.notesField.setHint((Component)Component.literal((String)"Your comments on this rating..."));
        this.addRenderableWidget((GuiEventListener)this.notesField);
        int submitButtonWidth = 105;
        this.submitButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Submit Review"), button -> this.submitReview()).bounds(centerX - 110, currentY += 68, submitButtonWidth, 20).build());
        this.submitButton.active = false;
        this.cancelButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), button -> Minecraft.getInstance().setScreen(this.parentScreen)).bounds(centerX - 110 + submitButtonWidth + 10, currentY, submitButtonWidth, 20).build());
        this.updateButtonStates();
    }

    private void selectAgreement(SubmissionReview.ReviewAgreement agreement) {
        this.selectedAgreement = agreement;
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        this.updateAgreementButtonAppearance(this.agreeButton, SubmissionReview.ReviewAgreement.AGREE);
        this.updateAgreementButtonAppearance(this.disagreeButton, SubmissionReview.ReviewAgreement.DISAGREE);
        this.submitButton.active = this.selectedAgreement != null;
    }

    private void updateAgreementButtonAppearance(Button button, SubmissionReview.ReviewAgreement agreement) {
        boolean isSelected = this.selectedAgreement == agreement;
        String arrow = agreement == SubmissionReview.ReviewAgreement.AGREE ? "\u2191" : "\u2193";
        Object text = agreement == SubmissionReview.ReviewAgreement.AGREE ? "Upvote" : "Downvote";
        text = isSelected ? "[" + arrow + " " + (String)text + "]" : arrow + " " + (String)text;
        Object finalText = text;
        button.setMessage((Component)Component.literal((String)finalText).withStyle(style -> style.withColor(agreement.getColor())));
    }

    private void submitReview() {
        if (this.selectedAgreement == null) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new DamageAssessmentNetworkHandler.SubmitReviewPacket(this.entry.entryId(), this.selectedAgreement, null, this.notesField.getValue().trim(), this.isAdmin), (CustomPacketPayload[])new CustomPacketPayload[0]);
        Minecraft.getInstance().setScreen(this.parentScreen);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        int centerX = this.width / 2;
        graphics.drawCenteredString(this.font, this.title, centerX, 15, 0xFFFFFF);
        String ratingText = this.entry.rating().getDisplayName();
        String entryInfo = "\u00a7fRating: \u00a7" + this.getRatingColorCode(this.entry.rating()) + ratingText + " \u00a7fBy: " + this.entry.submitterName();
        graphics.drawCenteredString(this.font, entryInfo, centerX, 32, 0xFFFFFF);
        graphics.drawCenteredString(this.font, "Do you agree with this rating?", centerX, 48, 0xAAAAAA);
        graphics.drawString(this.font, "Comments (optional):", centerX - 110, this.notesField.getY() - 12, 0xAAAAAA);
        int upvotes = this.entry.upvoteCount();
        int downvotes = this.entry.downvoteCount();
        if (upvotes > 0 || downvotes > 0) {
            String reviewInfo = "\u00a7a\u2191" + upvotes + " \u00a7c\u2193" + downvotes;
            graphics.drawCenteredString(this.font, reviewInfo, centerX, this.height - 20, 0xFFFFFF);
        }
    }

    private char getRatingColorCode(TornadoRating rating) {
        return switch (rating) {
            case TornadoRating.EF0 -> 'a';
            case TornadoRating.EF1 -> 'e';
            case TornadoRating.EF2 -> '6';
            case TornadoRating.EF3 -> 'c';
            case TornadoRating.EF4 -> '4';
            case TornadoRating.EF5 -> '5';
            default -> 'f';
        };
    }

    public boolean isPauseScreen() {
        return false;
    }
}

