/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.client;

import dev.wxmc.weatheraddon.ClientConfig;
import dev.wxmc.weatheraddon.client.TickableSirenSound;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SirenSoundManager {
    private static final Map<BlockPos, TickableSirenSound> ACTIVE_SIRENS = new ConcurrentHashMap<BlockPos, TickableSirenSound>();

    public static void startSiren(BlockPos pos, int frequencyOrdinal) {
        if (!ClientConfig.areSirensEnabled()) {
            return;
        }
        SirenSoundManager.stopSiren(pos);
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        double distance = mc.player.position().distanceTo(new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5));
        if (distance > (double)ClientConfig.getMaxRange()) {
            return;
        }
        TickableSirenSound soundInstance = new TickableSirenSound(pos, frequencyOrdinal);
        ACTIVE_SIRENS.put(pos, soundInstance);
        mc.getSoundManager().play((SoundInstance)soundInstance);
    }

    public static void stopSiren(BlockPos pos) {
        TickableSirenSound soundInstance = ACTIVE_SIRENS.remove(pos);
        if (soundInstance != null) {
            soundInstance.markStopping();
            Minecraft.getInstance().getSoundManager().stop((SoundInstance)soundInstance);
        }
    }

    public static void stopAllSirens() {
        Minecraft mc = Minecraft.getInstance();
        for (TickableSirenSound sound : new ArrayList<TickableSirenSound>(ACTIVE_SIRENS.values())) {
            sound.markStopping();
            mc.getSoundManager().stop((SoundInstance)sound);
        }
        ACTIVE_SIRENS.clear();
    }

    public static boolean isPlayingAt(BlockPos pos) {
        return ACTIVE_SIRENS.containsKey(pos);
    }
}

