/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.wxmc.weatheraddon.ClientConfig;
import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import dev.wxmc.weatheraddon.warnings.AlertPolygon;
import dev.wxmc.weatheraddon.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class RadarPolygonWorldRenderer {
    private static final RadarPolygonWorldRenderer INSTANCE = new RadarPolygonWorldRenderer();
    private static final Map<BlockPos, List<AlertPolygon>> radarPolygons = new ConcurrentHashMap<BlockPos, List<AlertPolygon>>();
    private static final Set<BlockPos> knownRadarPositions = ConcurrentHashMap.newKeySet();
    private static final float RENDER_HEIGHT = 1.05f;
    private static final double RADAR_RANGE = 1024.0;
    private static int frameCounter = 0;

    public static RadarPolygonWorldRenderer getInstance() {
        return INSTANCE;
    }

    public static void updateRadarPosition(BlockPos radarPos, boolean exists) {
        if (exists) {
            knownRadarPositions.add(radarPos);
        } else {
            knownRadarPositions.remove(radarPos);
            radarPolygons.remove(radarPos);
        }
    }

    public static void updatePolygons(BlockPos radarPos, List<AlertPolygon> polygons) {
        WXMCDebugLogger.debug("[RENDERER] updatePolygons: radarPos={}, count={}", radarPos, polygons != null ? polygons.size() : 0);
        if (polygons == null || polygons.isEmpty()) {
            radarPolygons.remove(radarPos);
            WXMCDebugLogger.debug("[RENDERER] Cleared polygons for radar at {}", radarPos);
        } else {
            radarPolygons.put(radarPos, new ArrayList<AlertPolygon>(polygons));
            WXMCDebugLogger.debug("[RENDERER] Stored {} polygons for radar at {}", polygons.size(), radarPos);
        }
        if (polygons != null && !polygons.isEmpty()) {
            knownRadarPositions.add(radarPos);
        }
        WXMCDebugLogger.debug("[RENDERER] Total state: {} radars, {} total polygons", knownRadarPositions.size(), RadarPolygonWorldRenderer.getPolygonCount());
    }

    public static void clearAll() {
        radarPolygons.clear();
        knownRadarPositions.clear();
    }

    public static int getRadarCount() {
        return knownRadarPositions.size();
    }

    public static int getPolygonCount() {
        return radarPolygons.values().stream().mapToInt(List::size).sum();
    }

    @SubscribeEvent
    public void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        if (++frameCounter >= 300) {
            frameCounter = 0;
            WXMCDebugLogger.debug("[RENDER] Status: {} known radars, {} total polygons, map size={}", knownRadarPositions.size(), RadarPolygonWorldRenderer.getPolygonCount(), radarPolygons.size());
        }
        if (radarPolygons.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Camera camera = event.getCamera();
        PoseStack poseStack = event.getPoseStack();
        double camX = camera.getPosition().x;
        double camY = camera.getPosition().y;
        double camZ = camera.getPosition().z;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableCull();
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder buf = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        for (Map.Entry<BlockPos, List<AlertPolygon>> entry : radarPolygons.entrySet()) {
            BlockPos radarPos = entry.getKey();
            List<AlertPolygon> polygons = entry.getValue();
            if (polygons == null || polygons.isEmpty()) continue;
            double worldX = (double)radarPos.getX() + 0.5 - camX;
            double worldY = (double)((float)radarPos.getY() + 1.05f) - camY;
            double worldZ = (double)radarPos.getZ() + 0.5 - camZ;
            for (AlertPolygon poly : polygons) {
                try {
                    this.renderPolygon(buf, poly, worldX, worldY, worldZ);
                }
                catch (Exception e) {
                    WXMCWeatherAddon.LOGGER.warn("Failed to render polygon for storm {}: {}", (Object)poly.stormId, (Object)e.getMessage());
                }
            }
        }
        MeshData mesh = buf.build();
        if (mesh != null) {
            poseStack.pushPose();
            Matrix4f matrix = poseStack.last().pose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BufferUploader.drawWithShader((MeshData)mesh);
            poseStack.popPose();
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    private void renderPolygon(BufferBuilder buf, AlertPolygon poly, double baseX, double baseY, double baseZ) {
        double offsetX = (poly.centerX - 0.5) * 2.0;
        double offsetZ = (poly.centerZ - 0.5) * 2.0;
        float worldX = (float)(baseX + offsetX);
        float worldY = (float)baseY;
        float worldZ = (float)(baseZ + offsetZ);
        float halfW = Math.max(poly.halfWidth, 0.05f);
        float halfH = Math.max(poly.halfHeight, 0.05f);
        float rotationRad = (float)Math.toRadians(poly.rotationDeg + 180.0f);
        float cos = (float)Math.cos(rotationRad);
        float sin = (float)Math.sin(rotationRad);
        Vector3f[] corners = new Vector3f[4];
        if (poly.stormType == 0) {
            float trapFactor = 0.36f;
            float frontHW = halfW * (1.0f - trapFactor);
            float backHW = halfW * (1.0f + trapFactor);
            corners[0] = this.rotatePoint(-frontHW, -halfH, cos, sin, worldX, worldY, worldZ);
            corners[1] = this.rotatePoint(frontHW, -halfH, cos, sin, worldX, worldY, worldZ);
            corners[2] = this.rotatePoint(backHW, halfH, cos, sin, worldX, worldY, worldZ);
            corners[3] = this.rotatePoint(-backHW, halfH, cos, sin, worldX, worldY, worldZ);
        } else {
            float rot90 = (float)Math.toRadians(poly.rotationDeg + 90.0f);
            float cos90 = (float)Math.cos(rot90);
            float sin90 = (float)Math.sin(rot90);
            corners[0] = this.rotatePoint(-halfW, -halfH, cos90, sin90, worldX, worldY, worldZ);
            corners[1] = this.rotatePoint(halfW, -halfH, cos90, sin90, worldX, worldY, worldZ);
            corners[2] = this.rotatePoint(halfW, halfH, cos90, sin90, worldX, worldY, worldZ);
            corners[3] = this.rotatePoint(-halfW, halfH, cos90, sin90, worldX, worldY, worldZ);
        }
        float[] color = this.getPolygonColor(poly);
        this.renderPolygonOutline(buf, corners, color[0], color[1], color[2], color[3]);
    }

    private Vector3f rotatePoint(float x, float z, float cos, float sin, float offsetX, float offsetY, float offsetZ) {
        float rotX = x * cos - z * sin;
        float rotZ = x * sin + z * cos;
        return new Vector3f(rotX + offsetX, offsetY, rotZ + offsetZ);
    }

    private float[] getPolygonColor(AlertPolygon poly) {
        WarningLevel level = poly.getWarningLevel();
        int color = switch (level) {
            case WarningLevel.STATEMENT -> ClientConfig.getStatementColor();
            case WarningLevel.SVR_WARNING -> ClientConfig.getSvrWarningColor();
            case WarningLevel.SVR_PDS -> ClientConfig.getSvrPdsColor();
            case WarningLevel.SVR_DESTRUCTIVE -> ClientConfig.getSvrDestructiveColor();
            case WarningLevel.TOR_INDICATED -> ClientConfig.getTorIndicatedColor();
            case WarningLevel.TOR_CONFIRMED -> ClientConfig.getTorConfirmedColor();
            case WarningLevel.TOR_PDS -> ClientConfig.getTorPdsColor();
            case WarningLevel.TOR_EMERGENCY -> ClientConfig.getTorEmergencyColor();
            default -> level.getColor();
        };
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = ClientConfig.getPolygonOpacity();
        return new float[]{r, g, b, a};
    }

    private void renderPolygonOutline(BufferBuilder buf, Vector3f[] corners, float r, float g, float b, float a) {
        float lineWidth = ClientConfig.getPolygonLineWidth();
        for (int i = 0; i < 4; ++i) {
            Vector3f start = corners[i];
            Vector3f end = corners[(i + 1) % 4];
            float dx = end.x - start.x;
            float dz = end.z - start.z;
            float length = (float)Math.sqrt(dx * dx + dz * dz);
            if ((double)length < 1.0E-5) continue;
            float invLength = 1.0f / length;
            float dirX = dx * invLength;
            float dirZ = dz * invLength;
            float perpX = -dirZ * lineWidth;
            float perpZ = dirX * lineWidth;
            float extension = lineWidth / 2.0f;
            Vector3f extStart = new Vector3f(start.x - dirX * extension, start.y, start.z - dirZ * extension);
            Vector3f extEnd = new Vector3f(end.x + dirX * extension, end.y, end.z + dirZ * extension);
            buf.addVertex(extStart.x + perpX, extStart.y, extStart.z + perpZ).setColor(r, g, b, a);
            buf.addVertex(extEnd.x + perpX, extEnd.y, extEnd.z + perpZ).setColor(r, g, b, a);
            buf.addVertex(extEnd.x - perpX, extEnd.y, extEnd.z - perpZ).setColor(r, g, b, a);
            buf.addVertex(extStart.x - perpX, extStart.y, extStart.z - perpZ).setColor(r, g, b, a);
            buf.addVertex(extStart.x + perpX, extStart.y, extStart.z + perpZ).setColor(r, g, b, a);
            buf.addVertex(extStart.x - perpX, extStart.y, extStart.z - perpZ).setColor(r, g, b, a);
            buf.addVertex(extEnd.x - perpX, extEnd.y, extEnd.z - perpZ).setColor(r, g, b, a);
            buf.addVertex(extEnd.x + perpX, extEnd.y, extEnd.z + perpZ).setColor(r, g, b, a);
        }
    }
}

