/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.client;

import dev.wxmc.weatheraddon.client.ColorTableSelectionScreen;
import dev.wxmc.weatheraddon.client.VelocityColorTableSelectionScreen;
import java.net.URI;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class RadarConfiguratorScreen
extends Screen {
    private static final int BUTTON_WIDTH = 180;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_SPACING = 28;
    private static final int TITLE_COLOR = 0xFFFFFF;
    private static final String WXTOOLS_URL = "https://www.wxtools.org/";

    public RadarConfiguratorScreen() {
        super((Component)Component.literal((String)"Radar Configurator"));
    }

    protected void init() {
        int centerX = (this.width - 180) / 2;
        int centerY = this.height / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Reflectivity"), button -> this.openReflectivityScreen()).bounds(centerX, centerY - 28, 180, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Velocity"), button -> this.openVelocityScreen()).bounds(centerX, centerY, 180, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Done"), button -> this.onClose()).bounds(centerX, centerY + 28 + 10, 180, 20).build());
        int creditButtonWidth = 250;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Thank you wxtools.org for the color tables").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC), button -> this.openWxTools()).bounds((this.width - creditButtonWidth) / 2, this.height - 50, creditButtonWidth, 20).build());
    }

    private void openReflectivityScreen() {
        Minecraft.getInstance().setScreen((Screen)new ColorTableSelectionScreen(this));
    }

    private void openVelocityScreen() {
        Minecraft.getInstance().setScreen((Screen)new VelocityColorTableSelectionScreen(this));
    }

    private void openWxTools() {
        Util.getPlatform().openUri(URI.create(WXTOOLS_URL));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 40, 0xFFFFFF);
        graphics.drawCenteredString(this.font, (Component)Component.literal((String)"Select color table type to configure"), this.width / 2, 55, 0xAAAAAA);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

