/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.client;

import dev.wxmc.weatheraddon.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.ModConfigSpec;

@OnlyIn(value=Dist.CLIENT)
public class PolygonConfigScreen
extends Screen {
    private final Screen parentScreen;
    private final List<ColorEntry> colorEntries = new ArrayList<ColorEntry>();
    private EditBox opacityField;
    private EditBox lineWidthField;
    private Button sirensEnabledButton;
    private EditBox sirenVolumeField;
    private EditBox sirenRangeField;
    private boolean sirensEnabled;
    private static final String DEFAULT_STATEMENT = "FFE4B5";
    private static final String DEFAULT_SVR = "FFA500";
    private static final String DEFAULT_TOR = "FF0000";

    public PolygonConfigScreen(Screen parent) {
        super((Component)Component.literal((String)"WXMC Weather Addon Settings"));
        this.parentScreen = parent;
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        int y = 28;
        this.sirensEnabled = ClientConfig.areSirensEnabled();
        int toggleWidth = 50;
        this.sirensEnabledButton = Button.builder((Component)Component.literal((String)(this.sirensEnabled ? "ON" : "OFF")), button -> {
            this.sirensEnabled = !this.sirensEnabled;
            button.setMessage((Component)Component.literal((String)(this.sirensEnabled ? "ON" : "OFF")));
        }).bounds(centerX - 80 + 60, y, toggleWidth, 16).build();
        this.addRenderableWidget((GuiEventListener)this.sirensEnabledButton);
        this.sirenVolumeField = new EditBox(this.font, centerX + 30, y, 45, 16, (Component)Component.empty());
        try {
            this.sirenVolumeField.setValue(String.format("%.1f", ClientConfig.SIREN_MAX_VOLUME.get()));
        }
        catch (Exception e) {
            this.sirenVolumeField.setValue("4.0");
        }
        this.sirenVolumeField.setMaxLength(4);
        this.addRenderableWidget((GuiEventListener)this.sirenVolumeField);
        this.sirenRangeField = new EditBox(this.font, centerX + 30, y += 22, 45, 16, (Component)Component.empty());
        try {
            this.sirenRangeField.setValue(String.valueOf(ClientConfig.SIREN_MAX_RANGE.get()));
        }
        catch (Exception e) {
            this.sirenRangeField.setValue("256");
        }
        this.sirenRangeField.setMaxLength(4);
        this.addRenderableWidget((GuiEventListener)this.sirenRangeField);
        int fieldWidth = 55;
        int fieldSpacing = 20;
        int totalFieldsWidth = fieldWidth * 2 + fieldSpacing;
        int fieldsStartX = centerX - totalFieldsWidth / 2;
        this.opacityField = new EditBox(this.font, fieldsStartX, (y += 30) + 10, fieldWidth, 16, (Component)Component.empty());
        this.opacityField.setValue(String.format("%.2f", Float.valueOf(ClientConfig.getPolygonOpacity())));
        this.opacityField.setMaxLength(4);
        this.addRenderableWidget((GuiEventListener)this.opacityField);
        this.lineWidthField = new EditBox(this.font, fieldsStartX + fieldWidth + fieldSpacing, y + 10, fieldWidth, 16, (Component)Component.empty());
        this.lineWidthField.setValue(String.format("%.3f", Float.valueOf(ClientConfig.getPolygonLineWidth())));
        this.lineWidthField.setMaxLength(5);
        this.addRenderableWidget((GuiEventListener)this.lineWidthField);
        y += 55;
        this.colorEntries.clear();
        this.colorEntries.add(new ColorEntry("Statement", ClientConfig.COLOR_STATEMENT, DEFAULT_STATEMENT));
        this.colorEntries.add(new ColorEntry("SVR", ClientConfig.COLOR_SVR_WARNING, DEFAULT_SVR));
        this.colorEntries.add(new ColorEntry("SVR-CNSDRBL", ClientConfig.COLOR_SVR_PDS, DEFAULT_SVR));
        this.colorEntries.add(new ColorEntry("SVR-DST", ClientConfig.COLOR_SVR_DESTRUCTIVE, DEFAULT_SVR));
        this.colorEntries.add(new ColorEntry("TOR-RI", ClientConfig.COLOR_TOR_INDICATED, DEFAULT_TOR));
        this.colorEntries.add(new ColorEntry("TOR-OBS", ClientConfig.COLOR_TOR_CONFIRMED, DEFAULT_TOR));
        this.colorEntries.add(new ColorEntry("TOR-PDS", ClientConfig.COLOR_TOR_PDS, DEFAULT_TOR));
        this.colorEntries.add(new ColorEntry("TOR-EMG", ClientConfig.COLOR_TOR_EMERGENCY, DEFAULT_TOR));
        int rowHeight = 28;
        int labelWidth = 75;
        int colorBoxWidth = 50;
        int swatchWidth = 16;
        int colWidth = labelWidth + colorBoxWidth + swatchWidth + 4;
        int colSpacing = 15;
        int totalColsWidth = colWidth * 2 + colSpacing;
        int col1X = centerX - totalColsWidth / 2;
        int col2X = col1X + colWidth + colSpacing;
        for (int i = 0; i < this.colorEntries.size(); ++i) {
            ColorEntry entry = this.colorEntries.get(i);
            int col = i % 2;
            int row = i / 2;
            int xPos = col == 0 ? col1X : col2X;
            int yPos = y + row * rowHeight;
            EditBox colorBox = new EditBox(this.font, xPos + labelWidth, yPos, colorBoxWidth, 16, (Component)Component.empty());
            colorBox.setValue((String)entry.configValue.get());
            colorBox.setMaxLength(6);
            entry.editBox = colorBox;
            this.addRenderableWidget((GuiEventListener)colorBox);
        }
        int buttonY = this.height - 28;
        int buttonWidth = 80;
        int buttonSpacing = 5;
        int totalButtonWidth = buttonWidth * 3 + buttonSpacing * 2;
        int buttonStartX = centerX - totalButtonWidth / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Save"), button -> this.onDone()).bounds(buttonStartX, buttonY, buttonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Reset"), button -> this.resetDefaults()).bounds(buttonStartX + buttonWidth + buttonSpacing, buttonY, buttonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).bounds(buttonStartX + (buttonWidth + buttonSpacing) * 2, buttonY, buttonWidth, 20).build());
    }

    private void resetDefaults() {
        this.sirensEnabled = true;
        this.sirensEnabledButton.setMessage((Component)Component.literal((String)"ON"));
        this.sirenVolumeField.setValue("4.0");
        this.sirenRangeField.setValue("256");
        this.opacityField.setValue("0.70");
        this.lineWidthField.setValue("0.015");
        for (ColorEntry entry : this.colorEntries) {
            entry.editBox.setValue(entry.defaultHex);
        }
    }

    private void onDone() {
        ClientConfig.SIRENS_ENABLED.set((Object)this.sirensEnabled);
        try {
            double volume = Double.parseDouble(this.sirenVolumeField.getValue());
            volume = Math.max(0.0, Math.min(10.0, volume));
            ClientConfig.SIREN_MAX_VOLUME.set((Object)volume);
        }
        catch (NumberFormatException volume) {
            // empty catch block
        }
        try {
            int range = Integer.parseInt(this.sirenRangeField.getValue());
            range = Math.max(32, Math.min(1024, range));
            ClientConfig.SIREN_MAX_RANGE.set((Object)range);
        }
        catch (NumberFormatException range) {
            // empty catch block
        }
        try {
            double opacity = Double.parseDouble(this.opacityField.getValue());
            opacity = Math.max(0.0, Math.min(1.0, opacity));
            ClientConfig.POLYGON_LINE_OPACITY.set((Object)opacity);
        }
        catch (NumberFormatException opacity) {
            // empty catch block
        }
        try {
            double lineWidth = Double.parseDouble(this.lineWidthField.getValue());
            lineWidth = Math.max(0.005, Math.min(0.1, lineWidth));
            ClientConfig.POLYGON_LINE_WIDTH.set((Object)lineWidth);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (ColorEntry entry : this.colorEntries) {
            String hexValue = entry.editBox.getValue().toUpperCase().replace("#", "");
            if (!this.isValidHexColor(hexValue)) continue;
            entry.configValue.set((Object)hexValue);
        }
        ClientConfig.SPEC.save();
        this.onClose();
    }

    private boolean isValidHexColor(String hex) {
        if (hex.length() != 6) {
            return false;
        }
        try {
            Integer.parseInt(hex, 16);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void onClose() {
        this.minecraft.setScreen(this.parentScreen);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        int centerX = this.width / 2;
        int y = 28;
        graphics.drawCenteredString(this.font, this.title, centerX, 10, 0xFFFFFF);
        graphics.drawString(this.font, "Sirens:", centerX - 80, y + 4, 0xFFFFFF);
        graphics.drawString(this.font, "Volume:", centerX - 20, y + 4, 0xAAAAAA);
        graphics.drawString(this.font, "Max Range:", centerX - 30, (y += 22) + 4, 0xAAAAAA);
        int fieldWidth = 55;
        int fieldSpacing = 20;
        int totalFieldsWidth = fieldWidth * 2 + fieldSpacing;
        int fieldsStartX = centerX - totalFieldsWidth / 2;
        graphics.drawString(this.font, "Opacity", fieldsStartX, y += 30, 0xFFFFFF);
        graphics.drawString(this.font, "Width", fieldsStartX + fieldWidth + fieldSpacing, y, 0xFFFFFF);
        graphics.drawCenteredString(this.font, "Polygon Colors", centerX, (y += 55) - 10, 0xFFFFFF);
        int rowHeight = 28;
        int labelWidth = 75;
        int colorBoxWidth = 50;
        int swatchWidth = 16;
        int colWidth = labelWidth + colorBoxWidth + swatchWidth + 4;
        int colSpacing = 15;
        int totalColsWidth = colWidth * 2 + colSpacing;
        int col1X = centerX - totalColsWidth / 2;
        int col2X = col1X + colWidth + colSpacing;
        for (int i = 0; i < this.colorEntries.size(); ++i) {
            ColorEntry entry = this.colorEntries.get(i);
            int col = i % 2;
            int row = i / 2;
            int xPos = col == 0 ? col1X : col2X;
            int yPos = y + row * rowHeight;
            graphics.drawString(this.font, entry.name, xPos, yPos + 4, 0xFFFFFF);
            int swatchX = xPos + labelWidth + colorBoxWidth + 3;
            int previewColor = this.parseHexSafe(entry.editBox.getValue(), entry.defaultHex);
            graphics.fill(swatchX, yPos, swatchX + swatchWidth, yPos + 16, 0xFF000000 | previewColor);
            graphics.renderOutline(swatchX, yPos, swatchWidth, 16, -7829368);
        }
    }

    private int parseHexSafe(String hex, String defaultHex) {
        try {
            hex = hex.replace("#", "");
            if (hex.length() == 6) {
                return Integer.parseInt(hex, 16);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            return Integer.parseInt(defaultHex, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return 0xFFFFFF;
        }
    }

    private static class ColorEntry {
        final String name;
        final ModConfigSpec.ConfigValue<String> configValue;
        final String defaultHex;
        EditBox editBox;

        ColorEntry(String name, ModConfigSpec.ConfigValue<String> configValue, String defaultHex) {
            this.name = name;
            this.configValue = configValue;
            this.defaultHex = defaultHex;
        }
    }
}

