/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.client;

import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PhotoMetadataClientStorage {
    private static final Map<String, PhotoMetadata> clientMetadata = new ConcurrentHashMap<String, PhotoMetadata>();

    public static void storeMetadata(String photoId, String photographer, int x, int z) {
        if (photoId == null || photoId.isEmpty()) {
            return;
        }
        clientMetadata.put(photoId, new PhotoMetadata(photographer, x, z));
        WXMCDebugLogger.debug("[PhotoMetadata Client] Stored metadata for photo {}: {} at ({}, {})", photoId, photographer, x, z);
    }

    public static PhotoMetadata getMetadata(String photoId) {
        if (photoId == null || photoId.isEmpty()) {
            return null;
        }
        return clientMetadata.get(photoId);
    }

    public static boolean hasMetadata(String photoId) {
        return photoId != null && clientMetadata.containsKey(photoId);
    }

    public static void clear() {
        clientMetadata.clear();
        WXMCDebugLogger.debug("[PhotoMetadata Client] Cleared all cached metadata");
    }

    public static int size() {
        return clientMetadata.size();
    }

    public static class PhotoMetadata {
        private final String photographer;
        private final int x;
        private final int z;

        public PhotoMetadata(String photographer, int x, int z) {
            this.photographer = photographer;
            this.x = x;
            this.z = z;
        }

        public String getPhotographer() {
            return this.photographer;
        }

        public int getX() {
            return this.x;
        }

        public int getZ() {
            return this.z;
        }
    }
}

