/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.client;

import dev.wxmc.weatheraddon.client.SubmissionRatingScreen;
import dev.wxmc.weatheraddon.client.ViewReviewsScreen;
import dev.wxmc.weatheraddon.compat.ExposureCompat;
import dev.wxmc.weatheraddon.data.TornadoEntry;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EntryDetailScreen
extends Screen {
    private static final int TITLE_COLOR = 0xFFFFFF;
    private static final int LABEL_COLOR = 0xAAAAAA;
    private static final int VALUE_COLOR = 0xFFFFFF;
    private static final int PHOTO_SIZE = 64;
    private static final int PHOTO_SPACING = 8;
    private final TornadoEntry entry;
    private final Screen parentScreen;
    private final List<String> photoIds;
    private final boolean isAdmin;
    private int currentPhotoIndex = 0;
    private Button prevPhotoButton;
    private Button nextPhotoButton;
    private String previewPhotoId = null;

    public EntryDetailScreen(TornadoEntry entry, Screen parentScreen) {
        this(entry, parentScreen, false);
    }

    public EntryDetailScreen(TornadoEntry entry, Screen parentScreen, boolean isAdmin) {
        super((Component)Component.literal((String)(isAdmin ? "Entry Details (Admin)" : "Entry Details")));
        this.entry = entry;
        this.parentScreen = parentScreen;
        this.photoIds = entry.photoIds() != null ? new ArrayList<String>(entry.photoIds()) : new ArrayList();
        this.isAdmin = isAdmin;
    }

    protected void init() {
        int centerX = this.width / 2;
        int buttonY = this.height - 35;
        Minecraft mc = Minecraft.getInstance();
        boolean canReview = false;
        if (!this.entry.accepted()) {
            if (this.isAdmin) {
                canReview = mc.player != null;
            } else {
                boolean bl = canReview = mc.player != null && !this.entry.submitterUUID().equals(mc.player.getUUID()) && !this.entry.hasUserReviewed(mc.player.getUUID());
            }
        }
        if (canReview) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Rate Submission"), button -> Minecraft.getInstance().setScreen((Screen)new SubmissionRatingScreen(this.entry, this, this.isAdmin))).bounds(centerX - 70, buttonY - 25, 140, 20).build());
        }
        if (this.isAdmin && this.entry.reviews() != null && !this.entry.reviews().isEmpty()) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("View Reviews (" + this.entry.reviews().size() + ")")), button -> Minecraft.getInstance().setScreen((Screen)new ViewReviewsScreen(this.entry, this))).bounds(centerX - 70, buttonY - 50, 140, 20).build());
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"< Back"), button -> Minecraft.getInstance().setScreen(this.parentScreen)).bounds(centerX - 50, buttonY, 100, 20).build());
        if (!this.photoIds.isEmpty()) {
            int photoAreaY = 145;
            int totalPhotosWidth = Math.min(this.photoIds.size(), 3) * 72 - 8;
            int photoStartX = centerX - totalPhotosWidth / 2 - 30;
            this.prevPhotoButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), button -> {
                if (this.currentPhotoIndex > 0) {
                    --this.currentPhotoIndex;
                    this.updatePhotoButtons();
                }
            }).bounds(photoStartX - 25, photoAreaY + 32 - 10, 20, 20).build());
            this.nextPhotoButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">"), button -> {
                if (this.currentPhotoIndex + 3 < this.photoIds.size()) {
                    ++this.currentPhotoIndex;
                    this.updatePhotoButtons();
                }
            }).bounds(photoStartX + totalPhotosWidth + 5 + 30, photoAreaY + 32 - 10, 20, 20).build());
            this.updatePhotoButtons();
        }
    }

    private void updatePhotoButtons() {
        if (this.prevPhotoButton != null && this.nextPhotoButton != null) {
            this.prevPhotoButton.active = this.currentPhotoIndex > 0;
            this.nextPhotoButton.active = this.currentPhotoIndex + 3 < this.photoIds.size();
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.previewPhotoId != null) {
            this.renderBackground(graphics, mouseX, mouseY, partialTick);
            this.renderPhotoPreviewOverlay(graphics);
            return;
        }
        super.render(graphics, mouseX, mouseY, partialTick);
        int centerX = this.width / 2;
        int y = 20;
        graphics.drawCenteredString(this.font, this.title, centerX, y, 0xFFFFFF);
        int leftCol = centerX - 150;
        int rightCol = centerX + 20;
        int lineHeight = 14;
        graphics.drawString(this.font, "Event ID:", leftCol, y += 20, 0xAAAAAA);
        graphics.drawString(this.font, this.entry.eventId(), leftCol + 60, y, 0xFFFFFF);
        graphics.drawString(this.font, "Rating:", leftCol, y += lineHeight, 0xAAAAAA);
        graphics.drawString(this.font, this.entry.rating().getFullDisplay(), leftCol + 60, y, this.entry.rating().getColor());
        graphics.drawString(this.font, "Windspeed:", leftCol, y += lineHeight, 0xAAAAAA);
        String windspeed = this.entry.windspeedEst().isEmpty() ? "N/A" : this.entry.windspeedEst();
        graphics.drawString(this.font, windspeed, leftCol + 60, y, 0xFFFFFF);
        graphics.drawString(this.font, "Coords:", leftCol, y += lineHeight, 0xAAAAAA);
        graphics.drawString(this.font, this.entry.coordX() + ", " + this.entry.coordZ(), leftCol + 60, y, 0xFFFFFF);
        y += lineHeight;
        y = 40;
        graphics.drawString(this.font, "Submitter:", rightCol, y, 0xAAAAAA);
        graphics.drawString(this.font, this.entry.submitterName(), rightCol + 60, y, 0xFFFFFF);
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        graphics.drawString(this.font, "Date:", rightCol, y += lineHeight, 0xAAAAAA);
        graphics.drawString(this.font, dateFormat.format(new Date(this.entry.timestamp())), rightCol + 60, y, 0xFFFFFF);
        graphics.drawString(this.font, "Photos:", rightCol, y += lineHeight, 0xAAAAAA);
        int photoCount = this.photoIds.size();
        graphics.drawString(this.font, String.valueOf(photoCount), rightCol + 60, y, photoCount >= 3 ? 0x55FF55 : 0xFFFFFF);
        y += lineHeight;
        y = 100;
        graphics.drawString(this.font, "Notes:", leftCol, y, 0xAAAAAA);
        y += lineHeight;
        String notes = this.entry.notes().isEmpty() ? "(No notes)" : this.entry.notes();
        List<String> wrappedNotes = this.wrapText(notes, 300);
        for (String line : wrappedNotes) {
            graphics.drawString(this.font, line, leftCol, y, 0xFFFFFF);
            if ((y += 10) <= 140) continue;
            break;
        }
        y = 145;
        graphics.drawCenteredString(this.font, "Attached Photos", centerX, y - 15, 0xFFFFFF);
        if (this.photoIds.isEmpty()) {
            graphics.drawCenteredString(this.font, "No photos attached", centerX, y + 32, 0x888888);
        } else {
            int photoIndex;
            int photosToShow = Math.min(3, this.photoIds.size());
            int totalPhotosWidth = photosToShow * 72 - 8;
            int photoStartX = centerX - totalPhotosWidth / 2;
            for (int i = 0; i < photosToShow && (photoIndex = this.currentPhotoIndex + i) < this.photoIds.size(); ++i) {
                ItemStack photoStack;
                int slotX = photoStartX + i * 72;
                int slotY = y;
                graphics.fill(slotX, slotY, slotX + 64, slotY + 64, Integer.MIN_VALUE);
                graphics.renderOutline(slotX, slotY, 64, 64, -11184811);
                String photoId = this.photoIds.get(photoIndex);
                boolean rendered = false;
                if (ExposureCompat.isExposureLoaded() && photoId != null && !(photoStack = ExposureCompat.createPhotographFromId(photoId)).isEmpty()) {
                    rendered = ExposureCompat.renderPhotographInGui(graphics, photoStack, slotX, slotY, 64);
                }
                if (rendered) continue;
                graphics.drawCenteredString(this.font, "[Photo]", slotX + 32, slotY + 32 - 8, 0xAAAAAA);
                graphics.drawCenteredString(this.font, "#" + (photoIndex + 1), slotX + 32, slotY + 32 + 4, 0x888888);
            }
            if (this.photoIds.size() > 3) {
                String indicator = String.format("Showing %d-%d of %d", this.currentPhotoIndex + 1, Math.min(this.currentPhotoIndex + 3, this.photoIds.size()), this.photoIds.size());
                graphics.drawCenteredString(this.font, indicator, centerX, y + 64 + 5, 0x888888);
            }
            graphics.drawCenteredString(this.font, "Click a photo to enlarge", centerX, y + 64 + 18, 0x666666);
        }
    }

    private void renderPhotoPreviewOverlay(GuiGraphics graphics) {
        ItemStack photoStack;
        graphics.fill(0, 0, this.width, this.height, -16777216);
        int previewSize = 192;
        int previewX = (this.width - previewSize) / 2;
        int previewY = (this.height - previewSize) / 2 - 10;
        graphics.drawCenteredString(this.font, "Photo Preview", this.width / 2, previewY - 25, 0xFFFFFF);
        graphics.fill(previewX - 4, previewY - 4, previewX + previewSize + 4, previewY + previewSize + 4, -10066330);
        graphics.fill(previewX - 2, previewY - 2, previewX + previewSize + 2, previewY + previewSize + 2, -13421773);
        graphics.fill(previewX, previewY, previewX + previewSize, previewY + previewSize, -15066598);
        boolean renderedPhoto = false;
        if (ExposureCompat.isExposureLoaded() && this.previewPhotoId != null && !(photoStack = ExposureCompat.createPhotographFromId(this.previewPhotoId)).isEmpty()) {
            renderedPhoto = ExposureCompat.renderPhotographInGui(graphics, photoStack, previewX, previewY, previewSize);
        }
        if (!renderedPhoto) {
            graphics.drawCenteredString(this.font, "[Photo Unavailable]", this.width / 2, previewY + previewSize / 2, 0xAAAAAA);
        }
        graphics.drawCenteredString(this.font, "Click anywhere or press ESC to close", this.width / 2, previewY + previewSize + 15, 0xAAAAAA);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.previewPhotoId != null) {
            this.previewPhotoId = null;
            return true;
        }
        if (button == 0 && !this.photoIds.isEmpty()) {
            int photoIndex;
            int centerX = this.width / 2;
            int y = 145;
            int photosToShow = Math.min(3, this.photoIds.size());
            int totalPhotosWidth = photosToShow * 72 - 8;
            int photoStartX = centerX - totalPhotosWidth / 2;
            for (int i = 0; i < photosToShow && (photoIndex = this.currentPhotoIndex + i) < this.photoIds.size(); ++i) {
                int slotX = photoStartX + i * 72;
                int slotY = y;
                if (!(mouseX >= (double)slotX) || !(mouseX < (double)(slotX + 64)) || !(mouseY >= (double)slotY) || !(mouseY < (double)(slotY + 64))) continue;
                this.previewPhotoId = this.photoIds.get(photoIndex);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.previewPhotoId != null && keyCode == 256) {
            this.previewPhotoId = null;
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        for (String word : text.split(" ")) {
            if (this.font.width(String.valueOf(currentLine) + word) > maxWidth && currentLine.length() > 0) {
                lines.add(currentLine.toString().trim());
                currentLine = new StringBuilder();
            }
            currentLine.append(word).append(" ");
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString().trim());
        }
        return lines;
    }

    public boolean isPauseScreen() {
        return false;
    }
}

