/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.client;

import dev.wxmc.weatheraddon.compat.ExposureCompat;
import dev.wxmc.weatheraddon.data.TornadoRating;
import dev.wxmc.weatheraddon.network.DamageAssessmentNetworkHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class DamageAssessmentScreen
extends Screen {
    private static final int FIELD_WIDTH = 200;
    private static final int FIELD_HEIGHT = 20;
    private static final int ROW_SPACING = 25;
    private static final int LABEL_FIELD_GAP = 8;
    private static final int PHOTO_SLOT_SIZE = 32;
    private static final int PHOTO_SPACING = 4;
    private static final int MIN_PHOTOS_REQUIRED = 3;
    private static final int MAX_PHOTOS = 6;
    private static final int TITLE_COLOR = 0xFFFFFF;
    private static final int LABEL_COLOR = 0xFFFFFF;
    private EditBox eventIdField;
    private Button ratingButton;
    private EditBox windspeedField;
    private EditBox coordXField;
    private EditBox coordZField;
    private EditBox notesField;
    private Button addPhotoButton;
    private Button submitButton;
    private Button cancelButton;
    private TornadoRating selectedRating = TornadoRating.EF0;
    private int eventIdY;
    private int ratingY;
    private int windspeedY;
    private int coordsY;
    private int notesY;
    private int photosY;
    private int photoSlotsY;
    private int addPhotoButtonY;
    private final List<ItemStack> selectedPhotos = new ArrayList<ItemStack>();
    private final List<String> selectedPhotoIds = new ArrayList<String>();
    private boolean selectingPhotos = false;
    private List<ItemStack> availablePhotos = new ArrayList<ItemStack>();
    private ItemStack previewPhoto = null;

    public DamageAssessmentScreen() {
        super((Component)Component.literal((String)"Damage Assessment Toolkit"));
    }

    protected void init() {
        int startY;
        int currentY;
        int centerX = (this.width - 200) / 2;
        this.eventIdY = currentY = (startY = 20);
        this.eventIdField = new EditBox(this.font, centerX, currentY += 8, 200, 20, (Component)Component.literal((String)"Event ID"));
        this.eventIdField.setMaxLength(64);
        this.eventIdField.setHint((Component)Component.literal((String)"Enter Event ID..."));
        this.addRenderableWidget((GuiEventListener)this.eventIdField);
        this.ratingY = currentY += 25;
        this.ratingButton = Button.builder((Component)Component.literal((String)this.selectedRating.getFullDisplay()).withStyle(style -> style.withColor(this.selectedRating.getColor())), button -> this.cycleRating()).bounds(centerX, currentY += 8, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.ratingButton);
        this.windspeedY = currentY += 25;
        this.windspeedField = new EditBox(this.font, centerX, currentY += 8, 200, 20, (Component)Component.literal((String)"Windspeed Est."));
        this.windspeedField.setMaxLength(32);
        this.windspeedField.setHint((Component)Component.literal((String)"e.g., 120 mph"));
        this.addRenderableWidget((GuiEventListener)this.windspeedField);
        this.coordsY = currentY += 25;
        int halfWidth = 95;
        this.coordXField = new EditBox(this.font, centerX, currentY += 16, halfWidth, 20, (Component)Component.literal((String)"X"));
        this.coordXField.setMaxLength(10);
        if (Minecraft.getInstance().player != null) {
            this.coordXField.setValue(String.valueOf((int)Minecraft.getInstance().player.getX()));
        }
        this.addRenderableWidget((GuiEventListener)this.coordXField);
        this.coordZField = new EditBox(this.font, centerX + halfWidth + 10, currentY, halfWidth, 20, (Component)Component.literal((String)"Z"));
        this.coordZField.setMaxLength(10);
        if (Minecraft.getInstance().player != null) {
            this.coordZField.setValue(String.valueOf((int)Minecraft.getInstance().player.getZ()));
        }
        this.addRenderableWidget((GuiEventListener)this.coordZField);
        this.notesY = currentY += 25;
        this.notesField = new EditBox(this.font, centerX, currentY += 8, 200, 20, (Component)Component.literal((String)"Notes"));
        this.notesField.setMaxLength(512);
        this.notesField.setHint((Component)Component.literal((String)"Personal notes..."));
        this.addRenderableWidget((GuiEventListener)this.notesField);
        this.photosY = currentY += 25;
        this.photoSlotsY = currentY += 10;
        this.addPhotoButtonY = currentY += 40;
        this.addPhotoButton = Button.builder((Component)Component.literal((String)"+ Add Photos"), button -> this.openPhotoSelector()).bounds(centerX, currentY, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.addPhotoButton);
        int buttonY = this.height - 30;
        int buttonWidth = 95;
        this.submitButton = Button.builder((Component)Component.literal((String)"Submit"), button -> this.submitAssessment()).bounds(centerX, buttonY, buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.submitButton);
        this.cancelButton = Button.builder((Component)Component.literal((String)"Cancel"), button -> this.onClose()).bounds(centerX + buttonWidth + 10, buttonY, buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.cancelButton);
        this.updateSubmitButton();
    }

    private void cycleRating() {
        TornadoRating[] ratings = TornadoRating.values();
        int nextIndex = (this.selectedRating.ordinal() + 1) % ratings.length;
        this.selectedRating = ratings[nextIndex];
        this.ratingButton.setMessage((Component)Component.literal((String)this.selectedRating.getFullDisplay()).withStyle(style -> style.withColor(this.selectedRating.getColor())));
    }

    private void openPhotoSelector() {
        if (!ExposureCompat.isExposureLoaded()) {
            if (Minecraft.getInstance().player != null) {
                Minecraft.getInstance().player.sendSystemMessage((Component)Component.literal((String)"\u00a7cExposure mod is required to attach photos."));
            }
            return;
        }
        boolean bl = this.selectingPhotos = !this.selectingPhotos;
        if (this.selectingPhotos) {
            if (Minecraft.getInstance().player != null) {
                this.availablePhotos = ExposureCompat.getPhotographsFromInventory((Player)Minecraft.getInstance().player);
            }
            this.addPhotoButton.setMessage((Component)Component.literal((String)"Done Selecting"));
        } else {
            this.addPhotoButton.setMessage((Component)Component.literal((String)"+ Add Photos"));
        }
    }

    private void addPhoto(ItemStack photo) {
        if (this.selectedPhotos.size() >= 6) {
            return;
        }
        String photoId = ExposureCompat.getPhotoId(photo);
        if (photoId != null && !this.selectedPhotoIds.contains(photoId)) {
            this.selectedPhotos.add(photo.copy());
            this.selectedPhotoIds.add(photoId);
            this.updateSubmitButton();
        }
    }

    private void removePhoto(int index) {
        if (index >= 0 && index < this.selectedPhotos.size()) {
            this.selectedPhotos.remove(index);
            this.selectedPhotoIds.remove(index);
            this.updateSubmitButton();
        }
    }

    private void updateSubmitButton() {
        boolean hasEnoughPhotos;
        this.submitButton.active = hasEnoughPhotos = this.selectedPhotos.size() >= 3 || !ExposureCompat.isExposureLoaded();
    }

    private void submitAssessment() {
        int z;
        int x;
        try {
            x = Integer.parseInt(this.coordXField.getValue().trim());
            z = Integer.parseInt(this.coordZField.getValue().trim());
        }
        catch (NumberFormatException e) {
            if (Minecraft.getInstance().player != null) {
                Minecraft.getInstance().player.sendSystemMessage((Component)Component.literal((String)"\u00a7cInvalid coordinates. Please enter valid numbers."));
            }
            return;
        }
        if (this.eventIdField.getValue().trim().isEmpty()) {
            if (Minecraft.getInstance().player != null) {
                Minecraft.getInstance().player.sendSystemMessage((Component)Component.literal((String)"\u00a7cEvent ID is required."));
            }
            return;
        }
        if (ExposureCompat.isExposureLoaded() && this.selectedPhotoIds.size() < 3) {
            if (Minecraft.getInstance().player != null) {
                Minecraft.getInstance().player.sendSystemMessage((Component)Component.literal((String)"\u00a7cAt least 3 photos are required."));
            }
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new DamageAssessmentNetworkHandler.SubmitAssessmentPacket(this.eventIdField.getValue().trim(), this.selectedRating, this.windspeedField.getValue().trim(), x, z, this.notesField.getValue().trim(), new ArrayList<String>(this.selectedPhotoIds)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.onClose();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.previewPhoto != null) {
            this.renderBackground(graphics, mouseX, mouseY, partialTick);
            this.renderPhotoPreviewOverlay(graphics);
            return;
        }
        super.render(graphics, mouseX, mouseY, partialTick);
        int centerX = (this.width - 200) / 2;
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 8, 0xFFFFFF);
        graphics.drawCenteredString(this.font, "Event ID:", this.width / 2, this.eventIdY, 0xFFFFFF);
        graphics.drawCenteredString(this.font, "Tornado Rating:", this.width / 2, this.ratingY, 0xFFFFFF);
        graphics.drawCenteredString(this.font, "Windspeed Est.:", this.width / 2, this.windspeedY, 0xFFFFFF);
        int halfWidth = 95;
        int coordLabelY = this.coordsY + 8;
        graphics.drawString(this.font, "X:", centerX, coordLabelY, 0xFFFFFF);
        graphics.drawCenteredString(this.font, "Coordinates:", this.width / 2, coordLabelY, 0xFFFFFF);
        int zLabelWidth = this.font.width("Z:");
        graphics.drawString(this.font, "Z:", centerX + halfWidth + 10 + halfWidth - zLabelWidth, coordLabelY, 0xFFFFFF);
        graphics.drawCenteredString(this.font, "Notes:", this.width / 2, this.notesY, 0xFFFFFF);
        String photosLabel = "Photos: " + this.selectedPhotos.size() + "/3 min (click to preview)";
        int photosColor = this.selectedPhotos.size() >= 3 ? 0x55FF55 : 0xFF5555;
        graphics.drawCenteredString(this.font, photosLabel, this.width / 2, this.photosY, photosColor);
        int totalPhotoWidth = 212;
        int photoStartX = (this.width - totalPhotoWidth) / 2;
        for (int i = 0; i < 6; ++i) {
            int slotX = photoStartX + i * 36;
            int slotY = this.photoSlotsY;
            graphics.fill(slotX, slotY, slotX + 32, slotY + 32, Integer.MIN_VALUE);
            graphics.renderOutline(slotX, slotY, 32, 32, -11184811);
            if (i < this.selectedPhotos.size()) {
                ItemStack photo = this.selectedPhotos.get(i);
                int itemX = slotX + 8;
                int itemY = slotY + 8;
                graphics.renderItem(photo, itemX, itemY);
                int xButtonX = slotX + 32 - 9;
                int xButtonY = slotY + 1;
                graphics.fill(xButtonX - 1, xButtonY - 1, xButtonX + 8, xButtonY + 8, -5636096);
                graphics.drawString(this.font, "x", xButtonX, xButtonY, 0xFFFFFF);
                continue;
            }
            graphics.drawCenteredString(this.font, "+", slotX + 16, slotY + 16 - 4, 0x555555);
        }
        if (this.selectingPhotos && !this.availablePhotos.isEmpty()) {
            int selectorY = this.addPhotoButtonY + 20 + 8;
            graphics.drawCenteredString(this.font, "Click photos to add:", this.width / 2, selectorY, 0xAAAAAA);
            selectorY += 12;
            int photosPerRow = 8;
            int selectorSlotSize = 24;
            int selectorSpacing = 2;
            int selectorWidth = photosPerRow * selectorSlotSize + (photosPerRow - 1) * selectorSpacing;
            int selectorStartX = (this.width - selectorWidth) / 2;
            for (int i = 0; i < this.availablePhotos.size() && i < photosPerRow * 2; ++i) {
                int row = i / photosPerRow;
                int col = i % photosPerRow;
                int slotX = selectorStartX + col * (selectorSlotSize + selectorSpacing);
                int slotY = selectorY + row * (selectorSlotSize + selectorSpacing);
                ItemStack photo = this.availablePhotos.get(i);
                String photoId = ExposureCompat.getPhotoId(photo);
                boolean alreadySelected = photoId != null && this.selectedPhotoIds.contains(photoId);
                int bgColor = alreadySelected ? -2141847723 : Integer.MIN_VALUE;
                graphics.fill(slotX, slotY, slotX + selectorSlotSize, slotY + selectorSlotSize, bgColor);
                graphics.renderOutline(slotX, slotY, selectorSlotSize, selectorSlotSize, alreadySelected ? -11141291 : -11184811);
                int itemX = slotX + (selectorSlotSize - 16) / 2;
                int itemY = slotY + (selectorSlotSize - 16) / 2;
                graphics.renderItem(photo, itemX, itemY);
            }
        }
    }

    private void renderPhotoPreviewOverlay(GuiGraphics graphics) {
        graphics.fill(0, 0, this.width, this.height, -16777216);
        int previewSize = 128;
        int previewX = (this.width - previewSize) / 2;
        int previewY = (this.height - previewSize) / 2 - 10;
        graphics.drawCenteredString(this.font, "Photo Preview", this.width / 2, previewY - 25, 0xFFFFFF);
        graphics.fill(previewX - 4, previewY - 4, previewX + previewSize + 4, previewY + previewSize + 4, -10066330);
        graphics.fill(previewX - 2, previewY - 2, previewX + previewSize + 2, previewY + previewSize + 2, -13421773);
        graphics.fill(previewX, previewY, previewX + previewSize, previewY + previewSize, -15066598);
        boolean renderedPhoto = ExposureCompat.renderPhotographInGui(graphics, this.previewPhoto, previewX, previewY, previewSize);
        if (!renderedPhoto) {
            graphics.pose().pushPose();
            graphics.pose().translate((float)previewX + (float)(previewSize - 64) / 2.0f, (float)previewY + (float)(previewSize - 64) / 2.0f, 100.0f);
            graphics.pose().scale(4.0f, 4.0f, 1.0f);
            graphics.renderItem(this.previewPhoto, 0, 0);
            graphics.pose().popPose();
        }
        graphics.drawCenteredString(this.font, "Click anywhere or press ESC to close", this.width / 2, previewY + previewSize + 15, 0xAAAAAA);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.previewPhoto != null) {
            this.previewPhoto = null;
            return true;
        }
        if (button == 0) {
            int slotY;
            int slotX;
            int i;
            int totalPhotoWidth = 212;
            int photoStartX = (this.width - totalPhotoWidth) / 2;
            for (i = 0; i < this.selectedPhotos.size(); ++i) {
                slotX = photoStartX + i * 36;
                slotY = this.photoSlotsY;
                int xButtonX = slotX + 32 - 9;
                int xButtonY = slotY + 1;
                if (!(mouseX >= (double)(xButtonX - 1)) || !(mouseX <= (double)(xButtonX + 8)) || !(mouseY >= (double)(xButtonY - 1)) || !(mouseY <= (double)(xButtonY + 8))) continue;
                this.removePhoto(i);
                return true;
            }
            for (i = 0; i < this.selectedPhotos.size(); ++i) {
                slotX = photoStartX + i * 36;
                slotY = this.photoSlotsY;
                if (!(mouseX >= (double)slotX) || !(mouseX < (double)(slotX + 32)) || !(mouseY >= (double)slotY) || !(mouseY < (double)(slotY + 32))) continue;
                this.previewPhoto = this.selectedPhotos.get(i);
                return true;
            }
            if (this.selectingPhotos && !this.availablePhotos.isEmpty()) {
                int selectorY = this.addPhotoButtonY + 20 + 8 + 12;
                int photosPerRow = 8;
                int selectorSlotSize = 24;
                int selectorSpacing = 2;
                int selectorWidth = photosPerRow * selectorSlotSize + (photosPerRow - 1) * selectorSpacing;
                int selectorStartX = (this.width - selectorWidth) / 2;
                for (int i2 = 0; i2 < this.availablePhotos.size() && i2 < photosPerRow * 2; ++i2) {
                    int row = i2 / photosPerRow;
                    int col = i2 % photosPerRow;
                    int slotX2 = selectorStartX + col * (selectorSlotSize + selectorSpacing);
                    int slotY2 = selectorY + row * (selectorSlotSize + selectorSpacing);
                    if (!(mouseX >= (double)slotX2) || !(mouseX <= (double)(slotX2 + selectorSlotSize)) || !(mouseY >= (double)slotY2) || !(mouseY <= (double)(slotY2 + selectorSlotSize))) continue;
                    this.addPhoto(this.availablePhotos.get(i2));
                    return true;
                }
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.previewPhoto != null && keyCode == 256) {
            this.previewPhoto = null;
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

