/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.client;

import dev.wxmc.weatheraddon.radar.ColorTablePreset;
import dev.wxmc.weatheraddon.radar.RadarColorConfig;
import java.net.URI;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ColorTableSelectionScreen
extends Screen {
    private static final int BUTTON_WIDTH = 180;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_SPACING = 24;
    private static final int TITLE_COLOR = 0xFFFFFF;
    private static final String WXTOOLS_URL = "https://www.wxtools.org/";
    @Nullable
    private final Screen parentScreen;

    public ColorTableSelectionScreen(@Nullable Screen parentScreen) {
        super((Component)Component.literal((String)"Reflectivity Color Table"));
        this.parentScreen = parentScreen;
    }

    protected void init() {
        ColorTablePreset[] presets = ColorTablePreset.values();
        int totalHeight = presets.length * 24 + 40;
        int startY = (this.height - totalHeight) / 2 + 25;
        int centerX = (this.width - 180) / 2;
        for (int i = 0; i < presets.length; ++i) {
            ColorTablePreset preset = presets[i];
            boolean isSelected = preset == RadarColorConfig.getCurrentPreset();
            Object buttonText = preset.getDisplayName();
            if (isSelected) {
                buttonText = "> " + (String)buttonText + " <";
            }
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)buttonText), button -> this.selectPreset(preset)).bounds(centerX, startY + i * 24, 180, 20).build());
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), button -> this.goBack()).bounds(centerX, startY + presets.length * 24 + 10, 180, 20).build());
        int creditButtonWidth = 250;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Thank you wxtools.org for the color tables").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC), button -> this.openWxTools()).bounds((this.width - creditButtonWidth) / 2, this.height - 50, creditButtonWidth, 20).build());
    }

    private void goBack() {
        if (this.parentScreen != null) {
            Minecraft.getInstance().setScreen(this.parentScreen);
        } else {
            this.onClose();
        }
    }

    private void selectPreset(ColorTablePreset preset) {
        RadarColorConfig.setCurrentPreset(preset);
        this.rebuildWidgets();
    }

    private void openWxTools() {
        Util.getPlatform().openUri(URI.create(WXTOOLS_URL));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        ColorTablePreset current = RadarColorConfig.getCurrentPreset();
        graphics.drawCenteredString(this.font, (Component)Component.literal((String)"Current: ").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)current.getDisplayName()).withStyle(ChatFormatting.GOLD)), this.width / 2, 35, 0xFFFFFF);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.goBack();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

