/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.client;

import dev.wxmc.weatheraddon.Config;
import dev.wxmc.weatheraddon.ModSounds;
import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.client.TooltipWarningScreen;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import dev.wxmc.weatheraddon.warnings.AlertPolygonManager;
import dev.wxmc.weatheraddon.warnings.WarningConfig;
import dev.wxmc.weatheraddon.warnings.WarningLevel;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientWarningHandler {
    private static final Map<Long, ActiveWarning> activeWarnings = new ConcurrentHashMap<Long, ActiveWarning>();
    private static final Map<String, CachedWarningDetail> warningDetailCache = new ConcurrentHashMap<String, CachedWarningDetail>();
    private static final long WARNING_DISPLAY_DURATION_MS = 10000L;
    private static final long CACHE_EXPIRY_MS = 300000L;

    public static void handleWarningAlert(long stormId, WarningLevel level, String message, double stormX, double stormZ, String direction) {
        activeWarnings.put(stormId, new ActiveWarning(stormId, level, message, stormX, stormZ, direction));
        if (((Boolean)WarningConfig.PLAY_ALERT_SOUND.get()).booleanValue()) {
            ClientWarningHandler.playAlertSound(level);
        }
        if (WarningConfig.isDebugMode()) {
            WXMCWeatherAddon.LOGGER.debug("Client received warning alert: {} for storm {}", (Object)level.getDisplayName(), (Object)stormId);
        }
    }

    private static void playAlertSound(WarningLevel level) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        float volume = ((Double)Config.EAS_ALERT_VOLUME.get()).floatValue();
        if (level.isSevereThunderstormWarning() || level.isTornadoWarning()) {
            mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.WARNING_TONE.get()), (float)1.0f, (float)volume));
        } else {
            mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BELL_BLOCK, (float)1.0f, (float)volume));
        }
    }

    public static Collection<ActiveWarning> getActiveWarnings() {
        activeWarnings.values().removeIf(ActiveWarning::isExpired);
        return Collections.unmodifiableCollection(activeWarnings.values());
    }

    public static ActiveWarning getMostSevereWarning() {
        return ClientWarningHandler.getActiveWarnings().stream().max(Comparator.comparingInt(w -> w.level.getPriority())).orElse(null);
    }

    public static boolean hasActiveWarnings() {
        activeWarnings.values().removeIf(ActiveWarning::isExpired);
        return !activeWarnings.isEmpty();
    }

    public static void clearActiveWarnings() {
        activeWarnings.clear();
    }

    public static void clearAll() {
        activeWarnings.clear();
        AlertPolygonManager.clearAll();
    }

    public static void onDisconnect() {
        ClientWarningHandler.clearAll();
    }

    public static void cacheWarningDetail(String warningId, Component content, int color) {
        warningDetailCache.values().removeIf(CachedWarningDetail::isExpired);
        warningDetailCache.put(warningId, new CachedWarningDetail(content, color));
        if (WarningConfig.isDebugMode()) {
            WXMCWeatherAddon.LOGGER.debug("Cached warning detail: {}", (Object)warningId);
        }
    }

    public static void cacheWarningDetailWithTemplate(String warningId, Component content, String rawTemplate, int color) {
        warningDetailCache.values().removeIf(CachedWarningDetail::isExpired);
        warningDetailCache.put(warningId, new CachedWarningDetail(content, rawTemplate, color));
        if (WarningConfig.isDebugMode()) {
            WXMCWeatherAddon.LOGGER.debug("Cached warning detail with template: {}", (Object)warningId);
        }
    }

    public static void openWarningDetailScreen(String warningId) {
        CachedWarningDetail detail = warningDetailCache.get(warningId);
        if (detail == null || detail.isExpired()) {
            WXMCWeatherAddon.LOGGER.debug("Warning detail not found or expired: {}", (Object)warningId);
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        mc.execute(() -> {
            if (detail.rawTemplate != null) {
                mc.setScreen((Screen)new TooltipWarningScreen(detail.rawTemplate, detail.color));
            } else {
                mc.setScreen((Screen)new TooltipWarningScreen(detail.content, detail.color));
            }
        });
    }

    public static String generateWarningId() {
        return "warning_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 10000.0);
    }

    public static CachedWarningDetail getCachedWarning(String warningId) {
        CachedWarningDetail detail = warningDetailCache.get(warningId);
        if (detail != null && detail.isExpired()) {
            warningDetailCache.remove(warningId);
            return null;
        }
        return detail;
    }

    public static void updateWarningTemplate(String warningId, String newTemplate) {
        WXMCDebugLogger.debug("[CLIENT] Received template update for warningId: {}", warningId);
        CachedWarningDetail existing = warningDetailCache.get(warningId);
        if (existing != null && !existing.isExpired()) {
            warningDetailCache.put(warningId, new CachedWarningDetail(existing.content, newTemplate, existing.color));
            WXMCDebugLogger.debug("[CLIENT] Updated cache for warningId: {}", warningId);
        } else {
            WXMCDebugLogger.debug("[CLIENT] Warning {} not found or expired in cache. Cache keys: {}", warningId, warningDetailCache.keySet());
        }
    }

    public static class ActiveWarning {
        public final long stormId;
        public final WarningLevel level;
        public final String message;
        public final double stormX;
        public final double stormZ;
        public final String direction;
        public final long receivedTime;

        public ActiveWarning(long stormId, WarningLevel level, String message, double stormX, double stormZ, String direction) {
            this.stormId = stormId;
            this.level = level;
            this.message = message;
            this.stormX = stormX;
            this.stormZ = stormZ;
            this.direction = direction;
            this.receivedTime = System.currentTimeMillis();
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.receivedTime > 10000L;
        }

        public float getAlpha() {
            long elapsed = System.currentTimeMillis() - this.receivedTime;
            if (elapsed > 8000L) {
                return Math.max(0.0f, (float)(10000L - elapsed) / 2000.0f);
            }
            return 1.0f;
        }
    }

    public static class CachedWarningDetail {
        public final Component content;
        public final String rawTemplate;
        public final int color;
        public final long cachedTime;

        public CachedWarningDetail(Component content, int color) {
            this.content = content;
            this.rawTemplate = null;
            this.color = color;
            this.cachedTime = System.currentTimeMillis();
        }

        public CachedWarningDetail(Component content, String rawTemplate, int color) {
            this.content = content;
            this.rawTemplate = rawTemplate;
            this.color = color;
            this.cachedTime = System.currentTimeMillis();
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.cachedTime > 300000L;
        }
    }
}

