/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.client;

import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.block.ModBlocks;
import dev.wxmc.weatheraddon.client.RadarConfiguratorScreen;
import dev.wxmc.weatheraddon.client.RadarOverlayRenderer;
import dev.wxmc.weatheraddon.client.WallRadarRenderer;
import dev.wxmc.weatheraddon.item.EASReceiverItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="wxmcweatheraddon", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetup {
    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlocks.RADAR_OVERLAY_BE.get(), RadarOverlayRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlocks.WALL_RADAR_BE.get(), WallRadarRenderer::new);
        WXMCWeatherAddon.LOGGER.info("Warning system client renderers registered");
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemProperties.register((Item)((Item)ModBlocks.EAS_RECEIVER.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wxmcweatheraddon", (String)"eas_enabled"), (stack, level, entity, seed) -> EASReceiverItem.isEnabled(stack) ? 1.0f : 0.0f));
        WXMCWeatherAddon.LOGGER.info("Warning system client setup complete");
    }

    @EventBusSubscriber(modid="wxmcweatheraddon", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
    public static class ClientGameEvents {
        @SubscribeEvent
        public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
            if (event.getLevel().isClientSide() && event.getEntity().isShiftKeyDown() && event.getItemStack().is((Item)ModBlocks.RADAR_CONFIGURATOR.get())) {
                Minecraft.getInstance().setScreen((Screen)new RadarConfiguratorScreen());
            }
        }
    }
}

