/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.client;

import dev.wxmc.weatheraddon.ClientConfig;
import dev.wxmc.weatheraddon.client.ClientWarningHandler;
import dev.wxmc.weatheraddon.client.DamageAssessmentScreen;
import dev.wxmc.weatheraddon.client.PhotoMetadataClientStorage;
import dev.wxmc.weatheraddon.client.SirenSoundManager;
import dev.wxmc.weatheraddon.client.TornadoDatabaseScreen;
import dev.wxmc.weatheraddon.client.WarningTooltipOverlay;
import dev.wxmc.weatheraddon.data.TornadoEntry;
import dev.wxmc.weatheraddon.network.PhotoMetadataNetworkHandler;
import dev.wxmc.weatheraddon.network.SoundingNetworkHandler;
import dev.wxmc.weatheraddon.sounding.SoundingData;
import dev.wxmc.weatheraddon.sounding.SoundingFetcher;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import dev.wxmc.weatheraddon.warnings.AlertPolygon;
import dev.wxmc.weatheraddon.warnings.AlertPolygonManager;
import dev.wxmc.weatheraddon.warnings.WarningLevel;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientNetworkHandlers {
    public static void handleWarningAlert(long stormId, WarningLevel level, String shortMessage, double stormX, double stormZ, String direction, String rawTemplate, int warningColor, String warningId) {
        ClientWarningHandler.handleWarningAlert(stormId, level, shortMessage, stormX, stormZ, direction);
        int customColor = ClientConfig.getColorForLevel(level);
        ClientNetworkHandlers.displayWarningChatMessage(shortMessage, customColor, warningId);
        String customTemplate = ClientNetworkHandlers.replaceTemplateColor(rawTemplate, customColor);
        if (customTemplate != null && !customTemplate.isEmpty()) {
            ClientWarningHandler.cacheWarningDetailWithTemplate(warningId, null, customTemplate, customColor);
            String warningTypeName = level.getDisplayName();
            WarningTooltipOverlay.setCurrentWarning(warningId, customTemplate, customColor, warningTypeName);
        }
    }

    private static String replaceTemplateColor(String template, int customColor) {
        if (template == null || template.isEmpty()) {
            return template;
        }
        String customHex = String.format("%06X", customColor & 0xFFFFFF);
        if (template.startsWith("#") && template.length() >= 7) {
            return "#" + customHex + template.substring(7);
        }
        return template.replaceFirst("#[0-9A-Fa-f]{6}", "#" + customHex);
    }

    private static void displayWarningChatMessage(String warningText, int color, String warningId) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        MutableComponent warningPart = Component.literal((String)warningText).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)color)).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "wxmc:warning:" + warningId)));
        MutableComponent hoverHint = Component.literal((String)" (Hover for Information)").withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY));
        MutableComponent chatMessage = Component.empty().append((Component)warningPart).append((Component)hoverHint);
        mc.player.displayClientMessage((Component)chatMessage, false);
    }

    public static void handleRadarPolygonSync(BlockPos radarPos, List<AlertPolygon> polygons) {
        BlockPos abovePos = radarPos.above();
        AlertPolygonManager.clearPolygons(radarPos);
        AlertPolygonManager.clearPolygons(abovePos);
        if (polygons != null && !polygons.isEmpty()) {
            for (AlertPolygon poly : polygons) {
                AlertPolygonManager.addPolygon(radarPos, poly);
                AlertPolygonManager.addPolygon(abovePos, poly);
            }
            WXMCDebugLogger.debug("[CLIENT-SYNC] Received {} polygon(s) for radar at {}", polygons.size(), radarPos);
        }
    }

    public static void handleWarningTemplateUpdate(String warningId, String rawTemplate) {
        if (warningId != null && !warningId.isEmpty() && rawTemplate != null && !rawTemplate.isEmpty()) {
            ClientWarningHandler.updateWarningTemplate(warningId, rawTemplate);
            WarningTooltipOverlay.updateWarningTemplate(warningId, rawTemplate);
        }
    }

    public static void handleRadarRemoved(BlockPos radarPos) {
        BlockPos overlayPos = radarPos.above();
        BlockPos pmweatherPos = new BlockPos(radarPos.getX(), -1, radarPos.getZ());
        AlertPolygonManager.clearPolygons(radarPos);
        AlertPolygonManager.clearPolygons(overlayPos);
        AlertPolygonManager.clearPolygons(pmweatherPos);
    }

    public static void handleDatabaseEntries(List<TornadoEntry> entries, boolean isAdmin) {
        Minecraft mc = Minecraft.getInstance();
        mc.execute(() -> mc.setScreen((Screen)new TornadoDatabaseScreen(entries, isAdmin)));
    }

    public static void handleSubmissionResult(boolean success, String message) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            String color = success ? "\u00a7a" : "\u00a7c";
            mc.player.sendSystemMessage((Component)Component.literal((String)(color + message)));
        }
        if (success && mc.screen instanceof DamageAssessmentScreen) {
            mc.setScreen(null);
        }
    }

    public static void handleOpenAssessmentGui() {
        Minecraft mc = Minecraft.getInstance();
        mc.execute(() -> mc.setScreen((Screen)new DamageAssessmentScreen()));
    }

    public static void handleSirenSoundStart(BlockPos sirenPos, int frequencyOrdinal) {
        SirenSoundManager.startSiren(sirenPos, frequencyOrdinal);
    }

    public static void handleSirenSoundStop(BlockPos sirenPos) {
        SirenSoundManager.stopSiren(sirenPos);
    }

    public static void handleSoundingSync(SoundingNetworkHandler.SoundingSyncPacket packet) {
        SoundingData soundingData = packet.toSoundingData();
        SoundingFetcher.setSounding(soundingData);
        WXMCDebugLogger.debug("[CLIENT-SOUNDING] Received {} sounding: {} ({}) - {} levels", packet.riskCategory(), packet.stationId(), packet.stationName(), packet.levels().size());
    }

    public static void handleSoundingClear() {
        SoundingFetcher.clearCache();
        WXMCDebugLogger.debug("[CLIENT-SOUNDING] Sounding data cleared by server");
    }

    public static void handlePhotoMetadataSync(PhotoMetadataNetworkHandler.PhotoMetadataSyncPacket packet) {
        PhotoMetadataClientStorage.storeMetadata(packet.photoId(), packet.photographer(), packet.x(), packet.z());
    }

    public static void handlePhotoMetadataBulkSync(PhotoMetadataNetworkHandler.PhotoMetadataBulkSyncPacket packet) {
        int count = 0;
        for (PhotoMetadataNetworkHandler.PhotoMetadataBulkSyncPacket.PhotoMetadataEntry entry : packet.entries()) {
            PhotoMetadataClientStorage.storeMetadata(entry.photoId(), entry.photographer(), entry.x(), entry.z());
            ++count;
        }
        WXMCDebugLogger.info("[CLIENT-PHOTO] Received {} photo metadata entries from server", count);
    }
}

