/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.block;

import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.block.ModBlocks;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import dev.wxmc.weatheraddon.warnings.AlertPolygonManager;
import dev.wxmc.weatheraddon.warnings.WarningConfig;
import java.awt.Color;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import org.jetbrains.annotations.Nullable;

public class WallRadarBlockEntity
extends BlockEntity {
    public List<Object> storms = new ArrayList<Object>();
    public int tickCount = 0;
    public int updateCount = 0;
    public SimplexNoise noise;
    public Map<Long, Float> reflectivityMap = new HashMap<Long, Float>();
    public Map<Long, Float> temperatureMap = new HashMap<Long, Float>();
    public Map<Long, Float> velocityMap = new HashMap<Long, Float>();
    public Map<Long, Color> debugMap = new HashMap<Long, Color>();
    public Map<Long, Color> terrainMap = new HashMap<Long, Color>();
    public List<BiomeData> biomeData = new ArrayList<BiomeData>();
    public Map<BlockPos, Holder<Biome>> biomeCache = new HashMap<BlockPos, Holder<Biome>>();
    public boolean init = false;
    public int lastUpdate = 0;
    public boolean hasRangeUpgrade = false;
    private static Class<?> pmweatherModBlocksClass = null;
    private static Object rangeUpgradeBlock = null;
    private static boolean pmweatherChecked = false;

    public WallRadarBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.WALL_RADAR_BE.get(), pos, blockState);
        this.noise = new SimplexNoise((RandomSource)new LegacyRandomSource(0L));
    }

    public Holder<Biome> getNearestBiome(BlockPos pos) {
        if (this.biomeCache.containsKey(pos.atY(0))) {
            return this.biomeCache.get(pos.atY(0));
        }
        double nearest = Double.MAX_VALUE;
        Holder<Biome> biome = null;
        for (BiomeData bData : this.biomeData) {
            double dist = pos.distManhattan((Vec3i)bData.pos);
            if (dist < nearest) {
                nearest = dist;
                biome = bData.biome;
            }
            if (!(dist < 128.0)) continue;
            break;
        }
        if (biome != null) {
            this.biomeCache.put(pos.atY(0), biome);
        }
        return biome;
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        ++this.tickCount;
        if (level.isClientSide()) {
            if (level.getGameTime() % 100L == 0L || this.storms.isEmpty()) {
                ++this.updateCount;
                this.fetchStormsFromPMWeather();
            }
            if (level.getGameTime() % 10L == 0L) {
                this.checkForRangeUpgrade(level, blockPos);
            }
        }
        if (!this.init) {
            this.initializeBiomeData(level, blockPos);
        }
    }

    private void initializeBiomeData(Level level, BlockPos blockPos) {
        Holder biome;
        BlockPos pos;
        int z;
        int x;
        this.init = true;
        for (x = -2048; x <= 2048; x += 64) {
            for (z = -2048; z <= 2048; z += 64) {
                pos = blockPos.offset(new Vec3i(x, 0, z));
                biome = level.getBiome(pos);
                this.biomeData.add(new BiomeData(pos, (Holder<Biome>)biome));
            }
        }
        for (x = -2048; x <= 2048; x += 128) {
            for (z = -2048; z <= 2048; z += 128) {
                pos = blockPos.offset(new Vec3i(x * 4, 0, z * 4));
                BiomeData data = new BiomeData(pos, (Holder<Biome>)(biome = level.getBiome(pos)));
                if (this.biomeData.contains(data)) continue;
                this.biomeData.add(data);
            }
        }
        WXMCWeatherAddon.LOGGER.debug("Wall radar initialized biome data at {}", (Object)blockPos);
    }

    private void fetchStormsFromPMWeather() {
        try {
            Class<?> clientEventsClass = Class.forName("dev.protomanly.pmweather.event.GameBusClientEvents");
            Object weatherHandler = clientEventsClass.getField("weatherHandler").get(null);
            if (weatherHandler != null) {
                Method getStormsMethod = weatherHandler.getClass().getMethod("getStorms", new Class[0]);
                List stormList = (List)getStormsMethod.invoke(weatherHandler, new Object[0]);
                this.storms = new ArrayList<Object>(stormList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkForRangeUpgrade(Level level, BlockPos blockPos) {
        this.hasRangeUpgrade = false;
        if (!pmweatherChecked) {
            pmweatherChecked = true;
            try {
                pmweatherModBlocksClass = Class.forName("dev.protomanly.pmweather.block.ModBlocks");
                Object holder = pmweatherModBlocksClass.getField("RANGE_UPGRADE_MODULE").get(null);
                Method getMethod = holder.getClass().getMethod("get", new Class[0]);
                rangeUpgradeBlock = getMethod.invoke(holder, new Object[0]);
            }
            catch (Exception e) {
                rangeUpgradeBlock = null;
            }
        }
        if (rangeUpgradeBlock == null) {
            return;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos pos = blockPos.offset(x, y, z);
                    BlockState state = level.getBlockState(pos);
                    if (state.getBlock() != rangeUpgradeBlock) continue;
                    this.hasRangeUpgrade = true;
                    return;
                }
            }
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        tag.putBoolean("init", this.init);
        tag.putBoolean("hasRangeUpgrade", this.hasRangeUpgrade);
        if (!this.biomeData.isEmpty()) {
            CompoundTag biomeTag = new CompoundTag();
            int i = 0;
            for (BiomeData data : this.biomeData) {
                CompoundTag entry = new CompoundTag();
                entry.put("pos", NbtUtils.writeBlockPos((BlockPos)data.pos));
                entry.putString("biome", data.biome.getRegisteredName());
                biomeTag.put(String.valueOf(i++), (Tag)entry);
            }
            tag.put("biomeData", (Tag)biomeTag);
        }
        AlertPolygonManager.writePolygons(this.worldPosition, tag);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.init = tag.getBoolean("init");
        this.hasRangeUpgrade = tag.getBoolean("hasRangeUpgrade");
        if (tag.contains("biomeData")) {
            this.biomeData.clear();
            CompoundTag biomeTag = tag.getCompound("biomeData");
            for (String key : biomeTag.getAllKeys()) {
                CompoundTag entry = biomeTag.getCompound(key);
                BlockPos pos = NbtUtils.readBlockPos((CompoundTag)entry, (String)"blockPos").orElse(BlockPos.ZERO);
                String biomeName = entry.getString("biome");
                if (this.level == null) continue;
                try {
                    Holder.Reference biome = this.level.registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)biomeName)));
                    this.biomeData.add(new BiomeData(pos, (Holder<Biome>)biome));
                }
                catch (Exception exception) {}
            }
        }
        if (tag.contains("polygons")) {
            AlertPolygonManager.readPolygons(this.worldPosition, tag);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        CompoundTag tag = super.getUpdateTag(lookupProvider);
        this.saveAdditional(tag, lookupProvider);
        return tag;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        CompoundTag tag = pkt.getTag();
        if (tag != null && tag.contains("polygons")) {
            AlertPolygonManager.readPolygons(this.worldPosition, tag);
            if (WarningConfig.isDebugMode()) {
                int count = AlertPolygonManager.getPolygonCount(this.worldPosition);
                WXMCDebugLogger.debug("[WALL-RADAR] Received {} polygons at {}", count, this.worldPosition);
            }
        } else {
            AlertPolygonManager.clearPolygons(this.worldPosition);
        }
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.handleUpdateTag(tag, registries);
        if (tag.contains("polygons")) {
            AlertPolygonManager.readPolygons(this.getBlockPos(), tag);
            if (WarningConfig.isDebugMode()) {
                int count = AlertPolygonManager.getPolygonCount(this.getBlockPos());
                WXMCDebugLogger.debug("[WALL-RADAR] Loaded {} polygons at {}", count, this.getBlockPos());
            }
        } else {
            AlertPolygonManager.clearPolygons(this.getBlockPos());
        }
    }

    public void requestClientUpdate() {
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.setChanged();
            if (WarningConfig.isDebugMode()) {
                int polyCount = AlertPolygonManager.getPolygonCount(this.worldPosition);
                WXMCDebugLogger.debug("[WALL-RADAR] requestClientUpdate: {} polygons at {}", polyCount, this.worldPosition);
            }
        }
    }

    public void setRemoved() {
        super.setRemoved();
        AlertPolygonManager.clearPolygons(this.getBlockPos());
        if (WarningConfig.isDebugMode()) {
            WXMCWeatherAddon.LOGGER.debug("WallRadarBE removed at {}", (Object)this.getBlockPos());
        }
    }

    public record BiomeData(BlockPos pos, Holder<Biome> biome) {
    }
}

