/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.block;

import com.mojang.serialization.MapCodec;
import dev.wxmc.weatheraddon.block.ModBlocks;
import dev.wxmc.weatheraddon.block.WallRadarBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WallRadarBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<Mode> RADAR_MODE = EnumProperty.create((String)"mode", Mode.class);
    public static final MapCodec<WallRadarBlock> CODEC = WallRadarBlock.simpleCodec(WallRadarBlock::new);
    private static final double THICKNESS = 2.0;
    protected static final VoxelShape NORTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape EAST_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_SHAPE = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public WallRadarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(RADAR_MODE, (Comparable)((Object)Mode.REFLECTIVITY)));
    }

    public WallRadarBlock() {
        this(BlockBehaviour.Properties.of().strength(2.0f).noOcclusion().lightLevel(state -> 7));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, RADAR_MODE});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            Mode currentMode = (Mode)((Object)state.getValue(RADAR_MODE));
            Mode newMode = switch (currentMode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Mode.VELOCITY;
                case 1 -> Mode.IR;
                case 2 -> Mode.REFLECTIVITY;
            };
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(RADAR_MODE, (Comparable)((Object)newMode)));
        }
        return InteractionResult.SUCCESS_NO_ITEM_USED;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction clickedFace = context.getClickedFace();
        if (clickedFace.getAxis().isVertical()) {
            return null;
        }
        BlockPos supportPos = context.getClickedPos().relative(clickedFace.getOpposite());
        BlockState supportState = context.getLevel().getBlockState(supportPos);
        if (!supportState.isFaceSturdy((BlockGetter)context.getLevel(), supportPos, clickedFace)) {
            return null;
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)clickedFace);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos supportPos = pos.relative(facing.getOpposite());
        BlockState supportState = level.getBlockState(supportPos);
        return supportState.isFaceSturdy((BlockGetter)level, supportPos, facing);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (direction == facing.getOpposite() && !this.canSurvive(state, (LevelReader)level, pos)) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Block.dropResources((BlockState)state, (Level)serverLevel, (BlockPos)pos);
            }
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WallRadarBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return WallRadarBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlocks.WALL_RADAR_BE.get()), (lvl, pos, blockState, blockEntity) -> blockEntity.tick(lvl, pos, blockState));
    }

    public static enum Mode implements StringRepresentable
    {
        REFLECTIVITY("reflectivity"),
        VELOCITY("velocity"),
        IR("ir");

        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

