/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.block;

import dev.wxmc.weatheraddon.block.ModBlocks;
import dev.wxmc.weatheraddon.network.WarningNetworkHandler;
import dev.wxmc.weatheraddon.warnings.AlertPolygon;
import dev.wxmc.weatheraddon.warnings.AlertPolygonManager;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TornadoSirenBlockEntity
extends BlockEntity {
    private static final int SIREN_DURATION_TICKS = 580;
    private static final int COOLDOWN_DURATION_TICKS = 300;
    private static final float SIREN_VOLUME = 4.0f;
    private static final double RADAR_RANGE = 2048.0;
    private SirenState state = SirenState.IDLE;
    private int ticksInState = 0;
    private SirenFrequency frequency = SirenFrequency.HZ_523;

    public TornadoSirenBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.TORNADO_SIREN_BE.get(), pos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TornadoSirenBlockEntity entity) {
        entity.tick(level, pos);
    }

    private void tick(Level level, BlockPos pos) {
        boolean inTornadoWarning = this.isInTornadoWarningPolygon(pos);
        switch (this.state.ordinal()) {
            case 0: {
                if (!inTornadoWarning) break;
                this.transitionTo(SirenState.PLAYING);
                this.playSirenSound(pos);
                break;
            }
            case 1: {
                ++this.ticksInState;
                if (this.ticksInState < 580) break;
                this.transitionTo(SirenState.COOLDOWN);
                break;
            }
            case 2: {
                ++this.ticksInState;
                if (this.ticksInState < 300) break;
                if (inTornadoWarning) {
                    this.transitionTo(SirenState.PLAYING);
                    this.playSirenSound(pos);
                    break;
                }
                this.transitionTo(SirenState.IDLE);
            }
        }
    }

    private void transitionTo(SirenState newState) {
        this.state = newState;
        this.ticksInState = 0;
        this.setChanged();
    }

    private void playSirenSound(BlockPos pos) {
        WarningNetworkHandler.broadcastSirenSoundStart(pos, this.frequency.ordinal());
    }

    public void stopSirenSound() {
        WarningNetworkHandler.broadcastSirenSoundStop(this.getBlockPos());
    }

    public SirenFrequency toggleFrequency() {
        this.frequency = this.frequency == SirenFrequency.HZ_523 ? SirenFrequency.HZ_659 : SirenFrequency.HZ_523;
        this.setChanged();
        return this.frequency;
    }

    public SirenFrequency getFrequency() {
        return this.frequency;
    }

    private boolean isInTornadoWarningPolygon(BlockPos sirenPos) {
        Set<BlockPos> radarPositions = AlertPolygonManager.getTrackedRadars();
        for (BlockPos radarPos : radarPositions) {
            Collection<AlertPolygon> polygons = AlertPolygonManager.getPolygonsAt(radarPos);
            for (AlertPolygon polygon : polygons) {
                if (!polygon.getWarningLevel().isTornadoWarning() || !this.isPointInPolygon(sirenPos, radarPos, polygon)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPointInPolygon(BlockPos worldPos, BlockPos radarPos, AlertPolygon polygon) {
        double dx = worldPos.getX() - radarPos.getX();
        double dz = worldPos.getZ() - radarPos.getZ();
        double normalizedX = 0.5 + dx / 4096.0;
        double normalizedZ = 0.5 + dz / 4096.0;
        if (normalizedX < 0.0 || normalizedX > 1.0 || normalizedZ < 0.0 || normalizedZ > 1.0) {
            return false;
        }
        double relX = normalizedX - polygon.centerX;
        double relZ = normalizedZ - polygon.centerZ;
        double rotRad = Math.toRadians(-polygon.rotationDeg);
        double cos = Math.cos(rotRad);
        double sin = Math.sin(rotRad);
        double localX = relX * cos - relZ * sin;
        double localZ = relX * sin + relZ * cos;
        return Math.abs(localX) <= (double)polygon.halfWidth && Math.abs(localZ) <= (double)polygon.halfHeight;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        tag.putInt("state", this.state.ordinal());
        tag.putInt("ticksInState", this.ticksInState);
        tag.putInt("frequency", this.frequency.ordinal());
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.state = SirenState.values()[tag.getInt("state")];
        this.ticksInState = tag.getInt("ticksInState");
        if (tag.contains("frequency")) {
            this.frequency = SirenFrequency.values()[tag.getInt("frequency")];
        }
    }

    public SirenState getState() {
        return this.state;
    }

    public boolean isActive() {
        return this.state != SirenState.IDLE;
    }

    public boolean isPlaying() {
        return this.state == SirenState.PLAYING;
    }

    public static enum SirenState {
        IDLE,
        PLAYING,
        COOLDOWN;

    }

    public static enum SirenFrequency {
        HZ_523("523Hz"),
        HZ_659("659Hz");

        private final String displayName;

        private SirenFrequency(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

