/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.block;

import com.mojang.serialization.MapCodec;
import dev.wxmc.weatheraddon.block.ModBlocks;
import dev.wxmc.weatheraddon.block.TornadoSirenBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TornadoSirenBlock
extends BaseEntityBlock {
    public static final MapCodec<TornadoSirenBlock> CODEC = TornadoSirenBlock.simpleCodec(TornadoSirenBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape BASE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)7.0, (double)14.0);
    private static final VoxelShape SIREN_SOUTH = Block.box((double)2.5, (double)4.5, (double)7.0, (double)13.5, (double)15.5, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)BASE, (VoxelShape)SIREN_SOUTH);
    private static final VoxelShape SIREN_NORTH = Block.box((double)2.5, (double)4.5, (double)0.0, (double)13.5, (double)15.5, (double)9.0);
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)BASE, (VoxelShape)SIREN_NORTH);
    private static final VoxelShape SIREN_EAST = Block.box((double)7.0, (double)4.5, (double)2.5, (double)16.0, (double)15.5, (double)13.5);
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)BASE, (VoxelShape)SIREN_EAST);
    private static final VoxelShape SIREN_WEST = Block.box((double)0.0, (double)4.5, (double)2.5, (double)9.0, (double)15.5, (double)13.5);
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)BASE, (VoxelShape)SIREN_WEST);

    public TornadoSirenBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_SOUTH;
        };
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        TornadoSirenBlockEntity sirenEntity;
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && level instanceof ServerLevel && (blockEntity = level.getBlockEntity(pos)) instanceof TornadoSirenBlockEntity && (sirenEntity = (TornadoSirenBlockEntity)blockEntity).isPlaying()) {
            sirenEntity.stopSirenSound();
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TornadoSirenBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide()) {
            return null;
        }
        return TornadoSirenBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlocks.TORNADO_SIREN_BE.get()), TornadoSirenBlockEntity::serverTick);
    }
}

