/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.block;

import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.block.ModBlocks;
import dev.wxmc.weatheraddon.warnings.AlertPolygonManager;
import dev.wxmc.weatheraddon.warnings.WarningConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class RadarOverlayBlockEntity
extends BlockEntity {
    public RadarOverlayBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.RADAR_OVERLAY_BE.get(), pos, state);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        AlertPolygonManager.writePolygons(this.worldPosition, tag);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        if (tag.contains("polygons")) {
            AlertPolygonManager.readPolygons(this.worldPosition, tag);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        CompoundTag tag = super.getUpdateTag(lookupProvider);
        this.saveAdditional(tag, lookupProvider);
        return tag;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        CompoundTag tag = pkt.getTag();
        BlockPos radarPos = this.worldPosition.below();
        if (tag != null && tag.contains("polygons")) {
            AlertPolygonManager.readPolygons(this.worldPosition, tag);
            AlertPolygonManager.readPolygons(radarPos, tag);
        } else {
            AlertPolygonManager.clearPolygons(this.worldPosition);
            AlertPolygonManager.clearPolygons(radarPos);
        }
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.handleUpdateTag(tag, registries);
        BlockPos radarPos = this.getBlockPos().below();
        if (tag.contains("polygons")) {
            AlertPolygonManager.readPolygons(this.getBlockPos(), tag);
            AlertPolygonManager.readPolygons(radarPos, tag);
        } else {
            AlertPolygonManager.clearPolygons(this.getBlockPos());
            AlertPolygonManager.clearPolygons(radarPos);
        }
    }

    public void requestClientUpdate() {
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.setChanged();
        }
    }

    public void setRemoved() {
        super.setRemoved();
        AlertPolygonManager.clearPolygons(this.getBlockPos());
        if (WarningConfig.isDebugMode()) {
            WXMCWeatherAddon.LOGGER.debug("RadarOverlayBE removed at {}", (Object)this.getBlockPos());
        }
    }
}

