/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.block;

import com.mojang.serialization.MapCodec;
import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.block.RadarOverlayBlockEntity;
import dev.wxmc.weatheraddon.warnings.WarningSystem;
import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RadarOverlayBlock
extends BaseEntityBlock {
    public static final MapCodec<RadarOverlayBlock> CODEC = RadarOverlayBlock.simpleCodec(p -> new RadarOverlayBlock());

    public RadarOverlayBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.NONE).replaceable().noCollission().noLootTable().noOcclusion().air().pushReaction(PushReaction.DESTROY).isViewBlocking((state, world, pos) -> false).isSuffocating((state, world, pos) -> false));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter world, BlockPos pos) {
        return Shapes.empty();
    }

    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RadarOverlayBlockEntity(pos, state);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        if (!level.isClientSide() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos radarPos = pos.below();
            WarningSystem.registerRadarImmediate(radarPos, serverLevel);
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        boolean isRadarBlock;
        BlockPos radarPos = pos.below();
        BlockState radarState = level.getBlockState(radarPos);
        Block radarBlock = radarState.getBlock();
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)radarBlock);
        boolean bl = isRadarBlock = blockId.getNamespace().equals("pmweather") && blockId.getPath().toLowerCase().contains("radar");
        if (isRadarBlock) {
            try {
                BlockHitResult radarHit = new BlockHitResult(hit.getLocation(), hit.getDirection(), radarPos, hit.isInside());
                Class<?> radarCls = radarBlock.getClass();
                Method useMethod = radarCls.getDeclaredMethod("useWithoutItem", BlockState.class, Level.class, BlockPos.class, Player.class, BlockHitResult.class);
                useMethod.setAccessible(true);
                return (InteractionResult)useMethod.invoke((Object)radarBlock, radarState, level, radarPos, player, radarHit);
            }
            catch (Exception e) {
                WXMCWeatherAddon.LOGGER.warn("Failed to pass interaction to radar block: {}", (Object)e.getMessage());
            }
        }
        return InteractionResult.PASS;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (!level.isClientSide()) {
            this.checkRadarBelow(level, pos);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        this.checkRadarBelow((Level)level, pos);
    }

    private void checkRadarBelow(Level level, BlockPos overlayPos) {
        boolean isRadarBlock;
        BlockPos radarPos = overlayPos.below();
        BlockState radarState = level.getBlockState(radarPos);
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)radarState.getBlock());
        boolean bl = isRadarBlock = blockId.getNamespace().equals("pmweather") && blockId.getPath().toLowerCase().contains("radar");
        if (!isRadarBlock) {
            WarningSystem.onRadarRemoved(overlayPos);
            level.destroyBlock(overlayPos, false);
            WXMCWeatherAddon.LOGGER.info("Removed radar overlay at {} - no radar block found below (found: {})", (Object)overlayPos, (Object)blockId);
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock()) && !level.isClientSide()) {
            WarningSystem.onRadarRemoved(pos);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public boolean skipRendering(BlockState state, BlockState adjacentState, Direction side) {
        return true;
    }
}

