/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.block;

import com.mojang.serialization.MapCodec;
import dev.wxmc.weatheraddon.block.LoudounSirenBlockEntity;
import dev.wxmc.weatheraddon.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LoudounSirenBlock
extends BaseEntityBlock {
    public static final MapCodec<LoudounSirenBlock> CODEC = LoudounSirenBlock.simpleCodec(LoudounSirenBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape BASE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0);
    private static final VoxelShape BODY = Block.box((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0);
    private static final VoxelShape HORNS = Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{BODY, HORNS});

    public LoudounSirenBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        LoudounSirenBlockEntity sirenEntity;
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && level instanceof ServerLevel && (blockEntity = level.getBlockEntity(pos)) instanceof LoudounSirenBlockEntity && (sirenEntity = (LoudounSirenBlockEntity)blockEntity).isPlaying()) {
            sirenEntity.stopSirenSound();
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new LoudounSirenBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide()) {
            return null;
        }
        return LoudounSirenBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlocks.LOUDOUN_SIREN_BE.get()), LoudounSirenBlockEntity::serverTick);
    }
}

