/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import dev.wxmc.weatheraddon.ClientConfig;
import dev.wxmc.weatheraddon.Config;
import dev.wxmc.weatheraddon.MilestoneRewards;
import dev.wxmc.weatheraddon.ModSounds;
import dev.wxmc.weatheraddon.TornadoCommand;
import dev.wxmc.weatheraddon.TornadoDetector;
import dev.wxmc.weatheraddon.block.ModBlocks;
import dev.wxmc.weatheraddon.client.ClientModSetup;
import dev.wxmc.weatheraddon.command.TordbAdminCommand;
import dev.wxmc.weatheraddon.command.TordbCommand;
import dev.wxmc.weatheraddon.compat.BukkitEventBridge;
import dev.wxmc.weatheraddon.compat.ExposureCompat;
import dev.wxmc.weatheraddon.compat.ExposureEventHandler;
import dev.wxmc.weatheraddon.compat.PhotoMetadataStorage;
import dev.wxmc.weatheraddon.network.DamageAssessmentNetworkHandler;
import dev.wxmc.weatheraddon.network.PhotoMetadataNetworkHandler;
import dev.wxmc.weatheraddon.network.SoundingNetworkHandler;
import dev.wxmc.weatheraddon.network.WarningNetworkHandler;
import dev.wxmc.weatheraddon.outlook.OutlookCommand;
import dev.wxmc.weatheraddon.outlook.OutlookManager;
import dev.wxmc.weatheraddon.sounding.ServerSoundingManager;
import dev.wxmc.weatheraddon.sounding.SoundingCommand;
import dev.wxmc.weatheraddon.sounding.SoundingFetcher;
import dev.wxmc.weatheraddon.sounding.SoundingManager;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import dev.wxmc.weatheraddon.warnings.WarningCommand;
import dev.wxmc.weatheraddon.warnings.WarningSystem;
import java.lang.reflect.Method;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import org.slf4j.Logger;

@Mod(value="wxmcweatheraddon")
public class WXMCWeatherAddon {
    public static final String MODID = "wxmcweatheraddon";
    public static final String MOD_VERSION = "1.0.0";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final String AUTH_MOD_ID = "wxmcserverauth";
    private static final String AUTH_KEY = "WXMC-AUTH-2024-EXCLUSIVE-SERVER-KEY";
    private static final long AUTH_TOKEN = 6290758202389973087L;

    public WXMCWeatherAddon(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC, "wxmcweatheraddon-server.toml");
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC, "WXMC/wxmcweatheraddon-client.toml");
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.registerClientConfigScreen(modContainer);
        }
        ModBlocks.register(modEventBus);
        ModSounds.register(modEventBus);
        modEventBus.register(WarningNetworkHandler.class);
        modEventBus.register(DamageAssessmentNetworkHandler.class);
        modEventBus.register(SoundingNetworkHandler.class);
        modEventBus.register(PhotoMetadataNetworkHandler.class);
        NeoForge.EVENT_BUS.register(TornadoDetector.class);
        NeoForge.EVENT_BUS.register(WarningSystem.class);
        NeoForge.EVENT_BUS.register(SoundingManager.class);
        NeoForge.EVENT_BUS.register((Object)this);
        WXMCDebugLogger.init();
        MilestoneRewards.loadRewards();
        SoundingFetcher.init();
        BukkitEventBridge.init();
        if (ExposureCompat.isExposureLoaded()) {
            try {
                NeoForge.EVENT_BUS.register(ExposureEventHandler.class);
                WXMCDebugLogger.info("Exposure mod integration enabled - tornado photography detection active");
            }
            catch (NoClassDefFoundError e) {
                WXMCDebugLogger.debug("Failed to register Exposure event handler: {}", e.getMessage());
            }
        }
        WXMCDebugLogger.info("WXMC Weather Addon initialized!");
        WXMCDebugLogger.info("Warning System module loaded");
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        TornadoCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        WarningCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        TordbCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        TordbAdminCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        SoundingCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        OutlookCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        boolean isDedicated = event.getServer().isDedicatedServer();
        if (isDedicated) {
            WXMCDebugLogger.info("[WXMC] Running on DEDICATED SERVER - Checking authentication...");
            if (!this.verifyServerAuthentication()) {
                LOGGER.error("===========================================");
                LOGGER.error(" WXMC WEATHER ADDON - AUTHENTICATION FAILED");
                LOGGER.error("===========================================");
                LOGGER.error(" This mod requires WXMC Server Authenticator");
                LOGGER.error(" to run on dedicated servers.");
                LOGGER.error("");
                LOGGER.error(" WXMC Weather Addon is exclusive to authorized");
                LOGGER.error(" WXMC servers. Unauthorized use is prohibited.");
                LOGGER.error("===========================================");
                throw new RuntimeException("\n\n=====================================================\n WXMC WEATHER ADDON - SERVER NOT AUTHORIZED\n=====================================================\n This mod requires WXMC Server Authenticator to run\n on dedicated servers.\n\n WXMC Weather Addon is exclusive to authorized WXMC\n servers. If you believe this is an error, contact\n the WXMC administration.\n=====================================================\n");
            }
            WXMCDebugLogger.info("[WXMC] Server authentication VERIFIED");
        } else {
            WXMCDebugLogger.info("[WXMC] Running on INTEGRATED SERVER (singleplayer) - No auth required");
        }
        ServerSoundingManager.init(event.getServer());
        WXMCDebugLogger.info("[SOUNDING] Server-side sounding manager initialized");
        OutlookManager.init(event.getServer());
        WXMCDebugLogger.info("[OUTLOOK] 7-day outlook manager initialized");
        if (ExposureCompat.isExposureLoaded()) {
            PhotoMetadataStorage.init(event.getServer());
            WXMCDebugLogger.info("[EXPOSURE] Photo metadata storage initialized");
        }
    }

    private boolean verifyServerAuthentication() {
        if (!ModList.get().isLoaded(AUTH_MOD_ID)) {
            LOGGER.error("[WXMC] WXMC Server Authenticator mod not found!");
            return false;
        }
        WXMCDebugLogger.info("[WXMC] WXMC Server Authenticator mod detected");
        try {
            Class<?> authClass = Class.forName("dev.wxmc.serverauth.WXMCServerAuth");
            Method getKeyMethod = authClass.getMethod("getAuthKey", new Class[0]);
            String key = (String)getKeyMethod.invoke(null, new Object[0]);
            if (!AUTH_KEY.equals(key)) {
                LOGGER.error("[WXMC] Authentication key mismatch!");
                return false;
            }
            Method getTokenMethod = authClass.getMethod("getAuthToken", new Class[0]);
            long token = (Long)getTokenMethod.invoke(null, new Object[0]);
            if (token != 6290758202389973087L) {
                LOGGER.error("[WXMC] Authentication token mismatch!");
                return false;
            }
            Method validateMethod = authClass.getMethod("validateAuth", String.class);
            boolean valid = (Boolean)validateMethod.invoke(null, AUTH_KEY);
            if (!valid) {
                LOGGER.error("[WXMC] Authentication validation failed!");
                return false;
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("[WXMC] Could not find authenticator class - possible fake mod!");
            return false;
        }
        catch (Exception e) {
            LOGGER.error("[WXMC] Authentication error: {}", (Object)e.getMessage());
            return false;
        }
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        ServerSoundingManager.shutdown();
        WXMCDebugLogger.info("[SOUNDING] Server-side sounding manager shutdown");
        OutlookManager.shutdown();
        WXMCDebugLogger.info("[OUTLOOK] 7-day outlook manager shutdown");
        if (ExposureCompat.isExposureLoaded()) {
            PhotoMetadataStorage.shutdown();
            WXMCDebugLogger.info("[EXPOSURE] Photo metadata storage shutdown");
        }
        WXMCDebugLogger.shutdown();
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ServerSoundingManager.syncToPlayer(player2);
            if (ExposureCompat.isExposureLoaded()) {
                PhotoMetadataNetworkHandler.syncAllMetadataToPlayer(player2);
            }
        }
    }

    private void registerClientConfigScreen(ModContainer modContainer) {
        ClientModSetup.registerConfigScreen(modContainer);
    }
}

