/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon;

import dev.wxmc.weatheraddon.Config;
import dev.wxmc.weatheraddon.PlayerData;
import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import dev.wxmc.weatheraddon.warnings.StormTracker;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class TornadoDetector {
    private static final int VALIDATION_INTERVAL = 6000;
    private static final int BORDER_CHECK_INTERVAL = 300;
    private static final double BORDER_DESPAWN_DISTANCE = 500.0;
    private static int validationCounter = 0;
    private static int borderCheckCounter = 0;
    private static Class<?> gameBusEventsClass = null;
    private static Class<?> weatherHandlerClass = null;
    private static Class<?> stormClass = null;
    private static Field managersField = null;
    private static Method getStormsMethod = null;
    private static Method removeStormMethod = null;
    private static Field stormTypeField = null;
    private static Field stageField = null;
    private static Field tornadoOnGroundTicksField = null;
    private static Field stormIdField = null;
    private static Field positionField = null;
    private static Field windspeedField = null;
    private static Field velocityField = null;
    private static Field deadField = null;
    private static Field levelField = null;
    private static volatile boolean pmWeatherAvailable = false;
    private static volatile boolean checkedPMWeather = false;

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        ++validationCounter;
        ++borderCheckCounter;
        if (!checkedPMWeather) {
            TornadoDetector.initializePMWeatherReflection();
        }
        if (validationCounter >= 6000) {
            validationCounter = 0;
            PlayerData.performPeriodicValidation(event.getServer());
        }
        if (borderCheckCounter >= 300 && pmWeatherAvailable) {
            borderCheckCounter = 0;
            for (ServerLevel level : event.getServer().getAllLevels()) {
                TornadoDetector.checkStormsAtWorldBorder(level);
            }
        }
    }

    private static void initializePMWeatherReflection() {
        WXMCDebugLogger.debug("[DEBUG] initializePMWeatherReflection() starting...");
        StormTracker tracker = StormTracker.getInstance();
        WXMCDebugLogger.debug("[DEBUG] Got StormTracker instance, isPMWeatherAvailable = {}", tracker.isPMWeatherAvailable());
        if (!tracker.isPMWeatherAvailable()) {
            pmWeatherAvailable = false;
            WXMCDebugLogger.debug("[DEBUG] StormTracker not ready yet, will retry...");
            return;
        }
        checkedPMWeather = true;
        WXMCDebugLogger.debug("[DEBUG] StormTracker ready, getting class references...");
        try {
            gameBusEventsClass = tracker.getGameBusEventsClass();
            weatherHandlerClass = tracker.getWeatherHandlerClass();
            stormClass = tracker.getStormClass();
            WXMCDebugLogger.debug("[DEBUG] Classes: gameBus={}, weatherHandler={}, storm={}", gameBusEventsClass, weatherHandlerClass, stormClass);
            if (gameBusEventsClass == null || weatherHandlerClass == null || stormClass == null) {
                throw new RuntimeException("StormTracker returned null class references");
            }
            managersField = tracker.getManagersField();
            getStormsMethod = tracker.getGetStormsMethod();
            stormTypeField = tracker.getStormTypeField();
            stageField = tracker.getStageField();
            tornadoOnGroundTicksField = tracker.getTornadoOnGroundTicksField();
            stormIdField = tracker.getStormIdField();
            positionField = tracker.getPositionField();
            windspeedField = tracker.getWindspeedField();
            velocityField = tracker.getVelocityField();
            deadField = tracker.getDeadField();
            WXMCDebugLogger.debug("[DEBUG] Fields: managers={}, getStorms={}, stormId={}", managersField, getStormsMethod, stormIdField);
            levelField = TornadoDetector.getFieldSafe(stormClass, "level");
            try {
                removeStormMethod = stormClass.getMethod("remove", new Class[0]);
            }
            catch (Exception e) {
                WXMCDebugLogger.debug("Could not get Storm.remove() method (expected on dedicated servers): {}", e.getMessage());
                removeStormMethod = null;
            }
            pmWeatherAvailable = true;
            WXMCDebugLogger.debug("[DEBUG] SUCCESS - pmWeatherAvailable = true");
            WXMCWeatherAddon.LOGGER.info("PMWeather mod detected (via StormTracker) - tornado reporting enabled");
            WXMCWeatherAddon.LOGGER.info("Storm world border despawn enabled ({} blocks from border)", (Object)500.0);
        }
        catch (Exception e) {
            pmWeatherAvailable = false;
            WXMCDebugLogger.debug("[DEBUG] FAILED - Exception: {}", e.getMessage());
            WXMCWeatherAddon.LOGGER.error("Failed to initialize TornadoDetector from StormTracker", (Throwable)e);
        }
    }

    private static Field getFieldSafe(Class<?> clazz, String name) {
        try {
            Field field = clazz.getField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            try {
                Field field = clazz.getDeclaredField(name);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException ex) {
                return null;
            }
        }
    }

    public static boolean isPMWeatherAvailable() {
        WXMCDebugLogger.debug("[DEBUG] isPMWeatherAvailable called - checkedPMWeather={}, pmWeatherAvailable={}", checkedPMWeather, pmWeatherAvailable);
        if (!checkedPMWeather) {
            WXMCDebugLogger.debug("[DEBUG] Running initializePMWeatherReflection...");
            TornadoDetector.initializePMWeatherReflection();
            WXMCDebugLogger.debug("[DEBUG] After init - checkedPMWeather={}, pmWeatherAvailable={}", checkedPMWeather, pmWeatherAvailable);
        }
        StormTracker tracker = StormTracker.getInstance();
        WXMCDebugLogger.debug("[DEBUG] StormTracker.isPMWeatherAvailable = {}", tracker.isPMWeatherAvailable());
        return pmWeatherAvailable;
    }

    private static void checkStormsAtWorldBorder(ServerLevel level) {
        try {
            Object weatherHandler = TornadoDetector.getWeatherHandler(level);
            if (weatherHandler == null) {
                return;
            }
            List<?> storms = TornadoDetector.getStorms(weatherHandler);
            if (storms == null || storms.isEmpty()) {
                return;
            }
            WorldBorder border = level.getWorldBorder();
            double borderSize = border.getSize() / 2.0;
            double centerX = border.getCenterX();
            double centerZ = border.getCenterZ();
            double safeDistance = borderSize - 500.0;
            if (safeDistance <= 0.0) {
                return;
            }
            ArrayList stormsToRemove = new ArrayList();
            for (Object storm : storms) {
                try {
                    Vec3 pos;
                    boolean dead;
                    if (positionField == null || deadField == null || (dead = deadField.getBoolean(storm)) || (pos = (Vec3)positionField.get(storm)) == null) continue;
                    double distX = Math.abs(pos.x - centerX);
                    double distZ = Math.abs(pos.z - centerZ);
                    if (!(distX > safeDistance) && !(distZ > safeDistance)) continue;
                    stormsToRemove.add(storm);
                }
                catch (Exception e) {
                    WXMCDebugLogger.debug("[DETECTOR] Failed to process storm for border check: {}", e.getMessage());
                }
            }
            if (removeStormMethod == null) {
                return;
            }
            for (Object storm : stormsToRemove) {
                try {
                    Vec3 pos = (Vec3)positionField.get(storm);
                    long stormId = stormIdField != null ? stormIdField.getLong(storm) : -1L;
                    removeStormMethod.invoke(storm, new Object[0]);
                    WXMCWeatherAddon.LOGGER.info("Despawned storm {} at ({}, {}) - too close to world border", new Object[]{stormId, (int)pos.x, (int)pos.z});
                }
                catch (Exception e) {
                    WXMCWeatherAddon.LOGGER.warn("Failed to remove storm near world border: {}", (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            WXMCWeatherAddon.LOGGER.debug("Error checking storms at world border: {}", (Object)e.getMessage());
        }
    }

    public static TornadoInfo findTornadoInPlayerView(ServerPlayer player) {
        if (!TornadoDetector.isPMWeatherAvailable()) {
            return null;
        }
        try {
            ServerLevel level = player.serverLevel();
            Object weatherHandler = TornadoDetector.getWeatherHandler(level);
            if (weatherHandler == null) {
                return null;
            }
            List<?> storms = TornadoDetector.getStorms(weatherHandler);
            if (storms == null || storms.isEmpty()) {
                return null;
            }
            Vec3 playerEyePos = player.getEyePosition();
            Vec3 playerLookDir = player.getViewVector(1.0f).normalize();
            double maxDistance = (Double)Config.REPORT_MAX_DISTANCE.get();
            double angleTolerance = (Double)Config.REPORT_ANGLE_TOLERANCE.get();
            double cosAngleTolerance = Math.cos(Math.toRadians(angleTolerance));
            TornadoInfo closestTornado = null;
            double closestAngle = Double.MAX_VALUE;
            for (Object storm : storms) {
                double angle;
                Vec3 toTornado;
                double dotProduct;
                Vec3 tornadoPos;
                if (!TornadoDetector.isActiveTornado(storm) || positionField == null || stormIdField == null || windspeedField == null || (tornadoPos = (Vec3)positionField.get(storm)) == null) continue;
                long stormId = stormIdField.getLong(storm);
                int windspeed = windspeedField.getInt(storm);
                double distance = playerEyePos.distanceTo(tornadoPos);
                if (distance > maxDistance || !((dotProduct = playerLookDir.dot(toTornado = tornadoPos.subtract(playerEyePos).normalize())) >= cosAngleTolerance) || !((angle = Math.toDegrees(Math.acos(Math.min(1.0, dotProduct)))) < closestAngle)) continue;
                closestAngle = angle;
                String direction = TornadoDetector.getCardinalDirection(playerEyePos, tornadoPos);
                closestTornado = new TornadoInfo(stormId, tornadoPos, windspeed, distance, angle, direction);
            }
            return closestTornado;
        }
        catch (Exception e) {
            WXMCWeatherAddon.LOGGER.error("Error finding tornado in player view for {} at ({}, {}, {})", new Object[]{player.getName().getString(), (int)player.getX(), (int)player.getY(), (int)player.getZ(), e});
            return null;
        }
    }

    public static List<TornadoInfo> getAllTornadoes(ServerPlayer player) {
        ArrayList<TornadoInfo> tornadoes = new ArrayList<TornadoInfo>();
        if (!TornadoDetector.isPMWeatherAvailable()) {
            return tornadoes;
        }
        try {
            ServerLevel level = player.serverLevel();
            Object weatherHandler = TornadoDetector.getWeatherHandler(level);
            if (weatherHandler == null) {
                return tornadoes;
            }
            List<?> storms = TornadoDetector.getStorms(weatherHandler);
            if (storms == null || storms.isEmpty()) {
                return tornadoes;
            }
            Vec3 playerPos = player.position();
            for (Object storm : storms) {
                Vec3 tornadoPos;
                if (!TornadoDetector.isActiveTornado(storm) || positionField == null || stormIdField == null || windspeedField == null || (tornadoPos = (Vec3)positionField.get(storm)) == null) continue;
                long stormId = stormIdField.getLong(storm);
                int windspeed = windspeedField.getInt(storm);
                double distance = playerPos.distanceTo(tornadoPos);
                String direction = TornadoDetector.getCardinalDirection(playerPos, tornadoPos);
                tornadoes.add(new TornadoInfo(stormId, tornadoPos, windspeed, distance, 0.0, direction));
            }
        }
        catch (Exception e) {
            WXMCWeatherAddon.LOGGER.error("Error getting all tornadoes for {} in dimension {}", new Object[]{player.getName().getString(), player.serverLevel().dimension().location(), e});
        }
        return tornadoes;
    }

    private static Object getWeatherHandler(ServerLevel level) {
        try {
            Map managers = (Map)managersField.get(null);
            return managers.get(level.dimension());
        }
        catch (Exception e) {
            return null;
        }
    }

    private static List<?> getStorms(Object weatherHandler) {
        try {
            return (List)getStormsMethod.invoke(weatherHandler, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isActiveTornado(Object storm) {
        try {
            int stormType = stormTypeField.getInt(storm);
            int stage = stageField.getInt(storm);
            int tornadoOnGroundTicks = tornadoOnGroundTicksField.getInt(storm);
            boolean dead = deadField.getBoolean(storm);
            return !dead && (stormType == 0 && stage >= 3 && tornadoOnGroundTicks > 0 || stormType == 3);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String getCardinalDirection(Vec3 from, Vec3 to) {
        double dx = to.x - from.x;
        double dz = to.z - from.z;
        double angle = Math.toDegrees(Math.atan2(dx, -dz));
        if (angle < 0.0) {
            angle += 360.0;
        }
        if (angle >= 337.5 || angle < 22.5) {
            return "N";
        }
        if (angle >= 22.5 && angle < 67.5) {
            return "NE";
        }
        if (angle >= 67.5 && angle < 112.5) {
            return "E";
        }
        if (angle >= 112.5 && angle < 157.5) {
            return "SE";
        }
        if (angle >= 157.5 && angle < 202.5) {
            return "S";
        }
        if (angle >= 202.5 && angle < 247.5) {
            return "SW";
        }
        if (angle >= 247.5 && angle < 292.5) {
            return "W";
        }
        if (angle >= 292.5 && angle < 337.5) {
            return "NW";
        }
        return "N";
    }

    public static void clearPlayerTracking(UUID playerUuid) {
        WXMCWeatherAddon.LOGGER.debug("clearPlayerTracking called for {}, but using persistent storage now", (Object)playerUuid);
    }

    public static class TornadoInfo {
        public final long stormId;
        public final Vec3 position;
        public final int windspeed;
        public final double distance;
        public final double angleFromPlayer;
        public final String direction;

        public TornadoInfo(long stormId, Vec3 position, int windspeed, double distance, double angleFromPlayer, String direction) {
            this.stormId = stormId;
            this.position = position;
            this.windspeed = windspeed;
            this.distance = distance;
            this.angleFromPlayer = angleFromPlayer;
            this.direction = direction;
        }
    }
}

