/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.wxmc.weatheraddon.ColorUtils;
import dev.wxmc.weatheraddon.Config;
import dev.wxmc.weatheraddon.PlayerData;
import dev.wxmc.weatheraddon.TornadoDetector;
import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.compat.BukkitEventBridge;
import dev.wxmc.weatheraddon.util.PermissionHelper;
import dev.wxmc.weatheraddon.warnings.StormTracker;
import dev.wxmc.weatheraddon.warnings.TrackedStorm;
import dev.wxmc.weatheraddon.warnings.WarningGenerator;
import dev.wxmc.weatheraddon.warnings.WarningSystem;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class TornadoCommand {
    private static final Map<UUID, Long> windReportCooldowns = new ConcurrentHashMap<UUID, Long>();
    private static final long WIND_REPORT_COOLDOWN_MS = 30000L;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        String[] aliases;
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"report").requires(source -> source.hasPermission(0))).then(Commands.literal((String)"tornado").executes(context -> TornadoCommand.reportTornado((CommandContext<CommandSourceStack>)context)))).then(Commands.literal((String)"hail").executes(context -> TornadoCommand.reportHail((CommandContext<CommandSourceStack>)context)))).then(Commands.literal((String)"wind").executes(context -> TornadoCommand.reportWind((CommandContext<CommandSourceStack>)context))));
        for (String alias : aliases = new String[]{"tornadocount", "torcount", "tcount", "tc"}) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)alias).requires(source -> source.hasPermission(0))).executes(context -> TornadoCommand.viewOwnCount((CommandContext<CommandSourceStack>)context))).then(((LiteralArgumentBuilder)Commands.literal((String)"view").requires(source -> PermissionHelper.hasPermission(source, "wxmc.tornadocount"))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> TornadoCommand.viewPlayerCount((CommandContext<CommandSourceStack>)context))))).then(((LiteralArgumentBuilder)Commands.literal((String)"reset").requires(source -> PermissionHelper.hasPermission(source, "wxmc.admin"))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> TornadoCommand.resetPlayerCount((CommandContext<CommandSourceStack>)context))))).then(Commands.literal((String)"list").executes(context -> TornadoCommand.listTornadoes((CommandContext<CommandSourceStack>)context))));
        }
    }

    private static int reportTornado(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!source.isPlayer()) {
            source.sendFailure((Component)Component.literal((String)"This command can only be used by players"));
            return 0;
        }
        ServerPlayer player = source.getPlayer();
        if (!TornadoDetector.isPMWeatherAvailable()) {
            source.sendFailure((Component)Component.literal((String)"\u00a7c[ERROR] PMWeather mod is not installed - tornado reporting unavailable"));
            return 0;
        }
        TornadoDetector.TornadoInfo tornado = TornadoDetector.findTornadoInPlayerView(player);
        if (tornado == null) {
            String noTornadoMsg = (String)Config.REPORT_NO_TORNADO_MESSAGE.get();
            for (String line : noTornadoMsg.split("\\\\n|\\n")) {
                player.sendSystemMessage(ColorUtils.parseColorCodes(line));
            }
            return 0;
        }
        if (PlayerData.hasPlayerSeenTornado(player, tornado.stormId)) {
            player.sendSystemMessage(ColorUtils.parseColorCodes((String)Config.REPORT_ALREADY_SEEN_MESSAGE.get()));
            return 0;
        }
        PlayerData.markTornadoAsSeen(player, tornado.stormId);
        PlayerData.incrementTornadoCount(player);
        TrackedStorm trackedStorm = StormTracker.getInstance().getStorm(tornado.stormId);
        if (trackedStorm != null) {
            trackedStorm.setSpotterConfirmed(true);
            WXMCWeatherAddon.LOGGER.info("Tornado {} marked as spotter confirmed by {}", (Object)tornado.stormId, (Object)player.getName().getString());
            WarningSystem.refreshWarningForStorm(trackedStorm, player.serverLevel());
        }
        int newCount = PlayerData.getTornadoCount(player);
        String successMsg = ((String)Config.REPORT_SUCCESS_MESSAGE.get()).replace("{count}", String.valueOf(newCount)).replace("{distance}", String.valueOf(Math.round(tornado.distance))).replace("{windspeed}", String.valueOf(tornado.windspeed)).replace("{direction}", tornado.direction);
        player.sendSystemMessage(ColorUtils.parseColorCodes(successMsg));
        String countMsg = ((String)Config.REPORT_COUNT_MESSAGE.get()).replace("{count}", String.valueOf(newCount));
        player.sendSystemMessage(ColorUtils.parseColorCodes(countMsg));
        WXMCWeatherAddon.LOGGER.info("Player {} reported tornado ID {} at distance {} blocks (windspeed: {} mph)", new Object[]{player.getName().getString(), tornado.stormId, Math.round(tornado.distance), tornado.windspeed});
        BukkitEventBridge.fireTornadoReported(player, tornado.stormId, newCount, tornado.position.x, tornado.position.z, tornado.windspeed);
        return 1;
    }

    private static int reportHail(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!source.isPlayer()) {
            source.sendFailure((Component)Component.literal((String)"This command can only be used by players"));
            return 0;
        }
        ServerPlayer player = source.getPlayer();
        TrackedStorm nearestStorm = TornadoCommand.findNearestStorm(player);
        if (nearestStorm == null) {
            player.sendSystemMessage(ColorUtils.parseColorCodes("&cThere is no hail to report"));
            return 0;
        }
        String hailSize = WarningGenerator.estimateHailSize(nearestStorm);
        if (hailSize.equals("None") || hailSize.equals("Unknown")) {
            player.sendSystemMessage(ColorUtils.parseColorCodes("&cThere is no hail to report"));
            return 0;
        }
        nearestStorm.setSpotterReportedHail(true);
        player.sendSystemMessage(ColorUtils.parseColorCodes("&aHail size of " + hailSize + " successfully reported!"));
        WXMCWeatherAddon.LOGGER.info("Player {} reported hail ({}) for storm ID {}", new Object[]{player.getName().getString(), hailSize, nearestStorm.getId()});
        WarningSystem.refreshWarningForStorm(nearestStorm, player.serverLevel());
        return 1;
    }

    private static int reportWind(CommandContext<CommandSourceStack> context) {
        long elapsed;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!source.isPlayer()) {
            source.sendFailure((Component)Component.literal((String)"This command can only be used by players"));
            return 0;
        }
        ServerPlayer player = source.getPlayer();
        UUID playerUUID = player.getUUID();
        Long lastReport = windReportCooldowns.get(playerUUID);
        if (lastReport != null && (elapsed = System.currentTimeMillis() - lastReport) < 30000L) {
            int secondsRemaining = (int)Math.ceil((double)(30000L - elapsed) / 1000.0);
            player.sendSystemMessage(ColorUtils.parseColorCodes("&cYou cannot report wind for another " + secondsRemaining + " seconds."));
            return 0;
        }
        TrackedStorm nearestStorm = TornadoCommand.findNearestStorm(player);
        if (nearestStorm == null) {
            player.sendSystemMessage(ColorUtils.parseColorCodes("&cThere is no wind to report"));
            return 0;
        }
        int windSpeed = nearestStorm.getWindspeed();
        if (windSpeed < 30) {
            player.sendSystemMessage(ColorUtils.parseColorCodes("&cThere is no wind to report"));
            return 0;
        }
        nearestStorm.setSpotterReportedWind(true);
        windReportCooldowns.put(playerUUID, System.currentTimeMillis());
        player.sendSystemMessage(ColorUtils.parseColorCodes("&aWind gust of " + windSpeed + " mph reported!"));
        WXMCWeatherAddon.LOGGER.info("Player {} reported wind ({} mph) for storm ID {}", new Object[]{player.getName().getString(), windSpeed, nearestStorm.getId()});
        WarningSystem.refreshWarningForStorm(nearestStorm, player.serverLevel());
        return 1;
    }

    private static TrackedStorm findNearestStorm(ServerPlayer player) {
        StormTracker tracker = StormTracker.getInstance();
        double maxDistance = 512.0;
        TrackedStorm nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (TrackedStorm storm : tracker.getTrackedStorms()) {
            double distance = storm.getPosition().distanceTo(player.position());
            if (!(distance < nearestDistance) || !(distance <= maxDistance)) continue;
            nearestDistance = distance;
            nearest = storm;
        }
        return nearest;
    }

    private static int listTornadoes(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!source.isPlayer()) {
            source.sendFailure((Component)Component.literal((String)"This command can only be used by players"));
            return 0;
        }
        ServerPlayer player = source.getPlayer();
        if (!TornadoDetector.isPMWeatherAvailable()) {
            source.sendFailure((Component)Component.literal((String)"\u00a7c[ERROR] PMWeather mod is not installed"));
            return 0;
        }
        List<TornadoDetector.TornadoInfo> tornadoes = TornadoDetector.getAllTornadoes(player);
        if (tornadoes.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)"\u00a77No active tornadoes in this dimension"), false);
            return 1;
        }
        source.sendSuccess(() -> Component.literal((String)"\u00a76=== Active Tornadoes ==="), false);
        for (TornadoDetector.TornadoInfo tornado : tornadoes) {
            boolean alreadyReported = PlayerData.hasPlayerSeenTornado(player, tornado.stormId);
            String status = alreadyReported ? "\u00a7a[REPORTED]" : "\u00a7e[NOT REPORTED]";
            int tornadoX = (int)Math.round(tornado.position.x);
            int tornadoZ = (int)Math.round(tornado.position.z);
            String info = String.format("%s \u00a77%s - \u00a7f%d blocks %s \u00a77(\u00a7f%d mph\u00a77) \u00a78[%d, %d]", status, String.valueOf(tornado.stormId).substring(0, Math.min(8, String.valueOf(tornado.stormId).length())), Math.round(tornado.distance), tornado.direction, tornado.windspeed, tornadoX, tornadoZ);
            source.sendSuccess(() -> Component.literal((String)info), false);
        }
        return 1;
    }

    private static int viewOwnCount(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!source.isPlayer()) {
            source.sendFailure((Component)Component.literal((String)"This command can only be used by players"));
            return 0;
        }
        ServerPlayer player = source.getPlayer();
        int count = PlayerData.getTornadoCount(player);
        String message = ((String)Config.COUNT_MESSAGE.get()).replace("{count}", String.valueOf(count)).replace("{player}", player.getName().getString());
        player.sendSystemMessage(ColorUtils.parseColorCodes(message));
        return 1;
    }

    private static int viewPlayerCount(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer target = EntityArgument.getPlayer(context, (String)"player");
            int count = PlayerData.getTornadoCount(target);
            String message = ((String)Config.COUNT_MESSAGE_OTHER.get()).replace("{count}", String.valueOf(count)).replace("{player}", target.getName().getString());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ColorUtils.parseColorCodes(message), false);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Player not found"));
            return 0;
        }
    }

    private static int resetPlayerCount(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer target = EntityArgument.getPlayer(context, (String)"player");
            PlayerData.resetTornadoCount(target);
            String message = "\u00a7aReset tornado count for " + target.getName().getString();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)message), true);
            target.sendSystemMessage((Component)Component.literal((String)"\u00a7eYour tornado report count has been reset"));
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Player not found"));
            return 0;
        }
    }
}

