/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon;

import dev.wxmc.weatheraddon.MilestoneRewards;
import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class PlayerData
extends SavedData {
    private static final String DATA_NAME = "wxmc_tornado_counts";
    private static final int MAX_TORNADO_COUNT = 1000000;
    private static final int MAX_SEEN_TORNADOES_PER_PLAYER = 10000;
    private final Map<UUID, Integer> tornadoCounts = new HashMap<UUID, Integer>();
    private final Map<UUID, Set<Long>> playerSeenTornadoes = new HashMap<UUID, Set<Long>>();

    public static PlayerData load(CompoundTag tag, HolderLookup.Provider provider) {
        PlayerData data = new PlayerData();
        CompoundTag countsTag = tag.getCompound("tornado_counts");
        for (String key : countsTag.getAllKeys()) {
            try {
                UUID uuid = UUID.fromString(key);
                int count = countsTag.getInt(key);
                if (count < 0) {
                    WXMCWeatherAddon.LOGGER.warn("Invalid negative count {} for player {}, resetting to 0", (Object)count, (Object)uuid);
                    count = 0;
                } else if (count > 1000000) {
                    WXMCWeatherAddon.LOGGER.warn("Count {} exceeds maximum {} for player {}, capping", new Object[]{count, 1000000, uuid});
                    count = 1000000;
                }
                data.tornadoCounts.put(uuid, count);
            }
            catch (IllegalArgumentException e) {
                WXMCWeatherAddon.LOGGER.warn("Invalid UUID in saved data: {}", (Object)key);
            }
        }
        CompoundTag seenTag = tag.getCompound("seen_tornadoes");
        for (String key : seenTag.getAllKeys()) {
            try {
                UUID uuid = UUID.fromString(key);
                long[] seenArray = seenTag.getLongArray(key);
                HashSet<Long> seenSet = new HashSet<Long>();
                int maxToLoad = Math.min(seenArray.length, 10000);
                for (int i = 0; i < maxToLoad; ++i) {
                    seenSet.add(seenArray[i]);
                }
                if (seenArray.length > 10000) {
                    WXMCWeatherAddon.LOGGER.info("Truncated seen tornado list for player {} from {} to {} entries", new Object[]{uuid, seenArray.length, 10000});
                }
                data.playerSeenTornadoes.put(uuid, seenSet);
            }
            catch (IllegalArgumentException e) {
                WXMCWeatherAddon.LOGGER.warn("Invalid UUID in seen tornadoes data: {}", (Object)key);
            }
        }
        data.validateAndRepairData();
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        CompoundTag countsTag = new CompoundTag();
        for (Map.Entry<UUID, Integer> entry : this.tornadoCounts.entrySet()) {
            countsTag.putInt(entry.getKey().toString(), entry.getValue().intValue());
        }
        tag.put("tornado_counts", (Tag)countsTag);
        CompoundTag seenTag = new CompoundTag();
        for (Map.Entry<UUID, Set<Long>> entry : this.playerSeenTornadoes.entrySet()) {
            Set<Long> seenSet = entry.getValue();
            long[] seenArray = seenSet.stream().mapToLong(Long::longValue).toArray();
            seenTag.putLongArray(entry.getKey().toString(), seenArray);
        }
        tag.put("seen_tornadoes", (Tag)seenTag);
        return tag;
    }

    private static PlayerData getOrCreate(MinecraftServer server) {
        DimensionDataStorage storage = server.overworld().getDataStorage();
        return (PlayerData)storage.computeIfAbsent(new SavedData.Factory(PlayerData::new, PlayerData::load), DATA_NAME);
    }

    private boolean validateAndRepairData() {
        boolean wasRepaired = false;
        if (this.tornadoCounts.containsKey(null)) {
            WXMCWeatherAddon.LOGGER.warn("Found null UUID in tornado counts, removing");
            this.tornadoCounts.remove(null);
            this.playerSeenTornadoes.remove(null);
            wasRepaired = true;
        }
        for (Map.Entry<UUID, Integer> entry : this.tornadoCounts.entrySet()) {
            UUID uuid = entry.getKey();
            Integer count = entry.getValue();
            if (count == null || count < 0) {
                WXMCWeatherAddon.LOGGER.warn("Invalid count {} for player {}, resetting to 0", (Object)count, (Object)uuid);
                entry.setValue(0);
                wasRepaired = true;
                continue;
            }
            if (count <= 1000000) continue;
            WXMCWeatherAddon.LOGGER.warn("Count {} exceeds maximum for player {}, capping to {}", new Object[]{count, uuid, 1000000});
            entry.setValue(1000000);
            wasRepaired = true;
        }
        for (Map.Entry<UUID, Object> entry : this.playerSeenTornadoes.entrySet()) {
            Set seenSet = (Set)entry.getValue();
            if (seenSet == null || seenSet.size() <= 10000) continue;
            HashSet<Long> truncatedSet = new HashSet<Long>();
            int count = 0;
            for (Long tornadoId : seenSet) {
                if (count++ >= 10000) break;
                truncatedSet.add(tornadoId);
            }
            entry.setValue(truncatedSet);
            WXMCWeatherAddon.LOGGER.info("Truncated seen tornado list for player {} from {} to {} entries", new Object[]{entry.getKey(), seenSet.size(), truncatedSet.size()});
            wasRepaired = true;
        }
        if (wasRepaired) {
            this.setDirty();
            WXMCWeatherAddon.LOGGER.info("Data validation completed with repairs");
        }
        return !wasRepaired;
    }

    public static int getTornadoCount(ServerPlayer player) {
        PlayerData data = PlayerData.getOrCreate(player.getServer());
        return data.tornadoCounts.getOrDefault(player.getUUID(), 0);
    }

    public static void incrementTornadoCount(ServerPlayer player) {
        PlayerData data = PlayerData.getOrCreate(player.getServer());
        UUID uuid = player.getUUID();
        int currentCount = data.tornadoCounts.getOrDefault(uuid, 0);
        if (currentCount < 0) {
            WXMCWeatherAddon.LOGGER.warn("Player {} had invalid negative count {}, resetting to 0", (Object)player.getName().getString(), (Object)currentCount);
            currentCount = 0;
        }
        if (currentCount >= 1000000) {
            WXMCWeatherAddon.LOGGER.warn("Player {} has reached maximum tornado count ({})", (Object)player.getName().getString(), (Object)1000000);
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7cYou've reached the maximum tornado count (1000000)!"));
            return;
        }
        int newCount = currentCount + 1;
        data.tornadoCounts.put(uuid, newCount);
        data.setDirty();
        MilestoneRewards.checkMilestones(player, currentCount, newCount);
        WXMCWeatherAddon.LOGGER.debug("Player {} tornado count increased to {}", (Object)player.getName().getString(), (Object)newCount);
    }

    public static void resetTornadoCount(ServerPlayer player) {
        PlayerData data = PlayerData.getOrCreate(player.getServer());
        UUID uuid = player.getUUID();
        data.tornadoCounts.remove(uuid);
        data.playerSeenTornadoes.remove(uuid);
        data.setDirty();
        WXMCWeatherAddon.LOGGER.info("Reset tornado count for player {}", (Object)player.getName().getString());
    }

    public static void setTornadoCount(ServerPlayer player, int count) {
        PlayerData data = PlayerData.getOrCreate(player.getServer());
        int oldCount = data.tornadoCounts.getOrDefault(player.getUUID(), 0);
        if (count < 0) {
            WXMCWeatherAddon.LOGGER.warn("Attempted to set negative count {} for player {}, using 0 instead", (Object)count, (Object)player.getName().getString());
            count = 0;
        }
        if (count > 1000000) {
            WXMCWeatherAddon.LOGGER.warn("Attempted to set count {} above maximum {} for player {}, capping", new Object[]{count, 1000000, player.getName().getString()});
            count = 1000000;
        }
        data.tornadoCounts.put(player.getUUID(), count);
        data.setDirty();
        if (count > oldCount) {
            MilestoneRewards.checkMilestones(player, oldCount, count);
        }
    }

    public static boolean hasPlayerSeenTornado(ServerPlayer player, long tornadoId) {
        PlayerData data = PlayerData.getOrCreate(player.getServer());
        Set<Long> seenSet = data.playerSeenTornadoes.get(player.getUUID());
        return seenSet != null && seenSet.contains(tornadoId);
    }

    public static void markTornadoAsSeen(ServerPlayer player, long tornadoId) {
        PlayerData data = PlayerData.getOrCreate(player.getServer());
        UUID uuid = player.getUUID();
        Set seenSet = data.playerSeenTornadoes.computeIfAbsent(uuid, k -> new HashSet());
        if (seenSet.size() >= 10000) {
            seenSet.stream().findFirst().ifPresent(toRemove -> {
                seenSet.remove(toRemove);
                WXMCWeatherAddon.LOGGER.debug("Removed old tornado ID {} from player {} seen list to make room", toRemove, (Object)player.getName().getString());
            });
        }
        seenSet.add(tornadoId);
        data.setDirty();
    }

    public static void clearPlayerSeenTornadoes(ServerPlayer player) {
        PlayerData data = PlayerData.getOrCreate(player.getServer());
        data.playerSeenTornadoes.remove(player.getUUID());
        data.setDirty();
    }

    public static void performPeriodicValidation(MinecraftServer server) {
        PlayerData data = PlayerData.getOrCreate(server);
        data.validateAndRepairData();
    }
}

