/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.util.WXMCFiles;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class MilestoneRewards {
    private static final String REWARDS_FILENAME = "milestone-rewards.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Map<Integer, List<String>> milestoneRewards = new HashMap<Integer, List<String>>();
    private static boolean rewardsEnabled = true;

    public static void loadRewards() {
        File configFile = WXMCFiles.getWXMCConfigDir().resolve(REWARDS_FILENAME).toFile();
        if (!configFile.exists()) {
            MilestoneRewards.createDefaultConfig(configFile);
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8);){
            JsonObject data = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (data.has("enabled")) {
                rewardsEnabled = data.get("enabled").getAsBoolean();
            }
            milestoneRewards.clear();
            if (data.has("rewards")) {
                JsonObject rewards = data.getAsJsonObject("rewards");
                for (Map.Entry entry : rewards.entrySet()) {
                    try {
                        int count = Integer.parseInt((String)entry.getKey());
                        ArrayList<String> commands = new ArrayList<String>();
                        JsonElement value = (JsonElement)entry.getValue();
                        if (value.isJsonArray()) {
                            JsonArray array = value.getAsJsonArray();
                            for (JsonElement item : array) {
                                commands.add(item.getAsString());
                            }
                        } else if (value.isJsonPrimitive()) {
                            commands.add(value.getAsString());
                        } else {
                            WXMCWeatherAddon.LOGGER.warn("Unexpected value type for milestone '{}'", entry.getKey());
                            continue;
                        }
                        milestoneRewards.put(count, commands);
                        WXMCWeatherAddon.LOGGER.debug("Loaded {} milestone reward with {} commands", (Object)count, (Object)commands.size());
                    }
                    catch (NumberFormatException e) {
                        WXMCWeatherAddon.LOGGER.warn("Invalid milestone count '{}' in rewards config", entry.getKey());
                    }
                }
            }
            WXMCWeatherAddon.LOGGER.info("Loaded {} milestone rewards from configuration", (Object)milestoneRewards.size());
        }
        catch (Exception e) {
            WXMCWeatherAddon.LOGGER.error("Failed to load milestone rewards configuration", (Throwable)e);
            MilestoneRewards.createDefaultRewards();
        }
    }

    private static void createDefaultConfig(File configFile) {
        try {
            configFile.getParentFile().mkdirs();
            JsonObject root = new JsonObject();
            root.addProperty("_comment", "WXMC Tornado Counter - Milestone Rewards Configuration. Use %player% as placeholder for player name.");
            root.addProperty("enabled", Boolean.valueOf(true));
            JsonObject rewards = new JsonObject();
            JsonArray milestone1 = new JsonArray();
            milestone1.add("tellraw @a [{\"text\":\"\\u26c8 \",\"color\":\"gold\"},{\"text\":\"%player% spotted their first tornado!\",\"color\":\"yellow\"}]");
            milestone1.add("playsound minecraft:entity.lightning_bolt.thunder master %player% ~ ~ ~ 1.0 1.0");
            rewards.add("1", (JsonElement)milestone1);
            JsonArray milestone10 = new JsonArray();
            milestone10.add("tellraw @a [{\"text\":\"\\u26c8 \",\"color\":\"gold\"},{\"text\":\"%player% is now a Storm Chaser! (10 tornadoes)\",\"color\":\"aqua\"}]");
            milestone10.add("give %player% minecraft:elytra 1");
            milestone10.add("give %player% minecraft:firework_rocket 64");
            rewards.add("10", (JsonElement)milestone10);
            JsonArray milestone50 = new JsonArray();
            milestone50.add("tellraw @a [{\"text\":\"\\u26c8 \",\"color\":\"gold\"},{\"text\":\"%player% is now a Tornado Hunter! (50 tornadoes)\",\"color\":\"light_purple\"}]");
            milestone50.add("give %player% minecraft:diamond 10");
            milestone50.add("give %player% minecraft:emerald 5");
            rewards.add("50", (JsonElement)milestone50);
            JsonArray milestone100 = new JsonArray();
            milestone100.add("tellraw @a [{\"text\":\"\\u26c8 \",\"color\":\"gold\"},{\"text\":\"%player% is now a Storm Master! (100 tornadoes)\",\"color\":\"red\"}]");
            milestone100.add("give %player% minecraft:netherite_ingot 3");
            milestone100.add("effect give %player% minecraft:luck 3600 1");
            rewards.add("100", (JsonElement)milestone100);
            JsonArray milestone500 = new JsonArray();
            milestone500.add("tellraw @a [{\"text\":\"\\u26c8 \",\"color\":\"gold\"},{\"text\":\"%player% has achieved legendary status! (500 tornadoes)\",\"color\":\"gold\"}]");
            milestone500.add("give %player% minecraft:nether_star 1");
            rewards.add("500", (JsonElement)milestone500);
            root.add("rewards", (JsonElement)rewards);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8);){
                GSON.toJson((JsonElement)root, (Appendable)writer);
            }
            WXMCWeatherAddon.LOGGER.info("Created default milestone rewards configuration at {}", (Object)configFile.getAbsolutePath());
        }
        catch (IOException e) {
            WXMCWeatherAddon.LOGGER.error("Failed to create default milestone rewards configuration", (Throwable)e);
        }
    }

    private static void createDefaultRewards() {
        milestoneRewards.clear();
        milestoneRewards.put(1, Arrays.asList("tellraw @a [{\"text\":\"\\u26c8 \",\"color\":\"gold\"},{\"text\":\"%player% spotted their first tornado!\",\"color\":\"yellow\"}]"));
        milestoneRewards.put(10, Arrays.asList("tellraw @a [{\"text\":\"\\u26c8 \",\"color\":\"gold\"},{\"text\":\"%player% is now a Storm Chaser! (10 tornadoes)\",\"color\":\"aqua\"}]"));
        milestoneRewards.put(50, Arrays.asList("tellraw @a [{\"text\":\"\\u26c8 \",\"color\":\"gold\"},{\"text\":\"%player% is now a Tornado Hunter! (50 tornadoes)\",\"color\":\"light_purple\"}]"));
        WXMCWeatherAddon.LOGGER.info("Created {} default milestone rewards", (Object)milestoneRewards.size());
    }

    public static void checkMilestones(ServerPlayer player, int oldCount, int newCount) {
        if (!rewardsEnabled) {
            return;
        }
        MinecraftServer server = player.getServer();
        if (server == null) {
            return;
        }
        for (Map.Entry<Integer, List<String>> entry : milestoneRewards.entrySet()) {
            int milestoneCount = entry.getKey();
            List<String> commands = entry.getValue();
            if (oldCount >= milestoneCount || newCount < milestoneCount) continue;
            WXMCWeatherAddon.LOGGER.info("Player {} reached milestone: {} tornadoes", (Object)player.getName().getString(), (Object)milestoneCount);
            for (String command : commands) {
                String processedCommand = command.replace("%player%", player.getName().getString());
                try {
                    server.getCommands().performPrefixedCommand(server.createCommandSourceStack(), processedCommand);
                    WXMCWeatherAddon.LOGGER.debug("Executed milestone command: {}", (Object)processedCommand);
                }
                catch (Exception e) {
                    WXMCWeatherAddon.LOGGER.error("Failed to execute milestone command '{}' for player {}: {}", new Object[]{processedCommand, player.getName().getString(), e.getMessage()});
                }
            }
        }
    }

    public static Set<Integer> getMilestones() {
        return milestoneRewards.keySet();
    }

    public static boolean isEnabled() {
        return rewardsEnabled;
    }

    public static Integer getNextMilestone(int currentCount) {
        return milestoneRewards.keySet().stream().filter(milestone -> milestone > currentCount).min(Integer::compareTo).orElse(null);
    }

    public static void reloadRewards() {
        WXMCWeatherAddon.LOGGER.info("Reloading milestone rewards configuration...");
        MilestoneRewards.loadRewards();
    }
}

