/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon;

import dev.wxmc.weatheraddon.warnings.WarningLevel;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Config {
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.DoubleValue REPORT_MAX_DISTANCE;
    public static final ModConfigSpec.DoubleValue REPORT_ANGLE_TOLERANCE;
    public static final ModConfigSpec.ConfigValue<String> COUNT_MESSAGE;
    public static final ModConfigSpec.ConfigValue<String> COUNT_MESSAGE_OTHER;
    public static final ModConfigSpec.ConfigValue<String> REPORT_SUCCESS_MESSAGE;
    public static final ModConfigSpec.ConfigValue<String> REPORT_COUNT_MESSAGE;
    public static final ModConfigSpec.ConfigValue<String> REPORT_ALREADY_SEEN_MESSAGE;
    public static final ModConfigSpec.ConfigValue<String> REPORT_NO_TORNADO_MESSAGE;
    public static final ModConfigSpec.BooleanValue WARNING_SYSTEM_ENABLED;
    public static final ModConfigSpec.BooleanValue PLAY_ALERT_SOUND;
    public static final ModConfigSpec.BooleanValue SHOW_CHAT_WARNINGS;
    public static final ModConfigSpec.BooleanValue SHOW_RADAR_POLYGONS;
    public static final ModConfigSpec.EnumValue<WarningLevel> MINIMUM_WARNING_LEVEL;
    public static final ModConfigSpec.IntValue WARNING_RADIUS;
    public static final ModConfigSpec.IntValue RADAR_DETECTION_RADIUS;
    public static final ModConfigSpec.DoubleValue POLYGON_REAR_BUFFER;
    public static final ModConfigSpec.DoubleValue POLYGON_FRONT_BUFFER;
    public static final ModConfigSpec.DoubleValue POLYGON_WOBBLE_BUFFER;
    public static final ModConfigSpec.DoubleValue POLYGON_MIN_PROJECTION;
    public static final ModConfigSpec.DoubleValue POLYGON_MAX_PROJECTION;
    public static final ModConfigSpec.DoubleValue SIREN_VOLUME;
    public static final ModConfigSpec.DoubleValue EAS_ALERT_VOLUME;
    public static final ModConfigSpec.IntValue WARNING_COOLDOWN;
    public static final ModConfigSpec.IntValue UPGRADE_COOLDOWN;
    public static final ModConfigSpec.BooleanValue REAL_WORLD_SOUNDINGS_ENABLED;
    public static final ModConfigSpec.IntValue SOUNDING_CHANGE_INTERVAL;
    public static final ModConfigSpec.BooleanValue SOUNDING_MATCH_RISK;
    public static final ModConfigSpec.BooleanValue DEBUG_MODE;
    public static final ModConfigSpec.BooleanValue VERBOSE_LOGGING;
    public static final ModConfigSpec.BooleanValue LOG_RADAR_SCANS;
    public static final ModConfigSpec.BooleanValue LOG_WARNING_DECISIONS;
    public static final ModConfigSpec.BooleanValue LOG_POLYGON_SYNCS;
    public static final ModConfigSpec.BooleanValue LOG_STORM_TRACKING;
    public static final ModConfigSpec.BooleanValue LOG_OCCLUSION_EVENTS;
    public static final ModConfigSpec.BooleanValue LOG_WARNING_SENDS;
    public static final ModConfigSpec.BooleanValue LOG_SOUNDING_DEBUG;

    public static boolean isDebugMode() {
        try {
            return (Boolean)DEBUG_MODE.get();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean isVerboseLogging() {
        try {
            return (Boolean)VERBOSE_LOGGING.get() != false || (Boolean)DEBUG_MODE.get() != false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean shouldLogRadarScans() {
        try {
            return (Boolean)LOG_RADAR_SCANS.get() != false || (Boolean)VERBOSE_LOGGING.get() != false || (Boolean)DEBUG_MODE.get() != false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean shouldLogWarningDecisions() {
        try {
            return (Boolean)LOG_WARNING_DECISIONS.get() != false || (Boolean)VERBOSE_LOGGING.get() != false || (Boolean)DEBUG_MODE.get() != false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean shouldLogPolygonSyncs() {
        try {
            return (Boolean)LOG_POLYGON_SYNCS.get() != false || (Boolean)VERBOSE_LOGGING.get() != false || (Boolean)DEBUG_MODE.get() != false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean shouldLogStormTracking() {
        try {
            return (Boolean)LOG_STORM_TRACKING.get() != false || (Boolean)VERBOSE_LOGGING.get() != false || (Boolean)DEBUG_MODE.get() != false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean shouldLogOcclusionEvents() {
        try {
            return (Boolean)LOG_OCCLUSION_EVENTS.get() != false || (Boolean)VERBOSE_LOGGING.get() != false || (Boolean)DEBUG_MODE.get() != false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean shouldLogWarningSends() {
        try {
            return (Boolean)LOG_WARNING_SENDS.get() != false || (Boolean)VERBOSE_LOGGING.get() != false || (Boolean)DEBUG_MODE.get() != false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean shouldLogSoundingDebug() {
        try {
            return (Boolean)LOG_SOUNDING_DEBUG.get() != false || (Boolean)VERBOSE_LOGGING.get() != false || (Boolean)DEBUG_MODE.get() != false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean shouldSendWarning(WarningLevel level) {
        if (!((Boolean)WARNING_SYSTEM_ENABLED.get()).booleanValue()) {
            return false;
        }
        return level.getPriority() >= ((WarningLevel)((Object)MINIMUM_WARNING_LEVEL.get())).getPriority();
    }

    public static long getWarningCooldownMs() {
        return (long)((Integer)WARNING_COOLDOWN.get()).intValue() * 1000L;
    }

    public static long getUpgradeCooldownMs() {
        return (long)((Integer)UPGRADE_COOLDOWN.get()).intValue() * 1000L;
    }

    public static boolean isRealWorldSoundingsEnabled() {
        try {
            return (Boolean)REAL_WORLD_SOUNDINGS_ENABLED.get();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static int getSoundingChangeIntervalMinutes() {
        try {
            return (Integer)SOUNDING_CHANGE_INTERVAL.get();
        }
        catch (IllegalStateException e) {
            return 5;
        }
    }

    public static boolean shouldMatchSoundingToRisk() {
        try {
            return (Boolean)SOUNDING_MATCH_RISK.get();
        }
        catch (IllegalStateException e) {
            return true;
        }
    }

    public static int getSoundingFetchIntervalMinutes() {
        return Config.getSoundingChangeIntervalMinutes();
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.comment(new String[]{"========================================", " TORNADO REPORTING", " Settings for the /report tornado command", "========================================"}).push("reporting");
        REPORT_MAX_DISTANCE = builder.comment("Maximum distance (in blocks) a player can report a tornado from").defineInRange("max_distance", 512.0, 100.0, 10000.0);
        REPORT_ANGLE_TOLERANCE = builder.comment(new String[]{"How many degrees off-center the player can be looking to report a tornado", "30 degrees means the tornado must be within 30 degrees of the player's crosshair"}).defineInRange("angle_tolerance", 30.0, 5.0, 90.0);
        builder.pop();
        builder.comment(new String[]{"========================================", " MESSAGES", " Customizable messages with & color codes", " Placeholders vary by message type", "========================================"}).push("messages");
        COUNT_MESSAGE = builder.comment(new String[]{"Message shown when checking your own count", "Placeholders: {count}, {player}"}).define("count_self", (Object)"&aYou have reported &e{count} &atornadoes.");
        COUNT_MESSAGE_OTHER = builder.comment(new String[]{"Message shown when checking another player's count", "Placeholders: {count}, {player}"}).define("count_other", (Object)"&e{player} &ahas reported &e{count} &atornadoes.");
        REPORT_SUCCESS_MESSAGE = builder.comment(new String[]{"Message sent when a player successfully reports a tornado", "Placeholders: {count} = total reports, {distance} = blocks away,", "             {windspeed} = wind in mph, {direction} = compass direction"}).define("report_success", (Object)"&aYou have reported a Tornado! &7({windspeed} mph, {distance} blocks {direction})");
        REPORT_COUNT_MESSAGE = builder.comment(new String[]{"Message shown after reporting a tornado showing total count", "Placeholders: {count} = total tornado reports"}).define("report_count", (Object)"&fYou have reported &e{count} &ftornadoes.");
        REPORT_ALREADY_SEEN_MESSAGE = builder.comment("Message sent when a player tries to report a tornado they already reported").define("report_already_seen", (Object)"&cYou have already reported this tornado.");
        REPORT_NO_TORNADO_MESSAGE = builder.comment("Message sent when no tornado is found in the player's view direction").define("report_no_tornado", (Object)"&cThere is no tornado to report\n&7&oTIP: If you're reporting a tornado, look directly at it, you also need to be within 512 blocks to report.");
        builder.pop();
        builder.comment(new String[]{"========================================", " WARNING SYSTEM", " NWS-style weather warnings", "========================================"}).push("warnings");
        builder.comment("General warning system settings").push("general");
        WARNING_SYSTEM_ENABLED = builder.comment("Enable or disable the entire warning system").define("enabled", true);
        MINIMUM_WARNING_LEVEL = builder.comment(new String[]{"Minimum warning level to display to players", "Options: NONE, STATEMENT, SVR_WARNING, SVR_PDS, SVR_DESTRUCTIVE,", "         TOR_INDICATED, TOR_CONFIRMED, TOR_PDS, TOR_EMERGENCY"}).defineEnum("minimum_level", (Enum)WarningLevel.STATEMENT);
        builder.pop();
        builder.comment("Warning display settings").push("display");
        PLAY_ALERT_SOUND = builder.comment("Play alert sounds when warnings are issued").define("play_sound", true);
        SHOW_CHAT_WARNINGS = builder.comment("Show warning messages in chat").define("show_chat", true);
        SHOW_RADAR_POLYGONS = builder.comment("Show warning polygons on radar displays").define("show_polygons", true);
        builder.pop();
        builder.comment("Warning range settings").push("range");
        WARNING_RADIUS = builder.comment("How far away players receive warnings (in blocks)").defineInRange("radius", 512, 64, 2048);
        RADAR_DETECTION_RADIUS = builder.comment(new String[]{"Radius (in blocks) to detect radar overlay blocks near players", "Radars within this range will receive polygon updates"}).defineInRange("radar_detection_radius", 24, 8, 64);
        builder.pop();
        builder.comment(new String[]{"NWS-style warning polygon sizing", "These values control the size and shape of warning polygons"}).push("polygons");
        POLYGON_REAR_BUFFER = builder.comment(new String[]{"Buffer behind the storm's dBZ core (in blocks)", "Extends polygon coverage behind the storm"}).defineInRange("rear_buffer", 200.0, 50.0, 500.0);
        POLYGON_FRONT_BUFFER = builder.comment(new String[]{"Buffer ahead of the storm projection (in blocks)", "Accounts for forecast uncertainty"}).defineInRange("front_buffer", 200.0, 50.0, 500.0);
        POLYGON_WOBBLE_BUFFER = builder.comment(new String[]{"Lateral buffer for storm drift (in blocks)", "Accounts for storm wobble and directional uncertainty"}).defineInRange("wobble_buffer", 80.0, 20.0, 200.0);
        POLYGON_MIN_PROJECTION = builder.comment("Minimum forward projection distance for slow/stationary storms (in blocks)").defineInRange("min_projection", 250.0, 100.0, 500.0);
        POLYGON_MAX_PROJECTION = builder.comment("Maximum forward projection distance cap (in blocks)").defineInRange("max_projection", 1200.0, 500.0, 3000.0);
        builder.pop();
        builder.comment("Warning timing settings").push("timing");
        WARNING_COOLDOWN = builder.comment("Minimum time between repeated warnings of the same level for the same storm (in seconds)").defineInRange("cooldown", 30, 5, 300);
        UPGRADE_COOLDOWN = builder.comment("Minimum time between warning upgrades for the same storm (in seconds)").defineInRange("upgrade_cooldown", 10, 1, 60);
        builder.pop();
        builder.comment("Volume settings for alerts and sirens").push("volume");
        SIREN_VOLUME = builder.comment("Volume for tornado sirens (0.0 = silent, 1.0 = normal, 4.0 = default loud)").defineInRange("siren_volume", 4.0, 0.0, 10.0);
        EAS_ALERT_VOLUME = builder.comment("Volume for EAS warning alert tones (0.0 = silent, 1.0 = normal)").defineInRange("eas_alert_volume", 1.0, 0.0, 5.0);
        builder.pop();
        builder.pop();
        builder.comment(new String[]{"========================================", " REAL-WORLD SOUNDINGS", " Server-side sounding data from JSON files", " Files are loaded from config/wxmc/soundings/<RISK>/", " Risk categories: HIGH, MDT, ENH, SLGT, MRGL, TSTM", "========================================"}).push("soundings");
        REAL_WORLD_SOUNDINGS_ENABLED = builder.comment(new String[]{"Enable real-world sounding data from server files", "When enabled, PMWeather's atmospheric sampling will use real data", "Soundings are loaded from config/wxmc/soundings/<RISK>/*.json"}).define("enabled", true);
        SOUNDING_CHANGE_INTERVAL = builder.comment(new String[]{"How often to potentially change the active sounding (in minutes)", "Server will pick a new random sounding from the appropriate category"}).defineInRange("change_interval_minutes", 5, 1, 60);
        SOUNDING_MATCH_RISK = builder.comment(new String[]{"Match sounding selection to PMWeather's atmospheric risk", "When true, server picks soundings from category matching current conditions", "When false, soundings are picked randomly from all categories"}).define("match_risk", true);
        builder.pop();
        builder.comment(new String[]{"========================================", " DEBUG & LOGGING", " Console output control - all disabled by default", " Enable these for troubleshooting issues", "========================================"}).push("debug");
        DEBUG_MODE = builder.comment(new String[]{"Master debug switch - enables all debug output", "WARNING: Very verbose! Only enable when troubleshooting"}).define("debug_mode", false);
        VERBOSE_LOGGING = builder.comment(new String[]{"Enable verbose logging for all warning system operations", "WARNING: This generates a LOT of console output!"}).define("verbose_logging", false);
        builder.comment("Individual logging categories - fine-grained control").push("logging");
        LOG_RADAR_SCANS = builder.comment("Log radar scan operations (every 3 seconds when enabled)").define("radar_scans", false);
        LOG_WARNING_DECISIONS = builder.comment(new String[]{"Log warning decision process for each storm", "Shows when warnings are issued, upgraded, or skipped"}).define("warning_decisions", false);
        LOG_POLYGON_SYNCS = builder.comment("Log polygon sync operations to radars").define("polygon_syncs", false);
        LOG_STORM_TRACKING = builder.comment(new String[]{"Log storm tracking updates from PMWeather", "Shows storm positions, stages, and velocities"}).define("storm_tracking", false);
        LOG_OCCLUSION_EVENTS = builder.comment("Log when tornadoes enter occlusion/cycling phase").define("occlusion_events", false);
        LOG_WARNING_SENDS = builder.comment("Log when warnings are sent to individual players").define("warning_sends", false);
        LOG_SOUNDING_DEBUG = builder.comment(new String[]{"Log detailed sounding system operations", "Shows: file loading, risk calculations, sounding selection,", "network syncs, and PMWeather injection status"}).define("sounding_debug", false);
        builder.pop();
        builder.pop();
        SPEC = builder.build();
    }
}

