/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class ColorUtils {
    private static final Pattern COLOR_CODE_PATTERN = Pattern.compile("&([0-9a-fk-or])");

    public static Component parseColorCodes(String input) {
        if (input == null || input.isEmpty()) {
            return Component.empty();
        }
        MutableComponent result = Component.empty();
        StringBuilder currentText = new StringBuilder();
        ChatFormatting currentColor = null;
        boolean bold = false;
        boolean italic = false;
        boolean underline = false;
        boolean strikethrough = false;
        boolean obfuscated = false;
        Matcher matcher = COLOR_CODE_PATTERN.matcher(input);
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                currentText.append(input, lastEnd, matcher.start());
            }
            if (!currentText.isEmpty()) {
                Style style = Style.EMPTY;
                if (currentColor != null) {
                    style = style.withColor(currentColor);
                }
                if (bold) {
                    style = style.withBold(Boolean.valueOf(true));
                }
                if (italic) {
                    style = style.withItalic(Boolean.valueOf(true));
                }
                if (underline) {
                    style = style.withUnderlined(Boolean.valueOf(true));
                }
                if (strikethrough) {
                    style = style.withStrikethrough(Boolean.valueOf(true));
                }
                if (obfuscated) {
                    style = style.withObfuscated(Boolean.valueOf(true));
                }
                result.append((Component)Component.literal((String)currentText.toString()).setStyle(style));
                currentText.setLength(0);
            }
            char code = matcher.group(1).charAt(0);
            switch (code) {
                case '0': {
                    currentColor = ChatFormatting.BLACK;
                    break;
                }
                case '1': {
                    currentColor = ChatFormatting.DARK_BLUE;
                    break;
                }
                case '2': {
                    currentColor = ChatFormatting.DARK_GREEN;
                    break;
                }
                case '3': {
                    currentColor = ChatFormatting.DARK_AQUA;
                    break;
                }
                case '4': {
                    currentColor = ChatFormatting.DARK_RED;
                    break;
                }
                case '5': {
                    currentColor = ChatFormatting.DARK_PURPLE;
                    break;
                }
                case '6': {
                    currentColor = ChatFormatting.GOLD;
                    break;
                }
                case '7': {
                    currentColor = ChatFormatting.GRAY;
                    break;
                }
                case '8': {
                    currentColor = ChatFormatting.DARK_GRAY;
                    break;
                }
                case '9': {
                    currentColor = ChatFormatting.BLUE;
                    break;
                }
                case 'a': {
                    currentColor = ChatFormatting.GREEN;
                    break;
                }
                case 'b': {
                    currentColor = ChatFormatting.AQUA;
                    break;
                }
                case 'c': {
                    currentColor = ChatFormatting.RED;
                    break;
                }
                case 'd': {
                    currentColor = ChatFormatting.LIGHT_PURPLE;
                    break;
                }
                case 'e': {
                    currentColor = ChatFormatting.YELLOW;
                    break;
                }
                case 'f': {
                    currentColor = ChatFormatting.WHITE;
                    break;
                }
                case 'k': {
                    obfuscated = true;
                    break;
                }
                case 'l': {
                    bold = true;
                    break;
                }
                case 'm': {
                    strikethrough = true;
                    break;
                }
                case 'n': {
                    underline = true;
                    break;
                }
                case 'o': {
                    italic = true;
                    break;
                }
                case 'r': {
                    currentColor = null;
                    obfuscated = false;
                    strikethrough = false;
                    underline = false;
                    italic = false;
                    bold = false;
                }
            }
            lastEnd = matcher.end();
        }
        if (lastEnd < input.length()) {
            currentText.append(input.substring(lastEnd));
        }
        if (!currentText.isEmpty()) {
            Style style = Style.EMPTY;
            if (currentColor != null) {
                style = style.withColor(currentColor);
            }
            if (bold) {
                style = style.withBold(Boolean.valueOf(true));
            }
            if (italic) {
                style = style.withItalic(Boolean.valueOf(true));
            }
            if (underline) {
                style = style.withUnderlined(Boolean.valueOf(true));
            }
            if (strikethrough) {
                style = style.withStrikethrough(Boolean.valueOf(true));
            }
            if (obfuscated) {
                style = style.withObfuscated(Boolean.valueOf(true));
            }
            result.append((Component)Component.literal((String)currentText.toString()).setStyle(style));
        }
        return result;
    }
}

