/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon;

import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.warnings.WarningLevel;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ClientConfig {
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.DoubleValue POLYGON_LINE_OPACITY;
    public static final ModConfigSpec.DoubleValue POLYGON_LINE_WIDTH;
    public static final ModConfigSpec.DoubleValue SIREN_MAX_VOLUME;
    public static final ModConfigSpec.DoubleValue SIREN_MIN_VOLUME;
    public static final ModConfigSpec.IntValue SIREN_MAX_RANGE;
    public static final ModConfigSpec.IntValue SIREN_FULL_VOLUME_RANGE;
    public static final ModConfigSpec.BooleanValue SIRENS_ENABLED;
    public static final ModConfigSpec.ConfigValue<String> COLOR_STATEMENT;
    public static final ModConfigSpec.ConfigValue<String> COLOR_SVR_WARNING;
    public static final ModConfigSpec.ConfigValue<String> COLOR_SVR_PDS;
    public static final ModConfigSpec.ConfigValue<String> COLOR_SVR_DESTRUCTIVE;
    public static final ModConfigSpec.ConfigValue<String> COLOR_TOR_INDICATED;
    public static final ModConfigSpec.ConfigValue<String> COLOR_TOR_CONFIRMED;
    public static final ModConfigSpec.ConfigValue<String> COLOR_TOR_PDS;
    public static final ModConfigSpec.ConfigValue<String> COLOR_TOR_EMERGENCY;

    public static float getPolygonOpacity() {
        try {
            return ((Double)POLYGON_LINE_OPACITY.get()).floatValue();
        }
        catch (IllegalStateException e) {
            return 0.7f;
        }
    }

    public static float getPolygonLineWidth() {
        try {
            return ((Double)POLYGON_LINE_WIDTH.get()).floatValue();
        }
        catch (IllegalStateException e) {
            return 0.015f;
        }
    }

    private static int parseHexColor(String hex, int defaultColor) {
        try {
            if (hex.startsWith("#")) {
                hex = hex.substring(1);
            }
            return Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException e) {
            WXMCWeatherAddon.LOGGER.warn("Invalid hex color '{}', using default", (Object)hex);
            return defaultColor;
        }
    }

    public static int getStatementColor() {
        try {
            return ClientConfig.parseHexColor((String)COLOR_STATEMENT.get(), 16770229);
        }
        catch (IllegalStateException e) {
            return 16770229;
        }
    }

    public static int getSvrWarningColor() {
        try {
            return ClientConfig.parseHexColor((String)COLOR_SVR_WARNING.get(), 16753920);
        }
        catch (IllegalStateException e) {
            return 16753920;
        }
    }

    public static int getSvrPdsColor() {
        try {
            return ClientConfig.parseHexColor((String)COLOR_SVR_PDS.get(), 16753920);
        }
        catch (IllegalStateException e) {
            return 16753920;
        }
    }

    public static int getSvrDestructiveColor() {
        try {
            return ClientConfig.parseHexColor((String)COLOR_SVR_DESTRUCTIVE.get(), 16753920);
        }
        catch (IllegalStateException e) {
            return 16753920;
        }
    }

    public static int getTorIndicatedColor() {
        try {
            return ClientConfig.parseHexColor((String)COLOR_TOR_INDICATED.get(), 0xFF0000);
        }
        catch (IllegalStateException e) {
            return 0xFF0000;
        }
    }

    public static int getTorConfirmedColor() {
        try {
            return ClientConfig.parseHexColor((String)COLOR_TOR_CONFIRMED.get(), 0xFF0000);
        }
        catch (IllegalStateException e) {
            return 0xFF0000;
        }
    }

    public static int getTorPdsColor() {
        try {
            return ClientConfig.parseHexColor((String)COLOR_TOR_PDS.get(), 0xFF0000);
        }
        catch (IllegalStateException e) {
            return 0xFF0000;
        }
    }

    public static int getTorEmergencyColor() {
        try {
            return ClientConfig.parseHexColor((String)COLOR_TOR_EMERGENCY.get(), 0xFF0000);
        }
        catch (IllegalStateException e) {
            return 0xFF0000;
        }
    }

    public static int getColorForLevel(WarningLevel level) {
        if (level == null) {
            return 0xFFFFFF;
        }
        try {
            return switch (level) {
                case WarningLevel.STATEMENT -> ClientConfig.getStatementColor();
                case WarningLevel.SVR_WARNING -> ClientConfig.getSvrWarningColor();
                case WarningLevel.SVR_PDS -> ClientConfig.getSvrPdsColor();
                case WarningLevel.SVR_DESTRUCTIVE -> ClientConfig.getSvrDestructiveColor();
                case WarningLevel.TOR_INDICATED -> ClientConfig.getTorIndicatedColor();
                case WarningLevel.TOR_CONFIRMED -> ClientConfig.getTorConfirmedColor();
                case WarningLevel.TOR_PDS -> ClientConfig.getTorPdsColor();
                case WarningLevel.TOR_EMERGENCY -> ClientConfig.getTorEmergencyColor();
                default -> 0xFFFFFF;
            };
        }
        catch (Exception e) {
            return 0xFFFFFF;
        }
    }

    public static boolean areSirensEnabled() {
        try {
            return (Boolean)SIRENS_ENABLED.get();
        }
        catch (IllegalStateException e) {
            return true;
        }
    }

    public static int getMaxRange() {
        try {
            return (Integer)SIREN_MAX_RANGE.get();
        }
        catch (IllegalStateException e) {
            return 256;
        }
    }

    public static float calculateVolumeMultiplier(double distance) {
        float minVol;
        int maxRange;
        int fullRange;
        try {
            fullRange = (Integer)SIREN_FULL_VOLUME_RANGE.get();
            maxRange = (Integer)SIREN_MAX_RANGE.get();
            minVol = ((Double)SIREN_MIN_VOLUME.get()).floatValue();
        }
        catch (IllegalStateException e) {
            fullRange = 32;
            maxRange = 256;
            minVol = 0.0f;
        }
        if (distance <= (double)fullRange) {
            return 1.0f;
        }
        if (distance >= (double)maxRange) {
            return 0.0f;
        }
        double attenuationRange = maxRange - fullRange;
        double distanceIntoAttenuation = distance - (double)fullRange;
        double falloffPercent = distanceIntoAttenuation / attenuationRange;
        double logFalloff = Math.log10(1.0 + 9.0 * falloffPercent) / Math.log10(10.0);
        return (float)((1.0 - logFalloff) * (1.0 - (double)minVol) + (double)minVol);
    }

    public static float getEffectiveVolume(double distance) {
        float maxVolume;
        try {
            maxVolume = ((Double)SIREN_MAX_VOLUME.get()).floatValue();
        }
        catch (IllegalStateException e) {
            maxVolume = 4.0f;
        }
        float multiplier = ClientConfig.calculateVolumeMultiplier(distance);
        return maxVolume * multiplier;
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.comment(new String[]{"========================================", " POLYGON DISPLAY", " Client-side settings for warning polygon appearance", "========================================"}).push("polygon_display");
        POLYGON_LINE_OPACITY = builder.comment("Opacity of polygon outline lines (0.0 = invisible, 1.0 = fully opaque)").defineInRange("line_opacity", 0.7, 0.0, 1.0);
        POLYGON_LINE_WIDTH = builder.comment("Width of polygon outline lines (default: 0.015)").defineInRange("line_width", 0.015, 0.005, 0.1);
        builder.pop();
        builder.comment(new String[]{"========================================", " SIREN RANGE", " Distance-based volume attenuation for tornado sirens", "========================================"}).push("siren_range");
        SIRENS_ENABLED = builder.comment("Enable tornado sirens").define("enabled", true);
        SIREN_MAX_VOLUME = builder.comment(new String[]{"Maximum volume for sirens at full volume range", "0.0 = silent, 1.0 = normal, 4.0 = loud (default)"}).defineInRange("max_volume", 4.0, 0.0, 10.0);
        SIREN_MIN_VOLUME = builder.comment(new String[]{"Minimum volume at the edge of siren range (before becoming silent)", "0.0 = completely silent at edge"}).defineInRange("min_volume", 0.05, 0.0, 1.0);
        SIREN_MAX_RANGE = builder.comment(new String[]{"Maximum distance (in blocks) at which sirens can be heard", "Beyond this range, the siren is silent"}).defineInRange("max_range", 256, 32, 1024);
        SIREN_FULL_VOLUME_RANGE = builder.comment(new String[]{"Distance (in blocks) within which sirens play at full volume", "Volume begins to decrease beyond this range"}).defineInRange("full_volume_range", 32, 8, 256);
        builder.pop();
        builder.comment(new String[]{"========================================", " WARNING COLORS", " Customize polygon colors for each warning type", " Use HEX color codes without the # symbol", " Examples: FF0000 (red), 00FF00 (green), 0000FF (blue)", "========================================"}).push("warning_colors");
        COLOR_STATEMENT = builder.comment(new String[]{"Color for Special Weather Statement polygons", "Default: FFE4B5 (Moccasin/tan)"}).define("statement", (Object)"FFE4B5");
        COLOR_SVR_WARNING = builder.comment(new String[]{"Color for Severe Thunderstorm Warning polygons", "Default: FFA500 (Orange)"}).define("svr_warning", (Object)"FFA500");
        COLOR_SVR_PDS = builder.comment(new String[]{"Color for Severe Thunderstorm Warning - PDS polygons", "Default: FFA500 (Orange)"}).define("svr_pds", (Object)"FFA500");
        COLOR_SVR_DESTRUCTIVE = builder.comment(new String[]{"Color for Severe Thunderstorm Warning - Destructive polygons", "Default: FFA500 (Orange)"}).define("svr_destructive", (Object)"FFA500");
        COLOR_TOR_INDICATED = builder.comment(new String[]{"Color for Tornado Warning - Radar Indicated polygons", "Default: FF0000 (Red)"}).define("tor_indicated", (Object)"FF0000");
        COLOR_TOR_CONFIRMED = builder.comment(new String[]{"Color for Tornado Warning - Confirmed polygons", "Default: FF0000 (Red)"}).define("tor_confirmed", (Object)"FF0000");
        COLOR_TOR_PDS = builder.comment(new String[]{"Color for Tornado Warning - PDS polygons", "Default: FF0000 (Red)"}).define("tor_pds", (Object)"FF0000");
        COLOR_TOR_EMERGENCY = builder.comment(new String[]{"Color for Tornado Emergency polygons", "Default: FF0000 (Red)"}).define("tor_emergency", (Object)"FF0000");
        builder.pop();
        SPEC = builder.build();
    }
}

