/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data.entity;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.level.Level;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.PlatformAPI;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;

public interface ILootrCart
extends ILootrInfoProvider {
    @Override
    default public ILootrInfo.LootrInfoType getInfoType() {
        return ILootrInfo.LootrInfoType.CONTAINER_ENTITY;
    }

    default public VehicleEntity asEntity() {
        ILootrCart iLootrCart = this;
        if (iLootrCart instanceof VehicleEntity) {
            VehicleEntity entity = (VehicleEntity)iLootrCart;
            return entity;
        }
        throw new IllegalStateException("asEntity called on non-VehicleEntity ILootrCart");
    }

    @Override
    default public void performOpen(ServerPlayer player) {
        PlatformAPI.performCartOpen(this, player);
    }

    @Override
    default public void performOpen() {
        PlatformAPI.performCartOpen(this);
    }

    @Override
    default public void performClose(ServerPlayer player) {
        PlatformAPI.performCartClose(this, player);
    }

    @Override
    default public void performClose() {
        PlatformAPI.performCartClose(this);
    }

    @Override
    default public void performDecay() {
        MinecartChest newCart;
        Level level = this.getInfoLevel();
        if (level == null || level.isClientSide()) {
            return;
        }
        boolean replaceWhenDecayed = LootrAPI.shouldReplaceWhenDecayed();
        VehicleEntity entity = this.asEntity();
        if (replaceWhenDecayed && (newCart = (MinecartChest)EntityType.CHEST_MINECART.create(level)) != null) {
            newCart.setPos(entity.position());
            newCart.setXRot(entity.getXRot());
            newCart.setYRot(entity.getYRot());
            level.addFreshEntity((Entity)newCart);
        }
        entity.discard();
    }
}

