/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Sounds;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.inventory.VehicleInventoryDescription;
import immersive_aircraft.entity.inventory.slots.SlotDescription;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_aircraft.network.c2s.EnginePowerMessage;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import immersive_aircraft.util.InterpolatedFloat;
import immersive_aircraft.util.Utils;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public abstract class EngineVehicle
extends InventoryVehicleEntity {
    protected static final EntityDataAccessor<Float> ENGINE = SynchedEntityData.defineId(EngineVehicle.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> UTILIZATION = SynchedEntityData.defineId(EngineVehicle.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> LOW_ON_FUEL = SynchedEntityData.defineId(EngineVehicle.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final InterpolatedFloat engineRotation = new InterpolatedFloat();
    public final InterpolatedFloat enginePower = new InterpolatedFloat(20.0f);
    public float engineSpinUpStrength = 0.0f;
    public float engineSound = 0.0f;
    FuelState lastFuelState = FuelState.NEVER;
    public static final int TARGET_FUEL = 1000;
    public static final int LOW_FUEL = 900;
    private final int[] fuel = new int[this.getInventoryDescription().getSlots(VehicleInventoryDescription.BOILER).size()];
    private int shutdownDelay = 0;
    private static final int SHUTDOWN_GRACE_TICKS = 10;

    public GUI_STYLE getGuiStyle() {
        return GUI_STYLE.ENGINE;
    }

    public EngineVehicle(EntityType<? extends EngineVehicle> entityType, Level world, boolean canExplodeOnCrash) {
        super((EntityType<? extends InventoryVehicleEntity>)entityType, world, canExplodeOnCrash);
    }

    protected SoundEvent getEngineStartSound() {
        return Sounds.ENGINE_START.get();
    }

    protected SoundEvent getEngineSound() {
        return Sounds.PROPELLER.get();
    }

    protected float getEngineVolume() {
        return 0.25f;
    }

    protected float getEnginePitch() {
        return 1.0f;
    }

    protected float getEngineReactionSpeed() {
        return 20.0f;
    }

    public boolean worksUnderWater() {
        return false;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder entityData) {
        super.defineSynchedData(entityData);
        entityData.define(ENGINE, (Object)Float.valueOf(0.0f));
        entityData.define(UTILIZATION, (Object)Float.valueOf(0.0f));
        entityData.define(LOW_ON_FUEL, (Object)false);
    }

    @Override
    public void tick() {
        super.tick();
        this.enginePower.setSteps(this.getEngineReactionSpeed() / this.getProperties().get(VehicleStat.ACCELERATION));
        this.enginePower.update(this.getEngineTarget() * (this.isInWater() && !this.worksUnderWater() ? 0.1f : 1.0f));
        this.engineSpinUpStrength = Math.max(0.0f, this.engineSpinUpStrength + this.enginePower.getDiff() - 0.01f);
        if (this.level().isClientSide()) {
            this.engineRotation.update((this.engineRotation.getValue() + this.getPropellerSpeed()) % 1000.0f);
        }
        if (!this.level().isClientSide) {
            if (!this.isVehicle() && !(this.getEngineTarget() <= 0.0f)) {
                ++this.shutdownDelay;
                if (this.shutdownDelay > 10) {
                    this.setEngineTarget(0.0f);
                    this.shutdownDelay = 0;
                }
            } else {
                this.shutdownDelay = 0;
            }
        }
        if (this.level().isClientSide) {
            this.engineSound += this.getEnginePower() * 0.25f;
            if (this.engineSound > 1.0f) {
                this.engineSound -= 1.0f;
                if (this.isFuelLow()) {
                    this.engineSound -= (float)this.random.nextInt(2);
                }
                this.level().playLocalSound(this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), this.getEngineSound(), this.getSoundSource(), Math.min(1.0f, this.getEngineVolume() + this.engineSpinUpStrength), (this.random.nextFloat() * 0.1f + 0.95f) * this.getEnginePitch(), false);
            }
        }
        if (this.fuel.length > 0 && !this.level().isClientSide) {
            float consumption = this.getFuelConsumption();
            this.consumeFuel(consumption);
        }
        if (this.isVehicle()) {
            if (!this.level().isClientSide()) {
                this.refuel();
                LivingEntity livingEntity = this.getControllingPassenger();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)livingEntity;
                    float utilization = this.getFuelUtilization();
                    if (utilization > 0.0f && this.isFuelLow()) {
                        if (this.lastFuelState != FuelState.LOW) {
                            player.displayClientMessage((Component)Component.translatable((String)("immersive_aircraft." + this.getFuelType() + ".low")), true);
                            this.lastFuelState = FuelState.LOW;
                        }
                    } else if (utilization > 0.0f) {
                        this.lastFuelState = FuelState.FUELED;
                    } else if (this.lastFuelState != FuelState.EMPTY) {
                        player.displayClientMessage((Component)Component.translatable((String)("immersive_aircraft." + this.getFuelType() + "." + (this.lastFuelState == FuelState.FUELED ? "out" : "none"))), true);
                        this.lastFuelState = FuelState.EMPTY;
                    }
                }
            }
        } else {
            this.lastFuelState = FuelState.NEVER;
        }
    }

    public float consumeFuel(float consumption) {
        while (consumption > 0.0f && (consumption >= 1.0f || this.random.nextFloat() < consumption)) {
            for (int i = 0; i < this.fuel.length; ++i) {
                if (this.fuel[i] <= 0) continue;
                int n = i;
                this.fuel[n] = this.fuel[n] - 1;
            }
            consumption -= 1.0f;
        }
        return consumption;
    }

    public float getPropellerSpeed() {
        return this.getEnginePower();
    }

    public boolean isFuelLow() {
        if (!Config.getInstance().burnFuelInCreative && this.isPilotCreative()) {
            return false;
        }
        if (this.level().isClientSide) {
            return (Boolean)this.entityData.get(LOW_ON_FUEL);
        }
        boolean low = true;
        for (int i : this.fuel) {
            if (i <= 900) continue;
            low = false;
            break;
        }
        this.entityData.set(LOW_ON_FUEL, (Object)low);
        return low;
    }

    public String getFuelType() {
        return "fuel";
    }

    public float getFuelConsumption() {
        return this.getEngineTarget() * this.getProperties().get(VehicleStat.FUEL) * Config.getInstance().fuelConsumption;
    }

    private void refuel(int i) {
        ItemStack stack;
        int time;
        List<SlotDescription> slots = this.getInventoryDescription().getSlots(VehicleInventoryDescription.BOILER);
        while (this.fuel[i] <= 1000 && i < slots.size() && (time = Utils.getFuelTime(stack = this.getInventory().getItem(slots.get(i).index()))) > 0) {
            int n = i;
            this.fuel[n] = this.fuel[n] + time;
            Item item = stack.getItem();
            stack.shrink(1);
            if (!stack.isEmpty()) continue;
            Item remainingItem = item.getCraftingRemainingItem();
            this.getInventory().setItem(slots.get(i).index(), remainingItem == null ? ItemStack.EMPTY : new ItemStack((ItemLike)remainingItem));
        }
    }

    private void refuel() {
        for (int i = 0; i < this.fuel.length; ++i) {
            this.refuel(i);
        }
    }

    public float getEnginePower() {
        return (float)((double)this.enginePower.getSmooth() * Math.sqrt(this.getFuelUtilization()));
    }

    public float getEngineTarget() {
        return ((Float)this.entityData.get(ENGINE)).floatValue();
    }

    public void setEngineTarget(float engineTarget) {
        if (this.getFuelUtilization() > 0.0f || engineTarget == 0.0f) {
            if (this.level().isClientSide) {
                if (this.getEngineTarget() != engineTarget) {
                    NetworkHandler.sendToServer(new EnginePowerMessage(engineTarget));
                }
                if (this.getFuelUtilization() > 0.0f && (double)this.getEngineTarget() == 0.0 && engineTarget > 0.0f) {
                    this.level().playLocalSound(this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), this.getEngineStartSound(), this.getSoundSource(), 1.5f, this.getEnginePitch(), false);
                }
            }
            this.entityData.set(ENGINE, (Object)Float.valueOf(engineTarget));
        }
    }

    public float getFuelUtilization() {
        if (Config.getInstance().fuelConsumption == 0.0f) {
            return 1.0f;
        }
        if (!Config.getInstance().burnFuelInCreative && this.isPilotCreative()) {
            return 1.0f;
        }
        if (this.fuel.length == 0) {
            return 1.0f;
        }
        if (this.level().isClientSide) {
            return ((Float)this.entityData.get(UTILIZATION)).floatValue();
        }
        int running = 0;
        for (int i : this.fuel) {
            if (i <= 0) continue;
            ++running;
        }
        float utilization = (float)running / (float)this.fuel.length * (this.isFuelLow() ? 0.75f : 1.0f);
        this.entityData.set(UTILIZATION, (Object)Float.valueOf(utilization));
        return utilization;
    }

    public void emitSmokeParticle(float x, float y, float z, float nx, float ny, float nz) {
        if (!this.isWithinParticleRange() || !this.level().isClientSide) {
            return;
        }
        Matrix4f transform = this.getVehicleTransform();
        Matrix3f normalTransform = this.getVehicleNormalTransform();
        float power = this.getEnginePower();
        if ((double)power > 0.05) {
            int i = 0;
            while ((float)i < 1.0f + this.engineSpinUpStrength * 4.0f) {
                Vector4f p = this.transformPosition(transform, x, y, z);
                Vector3f vel = this.transformVector(normalTransform, nx, ny, nz);
                Vec3 velocity = this.getDeltaMovement();
                if ((double)this.random.nextFloat() < (double)this.engineSpinUpStrength * 0.1) {
                    vel.mul(0.5f);
                    this.level().addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, (double)p.x(), (double)p.y(), (double)p.z(), (double)vel.x() + velocity.x, (double)vel.y() + velocity.y, (double)vel.z() + velocity.z);
                } else {
                    this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)p.x, (double)p.y, (double)p.z, (double)vel.x + velocity.x, (double)vel.y + velocity.y, (double)vel.z + velocity.z);
                }
                ++i;
            }
        }
    }

    @Override
    protected void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        for (int i = 0; i < this.fuel.length; ++i) {
            tag.putInt("Fuel" + i, this.fuel[i]);
        }
    }

    @Override
    protected void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        for (int i = 0; i < this.fuel.length; ++i) {
            this.fuel[i] = tag.getInt("Fuel" + i);
        }
    }

    @Override
    public void setAnimationVariables(float tickDelta) {
        super.setAnimationVariables(tickDelta);
        BBAnimationVariables.set("engine_rotation", this.engineRotation.getSmooth(tickDelta));
    }

    public static enum GUI_STYLE {
        NONE,
        ENGINE;

    }

    protected static enum FuelState {
        NEVER,
        EMPTY,
        FUELED,
        LOW;

    }
}

