/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import vectorwing.farmersdelight.client.renderer.CanvasSignRenderer;
import vectorwing.farmersdelight.common.block.state.CanvasSign;
import vectorwing.farmersdelight.common.registry.ModAtlases;

public class HangingCanvasSignRenderer
extends CanvasSignRenderer {
    private static final Vec3 TEXT_OFFSET = new Vec3(0.0, (double)-0.32f, (double)0.073f);
    private final HangingSignRenderer.HangingSignModel signModel;

    public HangingCanvasSignRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.signModel = new HangingSignRenderer.HangingSignModel(context.bakeLayer(ModelLayers.createHangingSignModelName((WoodType)WoodType.SPRUCE)));
    }

    public float getSignModelRenderScale() {
        return 1.0f;
    }

    public float getSignTextRenderScale() {
        return 0.8f;
    }

    @Override
    public void render(SignBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState state = blockEntity.getBlockState();
        SignBlock block = (SignBlock)state.getBlock();
        HangingSignRenderer.HangingSignModel model = this.signModel;
        model.evaluateVisibleParts(state);
        DyeColor dye = null;
        if (block instanceof CanvasSign) {
            CanvasSign canvasSign = (CanvasSign)block;
            dye = canvasSign.getBackgroundColor();
        }
        this.renderSignWithText(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, state, block, dye, (Model)model);
    }

    @Override
    protected void translateSign(PoseStack poseStack, float angle, BlockState state) {
        poseStack.translate(0.5, 0.9375, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(angle));
        poseStack.translate(0.0f, -0.3125f, 0.0f);
    }

    @Override
    protected void renderSignModel(PoseStack poseStack, int packedLight, int packedOverlay, Model model, VertexConsumer vertexConsumer) {
        HangingSignRenderer.HangingSignModel hangingSignModel = (HangingSignRenderer.HangingSignModel)model;
        hangingSignModel.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    @Override
    public Material getCanvasSignMaterial(@Nullable DyeColor dyeColor) {
        return ModAtlases.getHangingCanvasSignMaterial(dyeColor);
    }

    @Override
    public int getCustomVerticalOffset() {
        return 0;
    }

    @Override
    Vec3 getTextOffset() {
        return TEXT_OFFSET;
    }
}

