/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.sodiumcoreshadersupport.mixin;

import de.linusdev.sodiumcoreshadersupport.CommonClass;
import de.linusdev.sodiumcoreshadersupport.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.caffeinemc.mods.sodium.client.gl.shader.GlShader;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderConstants;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderLoader;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShaderLoader.class})
public class MixinShaderLoader {
    @Inject(at={@At(value="HEAD")}, method={"loadShader"})
    private static void loadShaderInject(ShaderType type, ResourceLocation name, ShaderConstants constants, CallbackInfoReturnable<GlShader> cir) {
        Constants.LOG.info("Start loading shader in namespace '" + name.getNamespace() + "': " + name.getPath());
    }

    @Overwrite
    public static String getShaderSource(ResourceLocation name) {
        Map<String, Resource> nameSpace = CommonClass.shaders.get(name.getNamespace());
        if (nameSpace == null) {
            throw new RuntimeException("No Shaders available for namespace '" + name.getNamespace() + "'");
        }
        Resource shaderResource = nameSpace.get(name.getPath());
        if (shaderResource == null) {
            throw new RuntimeException("No Shader found in namespace '" + name.getNamespace() + "' for shader '" + name.getPath() + "'");
        }
        try {
            Constants.LOG.info("Loaded Shader '{}:{}' from pack '{}'.", new Object[]{name.getNamespace(), name.getPath(), shaderResource.source().location().title().getString()});
            return IOUtils.toString((InputStream)shaderResource.open(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while reading shader source in namespace '" + name.getNamespace() + "' for shader '" + name.getPath() + "'", e);
        }
    }
}

