/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.sodiumcoreshadersupport.mixin;

import de.linusdev.sodiumcoreshadersupport.CommonClass;
import de.linusdev.sodiumcoreshadersupport.PackSodiumCompReturn;
import de.linusdev.sodiumcoreshadersupport.mixin.MixinAbstractPack;
import de.linusdev.sodiumcoreshadersupport.mixin.MixinPackListWidget;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.client.gui.screens.packs.TransferableSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.packs.repository.Pack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TransferableSelectionList.PackEntry.class})
public abstract class MixinResourcePackEntry {
    @Shadow
    @Final
    private PackSelectionModel.Entry pack;
    @Shadow
    @Final
    protected Minecraft minecraft;
    @Shadow
    @Final
    private TransferableSelectionList parent;

    @Inject(at={@At(value="HEAD")}, method={"handlePackSelection"}, cancellable=true)
    private void enable(CallbackInfoReturnable<Boolean> cir) {
        Pack resProfile = ((MixinAbstractPack)this.pack).getPack();
        PackSodiumCompReturn ret = CommonClass.isResourcePackCompatible(resProfile);
        switch (ret.compatibility()) {
            case COMPATIBLE: {
                break;
            }
            case NOT_COMPATIBLE: {
                String title = "Compatible minecraft versions:";
                assert (ret.minecraftVersions() != null);
                String msg = ret.minecraftVersions().stream().reduce((string, string2) -> string + ", " + string2).orElse("none");
                if (ret.correctMcVersionIndex() != null) {
                    title = "Compatible sodium versions for current minecraft version:";
                    assert (ret.sodiumVersions() != null);
                    Optional sMsg = ret.sodiumVersions().stream().reduce((string, string2) -> string + ", " + string2);
                    msg = sMsg.orElseGet(() -> ret.minecraftVersions().stream().filter(string -> !string.equals(ret.minecraftVersions().get(ret.correctMcVersionIndex()))).reduce((string, string2) -> string + ", " + string2).orElse("none"));
                }
                this.minecraft.setScreen((Screen)new ConfirmScreen(confirmed -> {
                    this.minecraft.setScreen((Screen)((MixinPackListWidget)this.parent).getScreen());
                    if (confirmed) {
                        this.pack.select();
                    }
                }, Component.nullToEmpty((String)"Resourcepack not compatible with current sodium or minecraft version."), Component.nullToEmpty((String)(title + " " + msg)), (Component)Component.literal((String)"Enable Anyway").setStyle(Style.EMPTY.withColor(0xFF0000)), Component.nullToEmpty((String)"OK")));
                cir.setReturnValue((Object)false);
                cir.cancel();
                break;
            }
            case MISSING_INFORMATION: {
                this.minecraft.setScreen((Screen)new ConfirmScreen(confirmed -> {
                    this.minecraft.setScreen((Screen)((MixinPackListWidget)this.parent).getScreen());
                    if (confirmed) {
                        this.pack.select();
                    }
                }, Component.nullToEmpty((String)"Warning"), Component.nullToEmpty((String)"This resourcepack overwrites shaders, but does not specify compatibility with sodium core shaders. It is most likely not compatible. Do you want to enable it anyway?")));
                cir.setReturnValue((Object)false);
                cir.cancel();
                break;
            }
            case MALFORMED_INFORMATION: {
                this.minecraft.setScreen((Screen)new ConfirmScreen(confirmed -> {
                    this.minecraft.setScreen((Screen)((MixinPackListWidget)this.parent).getScreen());
                    if (confirmed) {
                        this.pack.select();
                    }
                }, Component.nullToEmpty((String)"Warning"), Component.nullToEmpty((String)"This resourcepack contains malformed information about its compatibility (see log). Do you want to enable it anyway?")));
                cir.setReturnValue((Object)false);
                cir.cancel();
            }
        }
    }
}

