/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.sodiumcoreshadersupport;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.linusdev.sodiumcoreshadersupport.Constants;
import de.linusdev.sodiumcoreshadersupport.PackSodiumCompReturn;
import de.linusdev.sodiumcoreshadersupport.PackSodiumCompatibility;
import de.linusdev.sodiumcoreshadersupport.mixin.MixinPack;
import de.linusdev.sodiumcoreshadersupport.platform.Services;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class CommonClass {
    public static Map<String, Map<String, Resource>> shaders;

    public static void init() {
        Constants.LOG.info("Hello from Common init on {}! we are currently in a {} environment!", (Object)Services.PLATFORM.getPlatformName(), (Object)Services.PLATFORM.getEnvironmentName());
        Constants.LOG.info("The ID for diamonds is {}", (Object)BuiltInRegistries.ITEM.getKey((Object)Items.DIAMOND));
        if (Services.PLATFORM.isModLoaded("sodium")) {
            Constants.LOG.info("Sodium version " + Services.PLATFORM.getModVersion("sodium"));
        }
    }

    public static void reloadShaders(@NotNull ResourceManager manager) {
        Constants.LOG.info("Loading shaders...");
        shaders = new HashMap<String, Map<String, Resource>>();
        manager.listResourceStacks("shaders", path -> true).forEach((identifier, resources) -> {
            Map nameSpace = shaders.computeIfAbsent(identifier.getNamespace(), k -> new HashMap());
            nameSpace.put(identifier.getPath().substring("shaders/".length()), (Resource)resources.getLast());
        });
        shaders.forEach((nameSpace, map) -> {
            System.out.println("nameSpace: " + nameSpace);
            map.forEach((path, resource) -> System.out.println("    " + path + ": " + resource.source().location().title().getString()));
        });
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PackSodiumCompReturn isResourcePackCompatible(Pack resProfile) {
        block34: {
            Constants.LOG.info("Checking resourcepack compatibility to sodium");
            if (!Services.PLATFORM.isModLoaded("sodium")) {
                Constants.LOG.info("Sodium not loaded -> COMPATIBLE");
                return new PackSodiumCompReturn(PackSodiumCompatibility.COMPATIBLE, null, null, null);
            }
            currentGameVersion = SharedConstants.getCurrentVersion();
            sodiumVersion = Services.PLATFORM.getModVersion("sodium");
            resourceSupplier = ((MixinPack)resProfile).getResourceSupplier();
            sodiumVersions = new ArrayList<String>();
            minecraftVersions = new ArrayList<String>();
            correctMcVersionIndex = null;
            mcVersionIndex = 0;
            try {
                res = resourceSupplier.openPrimary(resProfile.location());
                try {
                    hasShaders = new AtomicBoolean(false);
                    res.listResources(PackType.CLIENT_RESOURCES, "minecraft", "shaders", (PackResources.ResourceOutput)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$isResourcePackCompatible$5(java.util.concurrent.atomic.AtomicBoolean net.minecraft.resources.ResourceLocation net.minecraft.server.packs.resources.IoSupplier ), (Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/server/packs/resources/IoSupplier;)V)((AtomicBoolean)hasShaders));
                    if (!hasShaders.get()) {
                        Constants.LOG.info("Pack does not contain shaders -> COMPATIBLE");
                        var10_12 = new PackSodiumCompReturn(PackSodiumCompatibility.COMPATIBLE, null, null, null);
                        return var10_12;
                    }
                    streamSup = res.getResource(PackType.CLIENT_RESOURCES, ResourceLocation.fromNamespaceAndPath((String)"sodiumcoreshadersupport", (String)"versions.json"));
                    if (streamSup == null) {
                        Constants.LOG.info("Pack does not contain a versions.json -> MISSING_INFORMATION");
                        var11_15 = new PackSodiumCompReturn(PackSodiumCompatibility.MISSING_INFORMATION, null, null, null);
                        return var11_15;
                    }
                    reader = new BufferedReader(new InputStreamReader((InputStream)streamSup.get(), StandardCharsets.UTF_8));
                    element = JsonParser.parseReader((Reader)reader);
                    if (element == null || !element.isJsonObject()) {
                        Constants.LOG.warn("{} has an invalid versions.json: first element must be json object ({...}) -> MALFORMED_INFORMATION", (Object)resProfile.getId());
                        var13_19 = new PackSodiumCompReturn(PackSodiumCompatibility.MALFORMED_INFORMATION, null, null, null);
                        return var13_19;
                    }
                    if ((element = element.getAsJsonObject().get("supported-versions")) == null || !element.isJsonObject()) {
                        Constants.LOG.warn("{} has an invalid versions.json: missing 'supported-versions' json element -> MALFORMED_INFORMATION", (Object)resProfile.getId());
                        var13_20 = new PackSodiumCompReturn(PackSodiumCompatibility.MALFORMED_INFORMATION, null, null, null);
                        return var13_20;
                    }
                    for (Map.Entry<K, V> entry : element.getAsJsonObject().asMap().entrySet()) {
                        block35: {
                            if (!((JsonElement)entry.getValue()).isJsonArray()) {
                                Constants.LOG.warn("{} has an invalid versions.json: sodium versions must be specified as array -> MALFORMED_INFORMATION", (Object)resProfile.getId());
                                var15_24 = new PackSodiumCompReturn(PackSodiumCompatibility.MALFORMED_INFORMATION, null, null, null);
                                return var15_24;
                            }
                            minecraftVersions.add((String)entry.getKey());
                            if (!((String)entry.getKey()).equals(currentGameVersion.getName())) break block35;
                            correctMcVersionIndex = mcVersionIndex;
                            var15_25 = ((JsonElement)entry.getValue()).getAsJsonArray().iterator();
                            ** GOTO lbl55
                        }
                        ++mcVersionIndex;
                    }
                    break block34;
                    finally {
                        reader.close();
lbl55:
                        // 2 sources

                        while (var15_25.hasNext()) {
                            ele = (JsonElement)var15_25.next();
                            if (!ele.isJsonPrimitive() || !ele.getAsJsonPrimitive().isString()) {
                                Constants.LOG.warn("{} has an invalid versions.json: sodium versions array must contain strings -> MALFORMED_INFORMATION", (Object)resProfile.getId());
                                var17_27 = new PackSodiumCompReturn(PackSodiumCompatibility.MALFORMED_INFORMATION, null, null, null);
                                return var17_27;
                            }
                            sodiumVersions.add(ele.getAsJsonPrimitive().getAsString());
                            if (!sodiumVersion.equals(ele.getAsJsonPrimitive().getAsString())) continue;
                            Constants.LOG.info("pack is COMPATIBLE!");
                            var17_28 = new PackSodiumCompReturn(PackSodiumCompatibility.COMPATIBLE, null, null, null);
                            return var17_28;
                        }
                    }
                }
                finally {
                    if (res != null) {
                        res.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Constants.LOG.info("No version match found -> NOT_COMPATIBLE!");
        return new PackSodiumCompReturn(PackSodiumCompatibility.NOT_COMPATIBLE, sodiumVersions, minecraftVersions, correctMcVersionIndex);
    }

    private static /* synthetic */ void lambda$isResourcePackCompatible$5(AtomicBoolean hasShaders, ResourceLocation identifier, IoSupplier inputStreamInputSupplier) {
        hasShaders.set(true);
    }
}

