/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.util.List;
import mekanism.api.energy.IEnergyContainer;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.button.PacketTileButtonPress;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorController;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public abstract class GuiFusionReactorInfo
extends GuiMekanismTile<TileEntityFusionReactorController, EmptyTileContainer<TileEntityFusionReactorController>> {
    protected GuiFusionReactorInfo(EmptyTileContainer<TileEntityFusionReactorController> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.imageWidth += 10;
        this.titleLabelY = 5;
    }

    protected void addGuiElements() {
        super.addGuiElements();
        ((MekanismImageButton)this.addRenderableWidget((GuiElement)new MekanismImageButton((IGuiWrapper)this, 6, 6, 14, this.getButtonLocation("back"), (element, mouseX, mouseY) -> PacketUtils.sendToServer((CustomPacketPayload)new PacketTileButtonPress(PacketTileButtonPress.ClickedTileButton.BACK_BUTTON, (BlockEntity)((GuiFusionReactorInfo)element.gui()).tile))))).setTooltip(TooltipUtils.BACK);
        this.addRenderableWidget((GuiElement)new GuiEnergyTab((IGuiWrapper)this, () -> {
            FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock();
            return List.of(MekanismLang.STORING.translate(new Object[]{EnergyDisplay.of((IEnergyContainer)multiblock.energyContainer)}), GeneratorsLang.PRODUCING_AMOUNT.translate(new Object[]{EnergyDisplay.of((long)multiblock.getPassiveGeneration(false, true))}));
        }));
        this.addRenderableWidget((GuiElement)new GuiHeatTab((IGuiWrapper)this, () -> {
            FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock();
            Component transfer = MekanismUtils.getTemperatureDisplay((double)multiblock.lastTransferLoss, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)false);
            Component environment = MekanismUtils.getTemperatureDisplay((double)multiblock.lastEnvironmentLoss, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)false);
            return List.of(MekanismLang.TRANSFERRED_RATE.translate(new Object[]{transfer}), MekanismLang.DISSIPATED_RATE.translate(new Object[]{environment}));
        }));
    }

    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleTextWithOffset(guiGraphics, 18);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

