/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.util.Collections;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiDynamicHorizontalRateBar;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.network.PacketUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.InputValidator;
import mekanism.common.util.text.TextUtils;
import mekanism.generators.client.gui.element.GuiFissionReactorTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.network.to_server.PacketGeneratorsGuiInteract;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class GuiFissionReactorStats
extends GuiMekanismTile<TileEntityFissionReactorCasing, EmptyTileContainer<TileEntityFissionReactorCasing>> {
    private GuiTextField rateLimitField;

    public GuiFissionReactorStats(EmptyTileContainer<TileEntityFissionReactorCasing> container, Inventory inv, Component title) {
        super(container, inv, title);
    }

    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget((GuiElement)new GuiFissionReactorTab((IGuiWrapper)this, (TileEntityFissionReactorCasing)this.tile, GuiFissionReactorTab.FissionReactorTab.MAIN));
        this.addRenderableWidget((GuiElement)new GuiDynamicHorizontalRateBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            public Component getTooltip() {
                return GeneratorsLang.GAS_BURN_RATE.translate(new Object[]{((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)((GuiFissionReactorStats)GuiFissionReactorStats.this).tile).getMultiblock()).lastBurnRate});
            }

            public double getLevel() {
                FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)((TileEntityFissionReactorCasing)GuiFissionReactorStats.this.tile).getMultiblock();
                return Math.min(1.0, multiblock.lastBurnRate / (double)multiblock.getMaxBurnRate());
            }
        }, 5, 114, this.imageWidth - 12));
        this.addRenderableWidget((GuiElement)new GuiHeatTab((IGuiWrapper)this, () -> {
            Component environment = MekanismUtils.getTemperatureDisplay((double)((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).lastEnvironmentLoss, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)false);
            return Collections.singletonList(MekanismLang.DISSIPATED_RATE.translate(new Object[]{environment}));
        }));
        this.rateLimitField = (GuiTextField)this.addRenderableWidget((GuiElement)new GuiTextField((IGuiWrapper)this, 77, 128, 54, 12));
        this.rateLimitField.setEnterHandler(this::setRateLimit);
        this.rateLimitField.setInputValidator(InputValidator.DECIMAL);
        long adjustedMaxBurn = Math.max(0L, ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getMaxBurnRate() - 1L);
        this.rateLimitField.setMaxLength(Long.toString(adjustedMaxBurn).length() + 3);
        this.rateLimitField.addCheckmarkButton(this::setRateLimit);
    }

    private void setRateLimit() {
        if (!this.rateLimitField.getText().isEmpty()) {
            try {
                double limit = Double.parseDouble(this.rateLimitField.getText());
                if (limit >= 0.0 && limit <= (double)((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getMaxBurnRate()) {
                    limit = UnitDisplayUtils.roundDecimals((double)limit);
                    PacketUtils.sendToServer((CustomPacketPayload)new PacketGeneratorsGuiInteract(PacketGeneratorsGuiInteract.GeneratorsGuiInteraction.INJECTION_RATE, (BlockEntity)this.tile, limit));
                    this.rateLimitField.setText("");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock();
        this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.FISSION_HEAT_STATISTICS.translate(), 0, 20, IFancyFontRenderer.TextAlignment.LEFT, this.headingTextColor(), 6, false);
        this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.FISSION_HEAT_CAPACITY.translate(new Object[]{TextUtils.format((long)((long)multiblock.heatCapacitor.getHeatCapacity()))}), 0, 32, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), 6, false);
        this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.FISSION_SURFACE_AREA.translate(new Object[]{TextUtils.format((long)multiblock.surfaceArea)}), 0, 42, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), 6, false);
        this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.FISSION_BOIL_EFFICIENCY.translate(new Object[]{((TileEntityFissionReactorCasing)this.tile).getBoilEfficiency()}), 0, 52, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), 6, false);
        this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.FISSION_FUEL_STATISTICS.translate(), 0, 68, IFancyFontRenderer.TextAlignment.LEFT, this.headingTextColor(), 6, false);
        this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.FISSION_MAX_BURN_RATE.translate(new Object[]{TextUtils.format((long)multiblock.getMaxBurnRate())}), 0, 80, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), 6, false);
        this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.FISSION_RATE_LIMIT.translate(new Object[]{multiblock.rateLimit}), 0, 90, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), 6, false);
        this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.FISSION_CURRENT_BURN_RATE.translate(), 0, 104, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), 6, false);
        this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.FISSION_SET_RATE_LIMIT.translate(), 3, 130, IFancyFontRenderer.TextAlignment.RIGHT, this.titleTextColor(), this.rateLimitField.getRelativeX() - 2, 3, false);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

