/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.client.gui.screen;

import io.github.mortuusars.exposure_catalog.ExposureCatalog;
import io.github.mortuusars.exposure_catalog.client.gui.screen.OverlayScreen;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ConfirmScreen
extends Screen
implements OverlayScreen {
    public static final ResourceLocation TEXTURE = ExposureCatalog.resource("textures/gui/confirm.png");
    protected final Screen parent;
    protected final Component message;
    protected final Component yesButtonMsg;
    protected final Button.OnPress onYesButtonPress;
    protected final Component noButtonMsg;
    protected final Button.OnPress onNoButtonPress;
    protected int imageWidth;
    protected int imageHeight;
    protected int leftPos;
    protected int topPos;
    private Button yesButton;
    private Button noButton;

    public ConfirmScreen(Screen parent, Component message, Component yesButtonMsg, Button.OnPress onYesButtonPress, Component noButtonMsg, Button.OnPress onNoButtonPress) {
        super((Component)Component.empty());
        this.parent = parent;
        this.message = message;
        this.yesButtonMsg = yesButtonMsg;
        this.onYesButtonPress = onYesButtonPress;
        this.noButtonMsg = noButtonMsg;
        this.onNoButtonPress = onNoButtonPress;
    }

    protected void init() {
        this.imageWidth = 240;
        this.imageHeight = 88;
        this.leftPos = this.width / 2 - this.imageWidth / 2;
        this.topPos = this.height / 2 - this.imageHeight / 2;
        this.yesButton = Button.builder((Component)this.yesButtonMsg, button -> {
            this.onClose();
            this.onYesButtonPress.onPress(button);
        }).bounds(this.leftPos + 9, this.topPos + 60, 108, 19).build();
        this.addRenderableWidget((GuiEventListener)this.yesButton);
        this.noButton = Button.builder((Component)this.noButtonMsg, button -> {
            this.onClose();
            this.onNoButtonPress.onPress(button);
        }).bounds(this.leftPos + 123, this.topPos + 60, 108, 19).build();
        this.addRenderableWidget((GuiEventListener)this.noButton);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        List messageLines = this.font.split((FormattedText)this.message, 221);
        int n = messageLines.size();
        Objects.requireNonNull(this.font);
        int messageY = 28 - n * 9 / 2;
        for (int i = 0; i < messageLines.size(); ++i) {
            FormattedCharSequence messageLine = (FormattedCharSequence)messageLines.get(i);
            int n2 = this.leftPos + 120 - this.font.width(messageLine) / 2;
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, messageLine, n2, this.topPos + messageY + i * 9, -12500671, false);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.getFocused() == null && keyCode == 257) {
            this.yesButton.onPress();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public Screen getParent() {
        return this.parent;
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.getParent());
    }
}

