/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.handler;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.camera.CameraClient;
import io.github.mortuusars.exposure.client.capture.palettizer.Palettizer;
import io.github.mortuusars.exposure.client.capture.saving.ExposureUploader;
import io.github.mortuusars.exposure.client.capture.template.CaptureTemplate;
import io.github.mortuusars.exposure.client.capture.template.CaptureTemplates;
import io.github.mortuusars.exposure.client.gui.screen.FilmFrameInspectScreen;
import io.github.mortuusars.exposure.client.gui.screen.PhotographScreen;
import io.github.mortuusars.exposure.client.image.Image;
import io.github.mortuusars.exposure.client.image.TrichromeImage;
import io.github.mortuusars.exposure.client.sound.UniqueSoundManager;
import io.github.mortuusars.exposure.client.sound.instance.ShutterTickingSoundInstance;
import io.github.mortuusars.exposure.client.task.ExportExposuresTask;
import io.github.mortuusars.exposure.client.task.ExposureRetrieveTask;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.data.ColorPalette;
import io.github.mortuusars.exposure.data.ColorPalettes;
import io.github.mortuusars.exposure.network.packet.clientbound.CameraStandStopControllingS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.CaptureStartDebugRGBS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.CaptureStartS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.CreateChromaticExposureS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.ExportS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.ExposureDataChangedS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.ShaderApplyS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.ShowExposureCommandS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.UniqueSoundPlayShutterTickingS2CP;
import io.github.mortuusars.exposure.util.UnixTimestamp;
import io.github.mortuusars.exposure.util.cycles.task.Result;
import io.github.mortuusars.exposure.util.cycles.task.Task;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.capture.CaptureParameters;
import io.github.mortuusars.exposure.world.entity.CameraStandEntity;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import io.github.mortuusars.exposure.world.level.storage.ExposureData;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;

public class ClientPacketsHandler {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void applyShader(ShaderApplyS2CP packet) {
        packet.shaderLocation().ifPresentOrElse(shader -> Minecrft.get().gameRenderer.loadEffect(shader), () -> Minecrft.get().gameRenderer.shutdownEffect());
    }

    public static void showExposure(ShowExposureCommandS2CP packet) {
        if (packet.negative()) {
            FilmFrameInspectScreen screen = new FilmFrameInspectScreen(packet.frames());
            Minecrft.get().setScreen((Screen)screen);
            return;
        }
        ArrayList<ItemAndStack<PhotographItem>> photographs = new ArrayList<ItemAndStack<PhotographItem>>(packet.frames().stream().map(frame -> {
            ItemStack photographStack = new ItemStack((ItemLike)Exposure.Items.PHOTOGRAPH.get());
            photographStack.set(Exposure.DataComponents.PHOTOGRAPH_FRAME, frame);
            return new ItemAndStack(photographStack);
        }).toList());
        Collections.reverse(photographs);
        PhotographScreen screen = new PhotographScreen(photographs);
        Minecrft.get().setScreen((Screen)screen);
    }

    public static void exportExposures(ExportS2CP packet) {
        ExportExposuresTask.start(packet.ids(), packet.size(), packet.look());
    }

    public static void stopExportTask() {
        if (!ExportExposuresTask.stopCurrentTask()) {
            Minecrft.player().displayClientMessage((Component)Component.translatable((String)"task.exposure.export.not_running").withStyle(ChatFormatting.RED), false);
        }
    }

    public static void clearRenderingCache() {
        ExposureClient.imageRenderer().clearCache();
        ExposureClient.renderedExposures().clearCache();
    }

    public static void exposureDataChanged(ExposureDataChangedS2CP packet) {
        ExposureClient.exposureStore().refresh(packet.id());
        ExposureClient.imageRenderer().clearCacheOf(packet.id());
        ExposureClient.renderedExposures().clearCacheOf(packet.id());
    }

    public static void createChromaticExposure(CreateChromaticExposureS2CP packet) {
        if (packet.id().isEmpty()) {
            LOGGER.error("Cannot create chromatic exposure: identifier is empty.");
            return;
        }
        if (packet.layers().size() != 3) {
            LOGGER.error("Cannot create chromatic exposure: 3 layers required. Provided: '{}'.", (Object)packet.layers().size());
            return;
        }
        Holder<ColorPalette> colorPalette = ColorPalettes.getDefault(Minecrft.registryAccess());
        ColorPalette palette = (ColorPalette)colorPalette.value();
        ResourceLocation paletteId = ((ResourceKey)colorPalette.unwrapKey().orElseThrow()).location();
        ExposureClient.cycles().addParallelTask(new ExposureRetrieveTask(packet.layers(), 20000).then(Result::unwrap).thenAsync(layers -> new TrichromeImage((Image)layers.get(0), (Image)layers.get(1), (Image)layers.get(2))).thenAsync(Palettizer.DITHERED.palettizeAndClose(palette)).thenAsync(img -> new ExposureData(img.width(), img.height(), img.pixels(), paletteId, new ExposureData.Tag(ExposureType.COLOR, Minecrft.player().getScoreboardName(), UnixTimestamp.Seconds.now(), false, false))).acceptAsync(ExposureUploader.upload(packet.id())));
    }

    public static void startCapture(CaptureStartS2CP packet) {
        Task<?> captureTask = CaptureTemplates.getOrThrow(packet.templateId()).createTask(packet.captureParameters());
        ExposureClient.cycles().enqueueTask(captureTask);
    }

    public static void startDebugRGBCapture(CaptureStartDebugRGBS2CP packet) {
        CaptureTemplate template = CaptureTemplates.getOrThrow(packet.templateId());
        for (CaptureParameters captureParameters : packet.captureProperties()) {
            Task<?> captureTask = template.createTask(captureParameters);
            ExposureClient.cycles().enqueueTask(captureTask);
        }
    }

    public static void shutterOpened() {
        if (CameraClient.viewfinder() != null) {
            CameraClient.viewfinder().overlay().startDrawingShutter();
        }
    }

    public static void playShutterTickingSound(UniqueSoundPlayShutterTickingS2CP packet) {
        Entity entity = Minecrft.player().level().getEntity(packet.entityId());
        if (entity != null) {
            ShutterTickingSoundInstance instance = new ShutterTickingSoundInstance(entity, packet.cameraId(), Exposure.SoundEvents.SHUTTER_TICKING.get(), entity.getSoundSource(), packet.volume(), packet.pitch(), packet.durationTicks());
            UniqueSoundManager.play(packet.cameraId().toString(), (SoundInstance)instance);
        }
    }

    public static void stopControllingCameraStand(CameraStandStopControllingS2CP packet) {
        Entity entity;
        if (Minecrft.get().cameraEntity != Minecrft.player() && (entity = Minecrft.level().getEntity(packet.standId())) instanceof CameraStandEntity) {
            CameraStandEntity stand = (CameraStandEntity)entity;
            stand.stopControlling();
            CameraClient.setCameraEntity((Entity)Minecrft.player());
        }
    }
}

